/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.NameClassSplitter;
import com.thaiopensource.relaxng.output.dtd.Analysis;
import com.thaiopensource.relaxng.output.dtd.AttributeType;
import com.thaiopensource.relaxng.output.dtd.ContentType;
import com.thaiopensource.relaxng.output.dtd.Datatypes;
import com.thaiopensource.relaxng.output.dtd.GrammarPart;
import com.thaiopensource.relaxng.output.dtd.ModelBreaker;
import com.thaiopensource.xml.out.CharRepertoire;
import com.thaiopensource.xml.util.Naming;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

class DtdOutput {
    private final boolean warnDatatypes;
    private final String sourceUri;
    private Writer writer;
    private String encoding;
    private CharRepertoire charRepertoire;
    private final int indent;
    private final int lineLength;
    private final String lineSep;
    final StringBuffer buf = new StringBuffer();
    final List elementQueue = new Vector();
    final List requiredParamEntities = new Vector();
    final List externallyRequiredParamEntities = new Vector();
    final Set doneParamEntities = new HashSet();
    final Set doneIncludes = new HashSet();
    final Set pendingIncludes = new HashSet();
    private final Analysis analysis;
    private final GrammarPart part;
    private final OutputDirectory od;
    private final ErrorReporter er;
    private final Set reservedEntityNames;
    final PatternVisitor topLevelContentModelOutput = new TopLevelContentModelOutput();
    final AbstractVisitor nestedContentModelOutput = new ContentModelOutput();
    final PatternVisitor expandedContentModelOutput = new ExpandedContentModelOutput();
    final PatternVisitor groupContentModelOutput = new GroupContentModelOutput();
    final PatternVisitor choiceContentModelOutput = new ChoiceContentModelOutput();
    final PatternVisitor occurContentModelOutput = new ParenthesizedContentModelOutput();
    final PatternVisitor innerElementClassOutput = new InnerElementClassOutput();
    final PatternVisitor expandedInnerElementClassOutput = new ExpandedInnerElementClassOutput();
    final AttributeOutput attributeOutput = new AttributeOutput();
    final AttributeOutput optionalAttributeOutput = new OptionalAttributeOutput();
    final PatternVisitor topLevelSimpleTypeOutput = new TopLevelSimpleTypeOutput();
    final PatternVisitor nestedSimpleTypeOutput = new SimpleTypeOutput();
    final PatternVisitor valueOutput = new ValueOutput();
    final GrammarOutput grammarOutput = new GrammarOutput();
    private static final String DTD_URI = "http://www.thaiopensource.com/ns/relaxng/dtd";

    private DtdOutput(boolean bl, String string2, Analysis analysis, Set set, OutputDirectory outputDirectory, ErrorReporter errorReporter) {
        this.warnDatatypes = bl;
        this.sourceUri = string2;
        this.analysis = analysis;
        this.reservedEntityNames = set;
        this.od = outputDirectory;
        this.er = errorReporter;
        this.part = analysis.getGrammarPart(string2);
        try {
            OutputDirectory.Stream stream = outputDirectory.open(string2, analysis.getEncoding(string2));
            this.encoding = stream.getEncoding();
            this.writer = stream.getWriter();
            this.charRepertoire = stream.getCharRepertoire();
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
        this.lineSep = outputDirectory.getLineSeparator();
        this.indent = outputDirectory.getIndent();
        this.lineLength = outputDirectory.getLineLength();
    }

    void outputQueuedElements() {
        int n = 0;
        while (n < this.elementQueue.size()) {
            this.outputElement((ElementPattern)this.elementQueue.get(n), null);
            ++n;
        }
        this.elementQueue.clear();
    }

    static void output(boolean bl, Analysis analysis, OutputDirectory outputDirectory, ErrorReporter errorReporter) throws IOException {
        try {
            new DtdOutput(bl, analysis.getMainUri(), analysis, new HashSet(), outputDirectory, errorReporter).topLevelOutput();
        }
        catch (WrappedIOException wrappedIOException) {
            throw wrappedIOException.cause;
        }
    }

    void topLevelOutput() {
        GrammarPattern grammarPattern = this.analysis.getGrammarPattern();
        this.xmlDecl();
        Pattern pattern = this.analysis.getPattern();
        if (pattern != grammarPattern) {
            this.outputLeadingComments(pattern);
            pattern.accept(this.nestedContentModelOutput);
            this.outputQueuedElements();
        }
        if (grammarPattern != null) {
            this.outputLeadingComments(grammarPattern);
            this.outputInitialChildComments(grammarPattern);
            this.grammarOutput.visitContainer(grammarPattern);
            this.outputFollowingComments(grammarPattern);
        }
        this.close();
    }

    void subOutput(GrammarPattern grammarPattern) {
        this.xmlDecl();
        this.outputLeadingComments(grammarPattern);
        this.outputInitialChildComments(grammarPattern);
        this.grammarOutput.visitContainer(grammarPattern);
        this.outputFollowingComments(grammarPattern);
        this.close();
    }

    void xmlDecl() {
        this.write("<?xml encoding=\"");
        this.write(this.encoding);
        this.write("\"?>");
        this.outputNewline();
    }

    ContentType getContentType(Pattern pattern) {
        return this.analysis.getContentType(pattern);
    }

    AttributeType getAttributeType(Pattern pattern) {
        return this.analysis.getAttributeType(pattern);
    }

    Pattern getBody(String string2) {
        return this.analysis.getBody(string2);
    }

    void paramEntityRef(RefPattern refPattern) {
        String string2 = refPattern.getName();
        this.buf.append('%');
        this.buf.append(string2);
        this.buf.append(';');
        this.requiredParamEntities.add(string2);
    }

    void attributeValueLiteral(String string2) {
        this.buf.append('\'');
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            char c = string2.charAt(n);
            switch (c) {
                case '<': {
                    this.buf.append("&lt;");
                    break;
                }
                case '&': {
                    this.buf.append("&amp;");
                    break;
                }
                case '\'': {
                    this.buf.append("&apos;");
                    break;
                }
                case '\"': {
                    this.buf.append("&quot;");
                    break;
                }
                case '\r': {
                    this.buf.append("&#xD;");
                    break;
                }
                case '\n': {
                    this.buf.append("&#xA;");
                    break;
                }
                case '\t': {
                    this.buf.append("&#9;");
                    break;
                }
                default: {
                    this.buf.append(c);
                }
            }
            ++n;
        }
        this.buf.append('\'');
    }

    void outputRequiredComponents() {
        int n = 0;
        while (n < this.requiredParamEntities.size()) {
            String string2 = (String)this.requiredParamEntities.get(n);
            Component component = this.part.getWhereProvided(string2);
            if (component == null) {
                this.externallyRequiredParamEntities.add(string2);
            } else if (component instanceof DefineComponent) {
                if (!this.doneParamEntities.contains(string2)) {
                    this.doneParamEntities.add(string2);
                    this.outputParamEntity((DefineComponent)component);
                }
            } else {
                this.outputInclude((IncludeComponent)component);
            }
            ++n;
        }
        this.requiredParamEntities.clear();
    }

    void outputInclude(IncludeComponent includeComponent) {
        String string2 = includeComponent.getHref();
        if (this.doneIncludes.contains(string2)) {
            return;
        }
        if (this.pendingIncludes.contains(string2)) {
            this.er.error("sorry_include_depend", includeComponent.getSourceLocation());
            return;
        }
        this.pendingIncludes.add(string2);
        DtdOutput dtdOutput = new DtdOutput(this.warnDatatypes, string2, this.analysis, this.reservedEntityNames, this.od, this.er);
        GrammarPattern grammarPattern = (GrammarPattern)this.analysis.getSchema(string2);
        dtdOutput.subOutput(grammarPattern);
        this.requiredParamEntities.addAll(dtdOutput.externallyRequiredParamEntities);
        this.outputRequiredComponents();
        this.outputLeadingComments(includeComponent);
        String string3 = this.genEntityName(includeComponent);
        this.outputNewline();
        this.write("<!ENTITY % ");
        this.write(string3);
        this.write(" SYSTEM ");
        this.write('\"');
        this.write(this.od.reference(this.sourceUri, string2));
        this.write('\"');
        this.write('>');
        this.outputNewline();
        this.write('%');
        this.write(string3);
        this.write(';');
        this.outputNewline();
        this.outputFollowingComments(includeComponent);
        this.doneIncludes.add(string2);
        this.pendingIncludes.remove(string2);
    }

    String genEntityName(IncludeComponent includeComponent) {
        String string2 = DtdOutput.getAttributeAnnotation(includeComponent, DTD_URI, "entityName");
        if (string2 != null && !Naming.isNcname(string2 = string2.trim())) {
            this.er.warning("entity_name_not_ncname", string2, includeComponent.getSourceLocation());
            string2 = null;
        }
        if (string2 == null) {
            int n;
            String string3 = includeComponent.getHref();
            int n2 = string3.lastIndexOf(47);
            if (n2 >= 0) {
                string3 = string3.substring(n2 + 1);
            }
            if ((n = string3.lastIndexOf(46)) > 0) {
                string3 = string3.substring(0, n);
            }
            if (Naming.isNcname(string3)) {
                string2 = string3;
            }
        }
        if (string2 == null) {
            string2 = "ent";
        }
        if (!this.reserveEntityName(string2)) {
            int n = 1;
            while (true) {
                String string4;
                if (this.reserveEntityName(string4 = string2 + Integer.toString(n))) {
                    string2 = string4;
                    break;
                }
                ++n;
            }
        }
        return string2;
    }

    private boolean reserveEntityName(String string2) {
        if (this.reservedEntityNames.contains(string2)) {
            return false;
        }
        this.reservedEntityNames.add(string2);
        return true;
    }

    void outputParamEntity(DefineComponent defineComponent) {
        String string2 = defineComponent.getName();
        Pattern pattern = defineComponent.getBody();
        ContentType contentType = this.getContentType(pattern);
        this.buf.setLength(0);
        boolean bl = true;
        if (contentType.isA(ContentType.MODEL_GROUP) || contentType.isA(ContentType.NOT_ALLOWED) || contentType.isA(ContentType.MIXED_ELEMENT_CLASS)) {
            pattern.accept(this.nestedContentModelOutput);
        } else if (contentType.isA(ContentType.MIXED_MODEL)) {
            pattern.accept(this.topLevelContentModelOutput);
        } else if (contentType.isA(ContentType.EMPTY)) {
            this.attributeOutput.output(pattern);
            bl = false;
        } else if (contentType.isA(ContentType.ENUM)) {
            pattern.accept(this.nestedSimpleTypeOutput);
        } else if (contentType.isA(ContentType.VALUE)) {
            pattern.accept(this.valueOutput);
            bl = false;
        } else if (contentType.isA(ContentType.SIMPLE_TYPE)) {
            pattern.accept(this.topLevelSimpleTypeOutput);
        }
        String string3 = this.buf.toString();
        this.outputRequiredComponents();
        this.outputLeadingComments(defineComponent);
        String string4 = this.analysis.getParamEntityElementName(string2);
        if (string4 != null) {
            if (string3.length() > 0) {
                this.outputNewline();
                this.write("<!ATTLIST ");
                this.write(string4);
                this.outputAttributeNamespaces(pattern);
                this.write(string3);
                this.write('>');
                this.outputNewline();
            }
        } else {
            this.doneParamEntities.add(string2);
            this.outputNewline();
            String string5 = "<!ENTITY % " + string2 + " \"";
            String string6 = "\">";
            if (!bl) {
                this.write(string5);
                this.write(string3);
                this.write(string6);
                this.outputNewline();
            } else {
                this.outputModelBreak(string5, string3, string6);
            }
        }
        this.outputFollowingComments(defineComponent);
    }

    private void outputModelBreak(String string2, String string3, String string4) {
        ModelBreaker modelBreaker = new ModelBreaker(string2, string3, string4, this.lineLength);
        while (modelBreaker.hasNextLine()) {
            this.write(modelBreaker.nextLine());
            this.outputNewline();
        }
    }

    void outputElement(ElementPattern elementPattern, Annotated annotated) {
        this.buf.setLength(0);
        Pattern pattern = elementPattern.getChild();
        ContentType contentType = this.getContentType(pattern);
        if (contentType != ContentType.EMPTY) {
            if (contentType == ContentType.MIXED_ELEMENT_CLASS) {
                this.er.warning("mixed_choice_approx", elementPattern.getSourceLocation());
                this.buf.append("(");
                pattern.accept(this.nestedContentModelOutput);
                this.buf.append(")*");
            } else if (contentType.isA(ContentType.SIMPLE_TYPE)) {
                if (this.warnDatatypes) {
                    this.er.warning("data_content_approx", elementPattern.getSourceLocation());
                }
                this.buf.append("(#PCDATA)");
            } else {
                if (contentType == ContentType.NOT_ALLOWED) {
                    return;
                }
                pattern.accept(this.topLevelContentModelOutput);
            }
        }
        String string2 = this.buf.length() == 0 ? "EMPTY" : this.buf.toString();
        this.buf.setLength(0);
        this.attributeOutput.output(pattern);
        String string3 = this.buf.toString();
        this.outputRequiredComponents();
        if (annotated != null) {
            this.outputLeadingComments(annotated);
        }
        this.outputLeadingComments(elementPattern);
        List list2 = NameClassSplitter.split(elementPattern.getNameClass());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            String string4;
            String string5;
            NameNameClass nameNameClass = (NameNameClass)iterator.next();
            String string6 = nameNameClass.getNamespaceUri();
            if (string6.equals("") || string6.equals(this.analysis.getDefaultNamespaceUri()) || string6 == NameClass.INHERIT_NS) {
                string5 = nameNameClass.getLocalName();
                string4 = null;
            } else {
                string4 = this.analysis.getPrefixForNamespaceUri(string6);
                string5 = string4 + ":" + nameNameClass.getLocalName();
            }
            this.outputNewline();
            this.outputModelBreak("<!ELEMENT " + string5 + " ", string2, ">");
            if (string6 == NameClass.INHERIT_NS) {
                bl = false;
            } else if (string4 == null) {
                bl = true;
            } else {
                boolean bl2 = bl = !this.analysis.getAttributeNamespaces(pattern).contains(string6);
            }
            if (string3.length() == 0 && !bl) continue;
            this.write("<!ATTLIST ");
            this.write(string5);
            if (bl) {
                this.outputNewline();
                this.outputIndent();
                if (string4 != null) {
                    this.write("xmlns:");
                    this.write(string4);
                } else {
                    this.write("xmlns");
                }
                this.write(" CDATA #FIXED ");
                this.buf.setLength(0);
                this.attributeValueLiteral(string6);
                this.write(this.buf.toString());
            }
            if (string3.length() != 0) {
                this.outputAttributeNamespaces(pattern);
            }
            this.write(string3);
            this.write('>');
            this.outputNewline();
        }
        if (annotated != null) {
            this.outputFollowingComments(annotated);
        }
    }

    void outputAttributeNamespaces(Pattern pattern) {
        Set set = this.analysis.getAttributeNamespaces(pattern);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.analysis.getPrefixForNamespaceUri(string2);
            this.outputNewline();
            this.outputIndent();
            this.write("xmlns:");
            this.write(string3);
            this.write(" CDATA #FIXED ");
            this.buf.setLength(0);
            this.attributeValueLiteral(string2);
            this.write(this.buf.toString());
        }
    }

    void outputLeadingComments(Annotated annotated) {
        this.outputComments(annotated.getLeadingComments());
    }

    void outputInitialChildComments(Annotated annotated) {
        this.outputComments(annotated.getChildElementAnnotations());
    }

    void outputFollowingComments(Annotated annotated) {
        this.outputComments(annotated.getFollowingElementAnnotations());
    }

    void outputComments(List list2) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            AnnotationChild annotationChild = (AnnotationChild)iterator.next();
            if (!(annotationChild instanceof Comment)) continue;
            this.outputComment(((Comment)annotationChild).getValue());
        }
    }

    void outputComment(String string2) {
        this.outputNewline();
        this.write("<!--");
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string2.indexOf(10, n)) < 0) {
                if (n == 0) {
                    this.write(' ');
                    this.write(string2);
                    this.write(' ');
                    break;
                }
                this.outputNewline();
                this.write(string2.substring(n));
                this.outputNewline();
                break;
            }
            this.outputNewline();
            this.write(string2.substring(n, n2));
            n = n2 + 1;
        }
        this.write("-->");
        this.outputNewline();
    }

    void outputIndent() {
        int n = 0;
        while (n < this.indent) {
            this.write(' ');
            ++n;
        }
    }

    void outputNewline() {
        this.write(this.lineSep);
    }

    void write(String string2) {
        try {
            this.writer.write(string2);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    void write(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    private static String getDefaultValue(AttributePattern attributePattern) {
        return DtdOutput.getAttributeAnnotation(attributePattern, "http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue");
    }

    private static String getAttributeAnnotation(Annotated annotated, String string2, String string3) {
        List list2 = annotated.getAttributeAnnotations();
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            AttributeAnnotation attributeAnnotation = (AttributeAnnotation)list2.get(n);
            if (attributeAnnotation.getLocalName().equals(string3) && attributeAnnotation.getNamespaceUri().equals(string2)) {
                return attributeAnnotation.getValue();
            }
            ++n;
        }
        return null;
    }

    static class WrappedIOException
    extends RuntimeException {
        final IOException cause;

        WrappedIOException(IOException iOException) {
            this.cause = iOException;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    class GrammarOutput
    extends AbstractVisitor {
        GrammarOutput() {
        }

        public void visitContainer(Container container) {
            List list2 = container.getComponents();
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                ((Component)list2.get(n)).accept(this);
                ++n;
            }
        }

        public Object visitDiv(DivComponent divComponent) {
            DtdOutput.this.outputLeadingComments(divComponent);
            DtdOutput.this.outputInitialChildComments(divComponent);
            this.visitContainer(divComponent);
            DtdOutput.this.outputFollowingComments(divComponent);
            return null;
        }

        public Object visitDefine(DefineComponent defineComponent) {
            if (defineComponent.getName() == DefineComponent.START) {
                DtdOutput.this.outputLeadingComments(defineComponent);
                DtdOutput.this.outputFollowingComments(defineComponent);
                if (DtdOutput.this.analysis.getPattern() == DtdOutput.this.analysis.getGrammarPattern()) {
                    defineComponent.getBody().accept(DtdOutput.this.nestedContentModelOutput);
                }
            } else if (DtdOutput.this.getContentType(defineComponent.getBody()) == ContentType.DIRECT_SINGLE_ELEMENT) {
                DtdOutput.this.outputElement((ElementPattern)defineComponent.getBody(), defineComponent);
            } else if (!DtdOutput.this.doneParamEntities.contains(defineComponent.getName())) {
                DtdOutput.this.doneParamEntities.add(defineComponent.getName());
                DtdOutput.this.outputParamEntity(defineComponent);
            }
            DtdOutput.this.outputQueuedElements();
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            DtdOutput.this.outputInclude(includeComponent);
            return null;
        }
    }

    class ValueOutput
    extends AbstractVisitor {
        ValueOutput() {
        }

        public Object visitValue(ValuePattern valuePattern) {
            DtdOutput.this.buf.append("CDATA #FIXED ");
            DtdOutput.this.attributeValueLiteral(valuePattern.getValue());
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            DtdOutput.this.paramEntityRef(refPattern);
            return null;
        }
    }

    class TopLevelSimpleTypeOutput
    extends SimpleTypeOutput {
        TopLevelSimpleTypeOutput() {
        }

        public Object visitList(ListPattern listPattern) {
            if (DtdOutput.this.warnDatatypes) {
                DtdOutput.this.er.warning("list_approx", listPattern.getSourceLocation());
            }
            DtdOutput.this.buf.append("CDATA");
            return null;
        }

        public Object visitValue(ValuePattern valuePattern) {
            if (DtdOutput.this.getContentType(valuePattern) == ContentType.ENUM) {
                DtdOutput.this.buf.append('(');
                super.visitValue(valuePattern);
                DtdOutput.this.buf.append(')');
            } else {
                Datatypes.Info info = Datatypes.getInfo(valuePattern.getDatatypeLibrary(), valuePattern.getType());
                if (info == null) {
                    DtdOutput.this.er.warning("unrecognized_datatype", valuePattern.getSourceLocation());
                    DtdOutput.this.buf.append("CDATA");
                } else {
                    String string2 = info.closestType();
                    if (DtdOutput.this.warnDatatypes) {
                        DtdOutput.this.er.warning("value_approx", string2, valuePattern.getSourceLocation());
                    }
                    DtdOutput.this.buf.append(string2);
                }
            }
            return null;
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            ContentType contentType = DtdOutput.this.getContentType(choicePattern);
            if (contentType == ContentType.ENUM) {
                DtdOutput.this.buf.append('(');
                DtdOutput.this.nestedSimpleTypeOutput.visitChoice(choicePattern);
                DtdOutput.this.buf.append(')');
            } else if (contentType == ContentType.SIMPLE_TYPE_CHOICE) {
                if (DtdOutput.this.warnDatatypes) {
                    DtdOutput.this.er.warning("datatype_choice_approx", choicePattern.getSourceLocation());
                }
                DtdOutput.this.buf.append("CDATA");
            } else {
                super.visitChoice(choicePattern);
            }
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            ContentType contentType = DtdOutput.this.getContentType(refPattern);
            if (contentType == ContentType.ENUM) {
                DtdOutput.this.buf.append('(');
                super.visitRef(refPattern);
                DtdOutput.this.buf.append(')');
            } else if (contentType == ContentType.TEXT) {
                DtdOutput.this.buf.append("CDATA");
            } else {
                super.visitRef(refPattern);
            }
            return null;
        }
    }

    class SimpleTypeOutput
    extends AbstractVisitor {
        SimpleTypeOutput() {
        }

        public Object visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append("CDATA");
            return null;
        }

        public Object visitValue(ValuePattern valuePattern) {
            DtdOutput.this.buf.append(valuePattern.getValue());
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            DtdOutput.this.paramEntityRef(refPattern);
            return null;
        }

        public Object visitData(DataPattern dataPattern) {
            Datatypes.Info info = Datatypes.getInfo(dataPattern.getDatatypeLibrary(), dataPattern.getType());
            if (info == null) {
                DtdOutput.this.er.warning("unrecognized_datatype", dataPattern.getSourceLocation());
                DtdOutput.this.buf.append("CDATA");
            } else if (DtdOutput.this.warnDatatypes) {
                if (!info.isExact()) {
                    DtdOutput.this.er.warning("datatype_approx", dataPattern.getType(), info.closestType(), dataPattern.getSourceLocation());
                } else {
                    if (dataPattern.getParams().size() > 0) {
                        DtdOutput.this.er.warning("ignore_params", dataPattern.getSourceLocation());
                    }
                    if (dataPattern.getExcept() != null) {
                        DtdOutput.this.er.warning("ignore_except", dataPattern.getSourceLocation());
                    }
                }
                DtdOutput.this.buf.append(info.closestType());
            }
            return null;
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            Object object;
            List list2 = choicePattern.getChildren();
            boolean bl = false;
            int n = list2.size();
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = (Pattern)list2.get(n2);
                object = DtdOutput.this.getContentType(pattern);
                if (object != ContentType.NOT_ALLOWED) {
                    if (bl) {
                        DtdOutput.this.buf.append('|');
                    } else {
                        bl = true;
                    }
                    pattern.accept(this);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                object = (Pattern)list2.get(n3);
                ContentType contentType = DtdOutput.this.getContentType((Pattern)object);
                if (contentType == ContentType.NOT_ALLOWED) {
                    if (bl) {
                        DtdOutput.this.buf.append(' ');
                    } else {
                        bl = true;
                    }
                    ((Pattern)object).accept(this);
                }
                ++n3;
            }
            return null;
        }
    }

    class OptionalAttributeOutput
    extends AttributeOutput {
        OptionalAttributeOutput() {
        }

        boolean isRequired() {
            return false;
        }
    }

    class AttributeOutput
    extends AbstractVisitor {
        AttributeOutput() {
        }

        void output(Pattern pattern) {
            if (DtdOutput.this.getAttributeType(pattern) != AttributeType.EMPTY) {
                pattern.accept(this);
            }
        }

        void newlineIndent() {
            DtdOutput.this.buf.append(DtdOutput.this.lineSep);
            int n = 0;
            while (n < DtdOutput.this.indent) {
                DtdOutput.this.buf.append(' ');
                ++n;
            }
        }

        public Object visitComposite(CompositePattern compositePattern) {
            List list2 = compositePattern.getChildren();
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                this.output((Pattern)list2.get(n));
                ++n;
            }
            return null;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            this.output(mixedPattern.getChild());
            return null;
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            this.output(oneOrMorePattern.getChild());
            return null;
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            if (DtdOutput.this.getAttributeType(zeroOrMorePattern) != AttributeType.SINGLE) {
                DtdOutput.this.er.warning("attribute_occur_approx", zeroOrMorePattern.getSourceLocation());
            }
            DtdOutput.this.optionalAttributeOutput.output(zeroOrMorePattern.getChild());
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            ContentType contentType = DtdOutput.this.getContentType(refPattern);
            if (contentType.isA(ContentType.EMPTY) && this.isRequired()) {
                if (DtdOutput.this.analysis.getParamEntityElementName(refPattern.getName()) == null) {
                    this.newlineIndent();
                    DtdOutput.this.paramEntityRef(refPattern);
                }
            } else {
                this.output(DtdOutput.this.getBody(refPattern.getName()));
            }
            return null;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            ContentType contentType = DtdOutput.this.getContentType(attributePattern.getChild());
            if (contentType == ContentType.NOT_ALLOWED) {
                return null;
            }
            List list2 = NameClassSplitter.split(attributePattern.getNameClass());
            int n = list2.size();
            if (n > 1) {
                DtdOutput.this.er.warning("attribute_occur_approx", attributePattern.getSourceLocation());
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = DtdOutput.this.buf.length();
                this.newlineIndent();
                NameNameClass nameNameClass = (NameNameClass)list2.get(n2);
                String string2 = nameNameClass.getNamespaceUri();
                if (!string2.equals("") && string2 != NameClass.INHERIT_NS) {
                    String string3 = DtdOutput.this.analysis.getPrefixForNamespaceUri(string2);
                    DtdOutput.this.buf.append(string3);
                    DtdOutput.this.buf.append(':');
                }
                DtdOutput.this.buf.append(nameNameClass.getLocalName());
                DtdOutput.this.buf.append(' ');
                if (contentType == ContentType.VALUE) {
                    attributePattern.getChild().accept(DtdOutput.this.valueOutput);
                } else {
                    int n4 = DtdOutput.this.buf.length();
                    if (contentType.isA(ContentType.SIMPLE_TYPE) || contentType == ContentType.TEXT) {
                        attributePattern.getChild().accept(DtdOutput.this.topLevelSimpleTypeOutput);
                    } else if (contentType == ContentType.EMPTY) {
                        DtdOutput.this.er.warning("empty_attribute_approx", attributePattern.getSourceLocation());
                        DtdOutput.this.buf.append("CDATA");
                    }
                    int n5 = DtdOutput.this.buf.length();
                    if (this.isRequired() && n == 1) {
                        DtdOutput.this.buf.append(" #REQUIRED");
                    } else {
                        String string4 = DtdOutput.getDefaultValue(attributePattern);
                        if (string4 == null) {
                            DtdOutput.this.buf.append(" #IMPLIED");
                        } else {
                            DtdOutput.this.buf.append(' ');
                            DtdOutput.this.attributeValueLiteral(string4);
                        }
                    }
                    int n6 = n3 + DtdOutput.this.lineSep.length();
                    if (DtdOutput.this.buf.length() - n6 > DtdOutput.this.lineLength && contentType.isA(ContentType.ENUM)) {
                        ModelBreaker modelBreaker = new ModelBreaker(DtdOutput.this.buf.substring(n6, n4), DtdOutput.this.buf.substring(n4, n5), DtdOutput.this.buf.substring(n5), DtdOutput.this.lineLength);
                        DtdOutput.this.buf.setLength(n3);
                        while (modelBreaker.hasNextLine()) {
                            DtdOutput.this.buf.append(DtdOutput.this.lineSep);
                            DtdOutput.this.buf.append(modelBreaker.nextLine());
                        }
                    }
                }
                ++n2;
            }
            return null;
        }

        boolean isRequired() {
            return true;
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            if (DtdOutput.this.getAttributeType(choicePattern) != AttributeType.EMPTY) {
                DtdOutput.this.er.warning("attribute_occur_approx", choicePattern.getSourceLocation());
            }
            DtdOutput.this.optionalAttributeOutput.visitComposite(choicePattern);
            return null;
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            if (DtdOutput.this.getAttributeType(optionalPattern) != AttributeType.SINGLE) {
                DtdOutput.this.er.warning("attribute_occur_approx", optionalPattern.getSourceLocation());
            }
            DtdOutput.this.optionalAttributeOutput.output(optionalPattern.getChild());
            return null;
        }
    }

    class ExpandedInnerElementClassOutput
    extends InnerElementClassOutput {
        ExpandedInnerElementClassOutput() {
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.getChild().accept(DtdOutput.this.expandedContentModelOutput);
            return null;
        }
    }

    class InnerElementClassOutput
    extends AbstractVisitor {
        InnerElementClassOutput() {
        }

        public Object visitRef(RefPattern refPattern) {
            DtdOutput.this.getBody(refPattern.getName()).accept(DtdOutput.this.expandedInnerElementClassOutput);
            return null;
        }

        public Object visitComposite(CompositePattern compositePattern) {
            List list2 = compositePattern.getChildren();
            boolean bl = false;
            int n = -1;
            int n2 = 0;
            int n3 = list2.size();
            while (n2 < n3) {
                Pattern pattern = (Pattern)list2.get(n2);
                ContentType contentType = DtdOutput.this.getContentType(pattern);
                if (contentType.isA(ContentType.MIXED_MODEL) || contentType == ContentType.TEXT) {
                    pattern.accept(this);
                    bl = true;
                    n = n2;
                    break;
                }
                ++n2;
            }
            int n4 = 0;
            int n5 = list2.size();
            while (n4 < n5) {
                Pattern pattern;
                if (n4 != n && DtdOutput.this.getContentType(pattern = (Pattern)list2.get(n4)) != ContentType.EMPTY) {
                    if (bl) {
                        DtdOutput.this.buf.append('|');
                    } else {
                        bl = true;
                    }
                    pattern.accept(this);
                }
                ++n4;
            }
            return null;
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            return null;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            if (DtdOutput.this.getContentType(mixedPattern.getChild()) == ContentType.EMPTY) {
                DtdOutput.this.buf.append("#PCDATA");
            } else {
                DtdOutput.this.buf.append("#PCDATA|");
                mixedPattern.getChild().accept(this);
            }
            return null;
        }

        public Object visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append("#PCDATA");
            return null;
        }
    }

    class ExpandedContentModelOutput
    extends ContentModelOutput {
        ExpandedContentModelOutput() {
        }

        public Object visitElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            return null;
        }
    }

    class TopLevelContentModelOutput
    extends ContentModelOutput {
        TopLevelContentModelOutput() {
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            DtdOutput.this.buf.append('(');
            zeroOrMorePattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            DtdOutput.this.buf.append('*');
            return null;
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            DtdOutput.this.buf.append('(');
            oneOrMorePattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            DtdOutput.this.buf.append('+');
            return null;
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            DtdOutput.this.buf.append('(');
            optionalPattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            DtdOutput.this.buf.append('?');
            return null;
        }

        public Object visitElement(ElementPattern elementPattern) {
            DtdOutput.this.buf.append('(');
            super.visitElement(elementPattern);
            DtdOutput.this.buf.append(')');
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            ContentType contentType = DtdOutput.this.getContentType(refPattern);
            if (contentType.isA(ContentType.MIXED_MODEL)) {
                super.visitRef(refPattern);
            } else {
                DtdOutput.this.buf.append('(');
                super.visitRef(refPattern);
                DtdOutput.this.buf.append(')');
            }
            return null;
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            DtdOutput.this.buf.append('(');
            choicePattern.accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            return null;
        }

        public Object visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append('(');
            textPattern.accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            return null;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            DtdOutput.this.buf.append('(');
            if (DtdOutput.this.getContentType(mixedPattern.getChild()) == ContentType.EMPTY) {
                DtdOutput.this.buf.append("#PCDATA)");
            } else {
                DtdOutput.this.buf.append("#PCDATA|");
                mixedPattern.getChild().accept(DtdOutput.this.innerElementClassOutput);
                DtdOutput.this.buf.append(')');
                DtdOutput.this.buf.append('*');
            }
            return null;
        }

        public Object visitGroup(GroupPattern groupPattern) {
            List list2 = groupPattern.getChildren();
            Pattern pattern = null;
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                Pattern pattern2 = (Pattern)list2.get(n);
                if (!DtdOutput.this.getContentType(pattern2).isA(ContentType.EMPTY)) {
                    if (pattern == null) {
                        pattern = pattern2;
                    } else {
                        DtdOutput.this.buf.append('(');
                        DtdOutput.this.nestedContentModelOutput.visitGroup(groupPattern);
                        DtdOutput.this.buf.append(')');
                        return null;
                    }
                }
                ++n;
            }
            if (pattern != null) {
                pattern.accept(this);
            }
            return null;
        }
    }

    class ContentModelOutput
    extends AbstractVisitor {
        ContentModelOutput() {
        }

        public Object visitName(NameNameClass nameNameClass) {
            DtdOutput.this.buf.append(nameNameClass.getLocalName());
            return null;
        }

        public Object visitChoice(ChoiceNameClass choiceNameClass) {
            List list2 = choiceNameClass.getChildren();
            boolean bl = false;
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                if (bl) {
                    DtdOutput.this.buf.append('|');
                } else {
                    bl = true;
                }
                ((NameClass)list2.get(n)).accept(this);
                ++n;
            }
            return null;
        }

        public Object visitElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            DtdOutput.this.elementQueue.add(elementPattern);
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            Pattern pattern = DtdOutput.this.getBody(refPattern.getName());
            if (DtdOutput.this.getContentType(pattern) == ContentType.DIRECT_SINGLE_ELEMENT) {
                ((ElementPattern)pattern).getNameClass().accept(this);
            } else {
                DtdOutput.this.paramEntityRef(refPattern);
            }
            return null;
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.getChild().accept(DtdOutput.this.occurContentModelOutput);
            DtdOutput.this.buf.append('*');
            return null;
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getChild().accept(DtdOutput.this.occurContentModelOutput);
            DtdOutput.this.buf.append('+');
            return null;
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            optionalPattern.getChild().accept(DtdOutput.this.occurContentModelOutput);
            DtdOutput.this.buf.append('?');
            return null;
        }

        public Object visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append("#PCDATA");
            return null;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            DtdOutput.this.buf.append("#PCDATA");
            return null;
        }

        public Object visitGroup(GroupPattern groupPattern) {
            List list2 = groupPattern.getChildren();
            boolean bl = false;
            int n = list2.size();
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = (Pattern)list2.get(n2);
                ContentType contentType = DtdOutput.this.getContentType(pattern);
                if (!contentType.isA(ContentType.EMPTY)) {
                    if (bl) {
                        DtdOutput.this.buf.append(',');
                    } else {
                        bl = true;
                    }
                    pattern.accept(DtdOutput.this.groupContentModelOutput);
                }
                ++n2;
            }
            return null;
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            ContentType contentType = DtdOutput.this.getContentType(interleavePattern);
            if (contentType == ContentType.INTERLEAVE_ZERO_OR_MORE_ELEMENT_CLASS || contentType == ContentType.INTERLEAVE_MIXED_MODEL) {
                DtdOutput.this.buf.append('(');
                interleavePattern.accept(DtdOutput.this.innerElementClassOutput);
                DtdOutput.this.buf.append(')');
                DtdOutput.this.buf.append('*');
            } else {
                List list2 = interleavePattern.getChildren();
                int n = 0;
                int n2 = list2.size();
                while (n < n2) {
                    Pattern pattern = (Pattern)list2.get(n);
                    ContentType contentType2 = DtdOutput.this.getContentType(pattern);
                    if (!contentType2.isA(ContentType.EMPTY)) {
                        pattern.accept(this);
                    }
                    ++n;
                }
            }
            return null;
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            Object object;
            Pattern pattern;
            int n;
            List list2 = choicePattern.getChildren();
            boolean bl = false;
            int n2 = list2.size();
            if (DtdOutput.this.getContentType(choicePattern).isA(ContentType.MIXED_ELEMENT_CLASS)) {
                n = 0;
                while (n < n2) {
                    pattern = (Pattern)list2.get(n);
                    if (DtdOutput.this.getContentType(pattern).isA(ContentType.MIXED_ELEMENT_CLASS)) {
                        pattern.accept(DtdOutput.this.nestedContentModelOutput);
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            n = 0;
            while (n < n2) {
                pattern = (Pattern)list2.get(n);
                object = DtdOutput.this.getContentType(pattern);
                if (object != ContentType.NOT_ALLOWED && object != ContentType.EMPTY && !((ContentType)object).isA(ContentType.MIXED_ELEMENT_CLASS)) {
                    if (bl) {
                        DtdOutput.this.buf.append('|');
                    } else {
                        bl = true;
                    }
                    pattern.accept(!((ContentType)object).isA(ContentType.ELEMENT_CLASS) ? DtdOutput.this.choiceContentModelOutput : DtdOutput.this.nestedContentModelOutput);
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < n2) {
                object = (Pattern)list2.get(n3);
                ContentType contentType = DtdOutput.this.getContentType((Pattern)object);
                if (contentType == ContentType.NOT_ALLOWED) {
                    if (bl) {
                        DtdOutput.this.buf.append(' ');
                    } else {
                        bl = true;
                    }
                    ((Pattern)object).accept(DtdOutput.this.nestedContentModelOutput);
                }
                ++n3;
            }
            return null;
        }

        public Object visitGrammar(GrammarPattern grammarPattern) {
            return DtdOutput.this.getBody(DefineComponent.START).accept(this);
        }
    }

    class GroupContentModelOutput
    extends ChoiceContentModelOutput {
        GroupContentModelOutput() {
        }

        public Object visitGroup(GroupPattern groupPattern) {
            groupPattern.accept(DtdOutput.this.nestedContentModelOutput);
            return null;
        }
    }

    class ChoiceContentModelOutput
    extends ParenthesizedContentModelOutput {
        ChoiceContentModelOutput() {
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            optionalPattern.accept(DtdOutput.this.nestedContentModelOutput);
            return null;
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.accept(DtdOutput.this.nestedContentModelOutput);
            return null;
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.accept(DtdOutput.this.nestedContentModelOutput);
            return null;
        }
    }

    class ParenthesizedContentModelOutput
    extends AbstractVisitor {
        ParenthesizedContentModelOutput() {
        }

        public Object visitPattern(Pattern pattern) {
            DtdOutput.this.buf.append('(');
            pattern.accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            Pattern pattern = DtdOutput.this.getBody(refPattern.getName());
            if (DtdOutput.this.getContentType(pattern) == ContentType.DIRECT_SINGLE_ELEMENT) {
                ((ElementPattern)pattern).getNameClass().accept(DtdOutput.this.nestedContentModelOutput);
            } else {
                this.visitPattern(refPattern);
            }
            return null;
        }

        public Object visitElement(ElementPattern elementPattern) {
            if (DtdOutput.this.getContentType(elementPattern) == ContentType.DIRECT_SINGLE_ELEMENT) {
                elementPattern.getNameClass().accept(DtdOutput.this.nestedContentModelOutput);
                DtdOutput.this.elementQueue.add(elementPattern);
            } else {
                this.visitPattern(elementPattern);
            }
            return null;
        }
    }
}

