/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.performance.performancePlugin.commands;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.performanceTesting.vcs.VcsTestUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.NewKotlinFileActionKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "kotlin.performanceExtendedPlugin"})
@SourceDebugExtension(value={"SMAP\nCreateKotlinFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateKotlinFileCommand.kt\ncom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,71:1\n28#2:72\n88#2,2:73\n29#2,3:75\n101#2:78\n91#2,8:79\n*S KotlinDebug\n*F\n+ 1 CreateKotlinFileCommand.kt\ncom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand\n*L\n59#1:72\n59#1:73,2\n59#1:75,3\n59#1:78\n59#1:79,8\n*E\n"})
public final class CreateKotlinFileCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "createKotlinFile";
    @NotNull
    public static final String PREFIX = "%createKotlinFile";
    @NotNull
    private static final Map<String, String> POSSIBLE_FILE_TYPES;
    @NotNull
    private static final Logger LOG;

    public CreateKotlinFileCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context2, @NotNull Continuation<? super Unit> $completion) {
        String string = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(...)");
        String[] stringArray = new String[]{","};
        List list2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)string, (String)"\\s", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String fileName = (String)list2.get(0);
        String filePath = (String)list2.get(1);
        String fileType = (String)list2.get(2);
        PsiManager psiManager = PsiManager.getInstance((Project)context2.getProject());
        Intrinsics.checkNotNull((Object)psiManager, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiManagerImpl");
        PsiManagerImpl psiManagerImpl = (PsiManagerImpl)psiManager;
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            throw new RuntimeException("Root of the project was not found ");
        }
        VirtualFile virtualFile2 = VirtualFileUtil.findDirectory((VirtualFile)virtualFile, (String)filePath);
        if (virtualFile2 == null) {
            throw new RuntimeException("Can't find file " + filePath);
        }
        PsiDirectoryImpl directory = new PsiDirectoryImpl(psiManagerImpl, virtualFile2);
        String string2 = fileType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String templateName = POSSIBLE_FILE_TYPES.get(string2);
        if (templateName == null) {
            throw new RuntimeException("File type must be one of '" + POSSIBLE_FILE_TYPES.keySet() + "'");
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)directory.getProject()).getInternalTemplate(templateName);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInternalTemplate(...)");
        FileTemplate template2 = fileTemplate;
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        VcsTestUtil.INSTANCE.provisionVcsAddFileConfirmation(project2, VcsTestUtil.VcsAddFileConfirmation.DO_NOTHING);
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> CreateKotlinFileCommand.doExecute$lambda$2(fileName, template2, directory)));
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doExecute$lambda$2(String $fileName, FileTemplate $template, PsiDirectoryImpl $directory) {
        SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder(NAME);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Unit unit;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                PsiFile createdFile;
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                PsiFile psiFile = createdFile = NewKotlinFileActionKt.createKotlinFileFromTemplate($fileName, $template, (PsiDirectory)$directory);
                if (psiFile != null) {
                    PsiFile it2 = psiFile;
                    boolean bl4 = false;
                    LOG.info("Created kotlin file\n" + createdFile.getText());
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Unit unit2 = unit;
        }
        catch (CancellationException e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException(e$iv$iv, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)"class", (Object)"Kotlin Class"), new Pair((Object)"script", (Object)"Kotlin script"), new Pair((Object)"worksheet", (Object)"Kotlin worksheet"), new Pair((Object)"data", (Object)"Kotlin Data Class"), new Pair((Object)"enum", (Object)"Kotlin Enum"), new Pair((Object)"annotation", (Object)"Kotlin Annotation"), new Pair((Object)"object", (Object)"Kotlin Object"), new Pair((Object)"file", (Object)"Kotlin File"), new Pair((Object)"interface", (Object)"Kotlin Interface")};
        POSSIBLE_FILE_TYPES = MapsKt.mapOf((Pair[])pairArray);
        Logger logger = Logger.getInstance(CreateKotlinFileCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "POSSIBLE_FILE_TYPES", "", "getPOSSIBLE_FILE_TYPES", "()Ljava/util/Map;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.performanceExtendedPlugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getPOSSIBLE_FILE_TYPES() {
            return POSSIBLE_FILE_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

