/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessTypeArgumentsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyAccessTypeArgumentsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyAccessTypeArgumentsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessTypeArgumentsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n1755#2,3:31\n*S KotlinDebug\n*F\n+ 1 FirPropertyAccessTypeArgumentsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessTypeArgumentsChecker\n*L\n23#1:31,3\n*E\n"})
public final class FirPropertyAccessTypeArgumentsChecker
extends FirExpressionChecker<FirPropertyAccessExpression> {
    @NotNull
    public static final FirPropertyAccessTypeArgumentsChecker INSTANCE = new FirPropertyAccessTypeArgumentsChecker();

    private FirPropertyAccessTypeArgumentsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirPropertyAccessExpression expression, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression.getCalleeReference() instanceof FirErrorNamedReference)) {
            boolean hasExplicitTypeArgument;
            block5: {
                boolean bl;
                Iterable $this$any$iv = expression.getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeProjection it = (FirTypeProjection)element$iv;
                        boolean bl2 = false;
                        if (!FirHelpersKt.isExplicit(it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = hasExplicitTypeArgument = false;
                }
            }
            if (hasExplicitTypeArgument) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirErrors.INSTANCE.getEXPLICIT_TYPE_ARGUMENTS_IN_PROPERTY_ACCESS(), (Object)"Property", (DiagnosticContext)context2, null, (int)16, null);
            }
        }
    }
}

