/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsExternalArgumentCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalArgumentCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalArgumentCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsExternalArgumentCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,44:1\n57#2,4:45\n*S KotlinDebug\n*F\n+ 1 FirJsExternalArgumentCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsExternalArgumentCallChecker\n*L\n26#1:45,4\n*E\n"})
public final class FirJsExternalArgumentCallChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirJsExternalArgumentCallChecker INSTANCE = new FirJsExternalArgumentCallChecker();

    private FirJsExternalArgumentCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirCall expression, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCall $this$resolvedArgumentMapping$iv = expression;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        if (linkedHashMap == null) {
            return;
        }
        LinkedHashMap<FirExpression, FirValueParameter> arguments2 = linkedHashMap;
        for (Map.Entry entry : ((Map)arguments2).entrySet()) {
            FirRegularClassSymbol symbol;
            FirExpression argument2 = (FirExpression)entry.getKey();
            FirValueParameter parameter = (FirValueParameter)entry.getValue();
            if (!FirAnnotationUtilsKt.hasAnnotation(parameter, JsStandardClassIds.Annotations.JsExternalArgument, context2.getSession())) continue;
            FirExpression unwrappedArg = FirExpressionUtilKt.unwrapArgument(argument2);
            ConeKotlinType type2 = FirTypeUtilsKt.getResolvedType(unwrappedArg);
            FirRegularClassSymbol firRegularClassSymbol = symbol = ToSymbolUtilsKt.toRegularClassSymbol(type2, context2.getSession());
            boolean bl = firRegularClassSymbol != null ? !FirWebCommonHelpersKt.isEffectivelyExternal(firRegularClassSymbol, context2.getSession()) : false;
            if (!bl && !(type2 instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)unwrappedArg.getSource()), FirJsErrors.INSTANCE.getJS_EXTERNAL_ARGUMENT(), (Object)type2, (DiagnosticContext)context2, null, (int)16, null);
        }
    }
}

