/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.builder.FirResolvedImportBuilder;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageAndClass;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\tJ)\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0019H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\u00020\u001c*\u00020\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001e\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "currentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformFile", "file", "transformImport", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "import", "isAcceptable", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "transformImportForFqName", "fqName", "delegate", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirImportResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImportResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirResolvedImportBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirResolvedImportBuilderKt\n*L\n1#1,80:1\n229#2,4:81\n1#3:85\n41#4:86\n*S KotlinDebug\n*F\n+ 1 FirImportResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer\n*L\n40#1:81,4\n73#1:86\n*E\n"})
public class FirImportResolveTransformer
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @Nullable
    private FirFile currentFile;

    protected FirImportResolveTransformer(@NotNull FirSession session, @NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        super(phase);
        this.session = session;
        this.symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    public FirImportResolveTransformer(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        this(session, FirResolvePhase.IMPORTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.checkSessionConsistency(file);
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            FirElement firElement;
            boolean bl = false;
            FirFile prevValue = this.currentFile;
            this.currentFile = file;
            try {
                firElement = file.transformChildren(this, null);
            }
            finally {
                this.currentFile = prevValue;
            }
            FirElement firElement2 = firElement;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file.getModuleData().getSession()).handleExceptionOnFileAnalysis(file, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return file;
    }

    @Override
    @NotNull
    public FirImport transformImport(@NotNull FirImport firImport, @Nullable Object data) {
        FqName fqName2;
        block9: {
            Object object;
            block8: {
                block7: {
                    FqName fqName3;
                    Intrinsics.checkNotNullParameter((Object)firImport, (String)"import");
                    object = firImport.getImportedFqName();
                    if (object == null) break block7;
                    FqName it = fqName3 = object;
                    boolean bl = false;
                    object = !it.isRoot() ? fqName3 : null;
                    if (object != null) break block8;
                }
                return firImport;
            }
            fqName2 = object;
            if (!this.isAcceptable(fqName2)) {
                return firImport;
            }
            if (firImport.isAllUnder()) {
                return this.transformImportForFqName(fqName2, firImport);
            }
            FirFile firFile = this.currentFile;
            if (firFile == null) break block9;
            FirFile it = firFile;
            boolean bl = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponentKt.recordFqNameLookup(firLookupTrackerComponent, fqName2, firImport.getSource(), it.getSource());
            }
        }
        return this.transformImportForFqName(fqName2.parent(), firImport);
    }

    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptable, (String)"<this>");
        return true;
    }

    private final FirImport transformImportForFqName(FqName fqName2, FirImport delegate) {
        FirResolvedImportBuilder firResolvedImportBuilder;
        PackageAndClass packageAndClass = ImportUtilsKt.findLongestExistingPackage(this.symbolProvider, fqName2);
        FqName packageFqName = packageAndClass.component1();
        FqName relativeClassFqName = packageAndClass.component2();
        boolean $i$f$buildResolvedImport = false;
        FirResolvedImportBuilder $this$transformImportForFqName_u24lambda_u243 = firResolvedImportBuilder = new FirResolvedImportBuilder();
        boolean bl = false;
        $this$transformImportForFqName_u24lambda_u243.setDelegate(delegate);
        $this$transformImportForFqName_u24lambda_u243.setPackageFqName(packageFqName);
        $this$transformImportForFqName_u24lambda_u243.setRelativeParentClassName(relativeClassFqName);
        return firResolvedImportBuilder.build();
    }
}

