/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.actions.JavaQualifiedNameProvider;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0019\u0010\n\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinQualifiedNameProvider;", "Lcom/intellij/ide/actions/QualifiedNameProvider;", "<init>", "()V", "adjustElementToCopy", "", "element", "Lcom/intellij/psi/PsiElement;", "getQualifiedName", "", "getJavaQualifiedName", "Lorg/jetbrains/annotations/Nullable;", "qualifiedNameToElement", "fqn", "project", "Lcom/intellij/openapi/project/Project;", "insertQualifiedName", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nKotlinQualifiedNameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinQualifiedNameProvider.kt\norg/jetbrains/kotlin/idea/KotlinQualifiedNameProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class KotlinQualifiedNameProvider
implements QualifiedNameProvider {
    @Nullable
    public Void adjustElementToCopy(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    @Nullable
    public String getQualifiedName(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof KtClassOrObject) {
            FqName fqName2 = ((KtClassOrObject)element).getFqName();
            string = fqName2 != null ? fqName2.asString() : null;
        } else if (psiElement instanceof KtFunction) {
            string = this.getJavaQualifiedName((PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)element));
        } else if (psiElement instanceof KtProperty) {
            LightClassUtil.PropertyAccessorsPsiMethods lightClassPropertyMethods = LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)element);
            PsiMethod psiMethod = lightClassPropertyMethods.getGetter();
            PsiElement lightElement = psiMethod != null ? (PsiElement)psiMethod : (PsiElement)lightClassPropertyMethods.getBackingField();
            string = this.getJavaQualifiedName(lightElement);
        } else if (psiElement instanceof KtNameReferenceExpression) {
            PsiElement psiElement2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)element)).resolve();
            if (psiElement2 != null) {
                PsiElement it = psiElement2;
                boolean bl = false;
                string = QualifiedNameProviderUtil.getQualifiedName((PsiElement)it);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    private final String getJavaQualifiedName(PsiElement element) {
        String string;
        PsiElement psiElement = element;
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            string = new JavaQualifiedNameProvider().getQualifiedName(element);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Void qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    public void insertQualifiedName(@NotNull String fqn, @NotNull PsiElement element, @NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

