/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bH\u0016J\r\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\rH\u0016J\r\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KlibManifestFileType;", "Lcom/intellij/openapi/fileTypes/ex/FileTypeIdentifiableByVirtualFile;", "<init>", "()V", "KLIB_LINK_DATA_DIR_NAME", "", "isMyFileType", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "Lorg/jetbrains/annotations/NonNls;", "getDescription", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getDefaultExtension", "Lcom/intellij/openapi/util/NlsSafe;", "getIcon", "Ljavax/swing/Icon;", "isBinary", "kotlin.base.project-structure"})
public final class KlibManifestFileType
implements FileTypeIdentifiableByVirtualFile {
    @NotNull
    public static final KlibManifestFileType INSTANCE = new KlibManifestFileType();
    @NotNull
    private static final String KLIB_LINK_DATA_DIR_NAME = "linkdata";

    private KlibManifestFileType() {
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getNameSequence(), (Object)"manifest")) {
            return false;
        }
        VirtualFile virtualFile = file.getParent();
        if ((virtualFile != null ? virtualFile.findChild(KLIB_LINK_DATA_DIR_NAME) : null) == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()), (Object)FileTypes.UNKNOWN);
    }

    @NotNull
    public String getName() {
        return "KLIB manifest";
    }

    @NotNull
    public String getDescription() {
        return KotlinBaseProjectStructureBundle.message("klib.manifest.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.FileTypes.Manifest;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Manifest");
        return icon2;
    }

    public boolean isBinary() {
        return false;
    }
}

