/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.LibraryModuleInfo;
import org.jetbrains.kotlin.analyzer.TrackableModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.compositeAnalysis.PlatformAnalyzerServicesUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.libraryToSourceAnalysis.KotlinLibraryToSourceAnalysisStateComponentUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryWithoutSourceScope;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ResolutionAnchorAwareLibraryModificationTracker;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.PoweredLibraryScopeBaseKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0019\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00010&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010(H\u0016J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00110:H\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010)\u001a\u00020*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b3\u00104R\u0014\u00107\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00104R\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010?\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/LibraryModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/TrackableModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLibrary", "()Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "topClassesPackageNames", "", "", "classesEntriesVirtualFileSystems", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFileSystem;", "topSourcesPackageNames", "sourcesEntriesVirtualFileSystems", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "displayedName", "getDisplayedName", "()Ljava/lang/String;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "dependencies", "", "dependenciesWithoutSelf", "Lkotlin/sequences/Sequence;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "_sourcesModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SourceForBinaryModuleInfo;", "get_sourcesModuleInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SourceForBinaryModuleInfo;", "_sourcesModuleInfo$delegate", "Lkotlin/Lazy;", "sourcesModuleInfo", "getSourcesModuleInfo", "getLibraryRoots", "", "createModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "isDisposed", "", "()Z", "checkValidity", "", "toString", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nLibraryInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryInfo.kt\norg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n11483#2,9:177\n13409#2:186\n13410#2:188\n11492#2:189\n1#3:187\n*S KotlinDebug\n*F\n+ 1 LibraryInfo.kt\norg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo\n*L\n105#1:177,9\n105#1:186\n105#1:188\n105#1:189\n105#1:187\n*E\n"})
public abstract class LibraryInfo
implements IdeaModuleInfo,
LibraryModuleInfo,
BinaryModuleInfo,
TrackableModuleInfo {
    @NotNull
    private final Project project;
    @NotNull
    private final LibraryEx library;
    @NotNull
    private final Set<String> topClassesPackageNames;
    @Nullable
    private final Set<NewVirtualFileSystem> classesEntriesVirtualFileSystems;
    @NotNull
    private final Set<String> topSourcesPackageNames;
    @Nullable
    private final Set<NewVirtualFileSystem> sourcesEntriesVirtualFileSystems;
    @NotNull
    private final Name name;
    @NotNull
    private final Lazy _sourcesModuleInfo$delegate;

    public LibraryInfo(@NotNull Project project, @NotNull LibraryEx library) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.project = project;
        this.library = library;
        VirtualFile[] virtualFileArray = this.library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile[] classes = virtualFileArray;
        this.topClassesPackageNames = PoweredLibraryScopeBaseKt.calculateTopPackageNames(classes);
        this.classesEntriesVirtualFileSystems = PoweredLibraryScopeBaseKt.calculateEntriesVirtualFileSystems(classes);
        VirtualFile[] virtualFileArray2 = this.library.getFiles(OrderRootType.SOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
        VirtualFile[] sources = virtualFileArray2;
        this.topSourcesPackageNames = PoweredLibraryScopeBaseKt.calculateTopPackageNames(sources);
        this.sourcesEntriesVirtualFileSystems = PoweredLibraryScopeBaseKt.calculateEntriesVirtualFileSystems(sources);
        Name name2 = Name.special((String)("<library " + this.library.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        this.name = name2;
        this._sourcesModuleInfo$delegate = LazyKt.lazy(() -> LibraryInfo._sourcesModuleInfo_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final LibraryEx getLibrary() {
        return this.library;
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[]{this.library.getPresentableName()};
        return KotlinBaseProjectStructureBundle.message("library.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        return (GlobalSearchScope)new LibraryWithoutSourceScope(this.getProject(), this.topClassesPackageNames, this.classesEntriesVirtualFileSystems, (Library)this.library);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        List list2;
        LibraryDependenciesCache.LibraryDependencies dependencies = LibraryDependenciesCache.Companion.getInstance(this.getProject()).getLibraryDependencies(this);
        List $this$dependencies_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$dependencies_u24lambda_u240.add(this);
        $this$dependencies_u24lambda_u240.addAll((Collection)dependencies.getSdk());
        $this$dependencies_u24lambda_u240.addAll((Collection)dependencies.getLibrariesWithoutSelf());
        return CollectionsKt.build((List)list2);
    }

    @Override
    @NotNull
    public Sequence<IdeaModuleInfo> dependenciesWithoutSelf() {
        LibraryDependenciesCache.LibraryDependencies dependencies = LibraryDependenciesCache.Companion.getInstance(this.getProject()).getLibraryDependencies(this);
        return SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)dependencies.getSdk()), (Sequence)CollectionsKt.asSequence((Iterable)dependencies.getLibrariesWithoutSelf()));
    }

    @NotNull
    public abstract TargetPlatform getPlatform();

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return PlatformAnalyzerServicesUtils.findAnalyzerServices(this.getPlatform(), this.getProject());
    }

    private final SourceForBinaryModuleInfo get_sourcesModuleInfo() {
        Lazy lazy = this._sourcesModuleInfo$delegate;
        return (SourceForBinaryModuleInfo)lazy.getValue();
    }

    @Override
    @NotNull
    public SourceForBinaryModuleInfo getSourcesModuleInfo() {
        return this.get_sourcesModuleInfo();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getLibraryRoots() {
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] virtualFileArray = this.library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        Object[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            VirtualFile p0 = (VirtualFile)element$iv$iv;
            boolean $i$f$getLibraryRoots$stub_for_inlining = false;
            boolean bl2 = false;
            if (PathUtil.getLocalPath((VirtualFile)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public ModificationTracker createModificationTracker() {
        ModificationTracker modificationTracker;
        if (!KotlinLibraryToSourceAnalysisStateComponentUtils.getUseLibraryToSourceAnalysis(this.getProject())) {
            ModificationTracker modificationTracker2 = ModificationTracker.NEVER_CHANGED;
            Intrinsics.checkNotNull((Object)modificationTracker2);
            modificationTracker = modificationTracker2;
        } else {
            modificationTracker = new ResolutionAnchorAwareLibraryModificationTracker(this);
        }
        return modificationTracker;
    }

    public final boolean isDisposed() {
        return this.library.isDisposed();
    }

    @Override
    public void checkValidity() {
        if (this.isDisposed()) {
            throw new AlreadyDisposedException("Library '" + this.getName() + "' is already disposed");
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "(" + this.library + ")";
    }

    private static final LibrarySourceInfo _sourcesModuleInfo_delegate$lambda$1(LibraryInfo this$0) {
        return new LibrarySourceInfo(this$0.getProject(), (Library)this$0.library, this$0, this$0.topSourcesPackageNames, this$0.sourcesEntriesVirtualFileSystems);
    }
}

