/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.VcsCodeVisionCurlyBracketLanguageContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.statistics.KotlinCodeVisionUsagesCollector;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinVcsCodeVisionContext;", "Lcom/intellij/codeInsight/hints/VcsCodeVisionCurlyBracketLanguageContext;", "<init>", "()V", "isAccepted", "", "element", "Lcom/intellij/psi/PsiElement;", "isAcceptedClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "handleClick", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isRBrace", "kotlin.code-insight.impl-base"})
public final class KotlinVcsCodeVisionContext
extends VcsCodeVisionCurlyBracketLanguageContext {
    public boolean isAccepted(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof KtClassOrObject) {
            bl = this.isAcceptedClassOrObject((KtClassOrObject)element);
        } else if (psiElement instanceof KtNamedFunction) {
            bl = !ErrorUtil.containsError((PsiElement)element) && (((KtNamedFunction)element).isTopLevel() || this.isAcceptedClassOrObject(KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element))));
        } else if (psiElement instanceof KtSecondaryConstructor) {
            bl = true;
        } else if (psiElement instanceof KtClassInitializer) {
            bl = true;
        } else if (psiElement instanceof KtProperty) {
            List list2 = ((KtProperty)element).getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
            bl = !((Collection)list2).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isAcceptedClassOrObject(KtClassOrObject element) {
        KtClassOrObject ktClassOrObject = element;
        return ktClassOrObject instanceof KtClass ? !(element instanceof KtEnumEntry) : (ktClassOrObject instanceof KtObjectDeclaration ? !((KtObjectDeclaration)element).isObjectLiteral() : false);
    }

    public void handleClick(@NotNull MouseEvent mouseEvent, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String location = element instanceof KtClassOrObject ? "class" : "function";
        KotlinCodeVisionUsagesCollector.INSTANCE.logCodeAuthorClicked(project2, location);
    }

    protected boolean isRBrace(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return CommentSaver.Companion.getTokenType(element) == KtTokens.RBRACE;
    }
}

