/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveSetterParameterTypeInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "<init>", "()V", "inspectionText", "", "element", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicable", "", "kotlin.code-insight.inspections.shared"})
public final class RemoveSetterParameterTypeInspection
extends AbstractApplicabilityBasedInspection<KtParameter> {
    public RemoveSetterParameterTypeInspection() {
        super(KtParameter.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"redundant.setter.parameter.type", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"remove.explicit.type.specification", (Object[])new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtParameter element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        element.setTypeReference(null);
    }

    @Override
    public boolean isApplicable(@NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!KotlinPsiUtilsKt.isSetterParameter(element)) {
            return false;
        }
        KtTypeReference ktTypeReference = element.getTypeReference();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference = ktTypeReference;
        return PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference)) > PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)typeReference));
    }
}

