/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"checkInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkHideNonConfiguredNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nConfigureKotlinNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureKotlinNotificationManager.kt\norg/jetbrains/kotlin/idea/configuration/ConfigureKotlinNotificationManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n14#2:116\n73#3:117\n1611#4,9:118\n1863#4:127\n1864#4:129\n1620#4:130\n1557#4:131\n1628#4,3:132\n2632#4,3:135\n1#5:128\n*S KotlinDebug\n*F\n+ 1 ConfigureKotlinNotificationManager.kt\norg/jetbrains/kotlin/idea/configuration/ConfigureKotlinNotificationManagerKt\n*L\n84#1:116\n88#1:117\n91#1:118,9\n91#1:127\n91#1:129\n91#1:130\n92#1:131\n92#1:132,3\n93#1:135,3\n91#1:128\n*E\n"})
public final class ConfigureKotlinNotificationManagerKt {
    @NotNull
    private static final AtomicBoolean checkInProgress = new AtomicBoolean(false);

    public static final void checkHideNonConfiguredNotifications(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (checkInProgress.get()) {
            return;
        }
        ConfigureKotlinNotification configureKotlinNotification = (ConfigureKotlinNotification)((Object)ArraysKt.firstOrNull((Object[])ConfigureKotlinNotificationManager.INSTANCE.getVisibleNotifications(project)));
        if (configureKotlinNotification == null) {
            return;
        }
        ConfigureKotlinNotification notification = configureKotlinNotification;
        ApplicationManager.getApplication().executeOnPooledThread(() -> ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications$lambda$4(project, notification));
    }

    private static final void checkHideNonConfiguredNotifications$lambda$4$lambda$2(Project $project) {
        ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications($project);
    }

    private static final void checkHideNonConfiguredNotifications$lambda$4$lambda$3(Project $project) {
        ConfigureKotlinNotificationManager.INSTANCE.expireOldNotifications($project);
        checkInProgress.set(false);
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkHideNonConfiguredNotifications$lambda$4(Project $project, ConfigureKotlinNotification $notification) {
        boolean hideNotification;
        if (!checkInProgress.compareAndSet(false, true)) {
            return;
        }
        DumbService.Companion.getInstance($project).waitForSmartMode();
        ModuleSourceRootMap moduleSourceRootMap = new ModuleSourceRootMap($project);
        if (!Intrinsics.areEqual((Object)$notification.getNotificationState().getDebugProjectName(), (Object)$project.getName())) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ConfigureKotlinNotificationManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Bad notification check for project: " + $project.getName() + "\n" + $notification.getNotificationState());
        }
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            boolean bl;
            try {
                boolean bl2;
                block13: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Iterable iterable = $notification.getNotificationState().getNotConfiguredModules();
                    boolean $i$f$mapNotNull = false;
                    Iterator iterator2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Module module = $this$forEach$iv$iv$iv.iterator();
                    while (module.hasNext()) {
                        Module it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = module.next();
                        boolean bl3 = false;
                        String it = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (ModuleManager.Companion.getInstance($project).findModuleByName(it) == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        module = (Module)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl6 = false;
                        collection.add(moduleSourceRootMap.getWholeModuleGroup((Module)it));
                    }
                    List moduleSourceRootGroups = (List)destination$iv$iv;
                    Iterable $this$none$iv = moduleSourceRootGroups;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv;
                            boolean bl7 = false;
                            boolean $i$f$checkHideNonConfiguredNotifications$lambda$4$stub_for_inlining = false;
                            if (!ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(p0)) continue;
                            bl2 = false;
                            break block13;
                        }
                        bl2 = true;
                    }
                }
                bl = bl2;
            }
            catch (IndexNotReadyException e) {
                checkInProgress.set(false);
                ApplicationManager.getApplication().invokeLater(() -> ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications$lambda$4$lambda$2($project));
                return;
            }
            v2 = bl;
        } else {
            v2 = hideNotification = true;
        }
        if (hideNotification) {
            ApplicationManager.getApplication().invokeLater(() -> ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications$lambda$4$lambda$3($project));
        } else {
            checkInProgress.set(false);
        }
    }
}

