/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping.filter;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.LocationToken;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.StepOverCallerInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/KotlinStepOverFilter;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinMethodFilter;", "locationStepOverStartedFrom", "Lcom/sun/jdi/Location;", "<init>", "(Lcom/sun/jdi/Location;)V", "callerInfo", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/StepOverCallerInfo;", "locationMatches", "", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "location", "isAcceptable", "locationToken", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/LocationToken;", "stackFrame", "Lcom/sun/jdi/StackFrame;", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getCallingExpressionLines", "Lcom/intellij/util/Range;", "", "kotlin.jvm-debugger.core"})
public abstract class KotlinStepOverFilter
implements KotlinMethodFilter {
    @NotNull
    private final StepOverCallerInfo callerInfo;

    public KotlinStepOverFilter(@NotNull Location locationStepOverStartedFrom) {
        Intrinsics.checkNotNullParameter((Object)locationStepOverStartedFrom, (String)"locationStepOverStartedFrom");
        this.callerInfo = StepOverCallerInfo.Companion.from(locationStepOverStartedFrom);
    }

    @Override
    public boolean locationMatches(@NotNull SuspendContextImpl context2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (DebuggerUtil.isKotlinFakeLineNumber(location)) {
            return false;
        }
        Object object = context2.getFrameProxy();
        if (object == null || (object = object.getStackFrame()) == null) {
            return true;
        }
        Object stackFrame = object;
        StepOverCallerInfo callerInfo = StepOverCallerInfo.Companion.from(location);
        if (callerInfo.getMethodName() != null && callerInfo.getMethodSignature() != null && Intrinsics.areEqual((Object)this.callerInfo, (Object)callerInfo)) {
            return this.isAcceptable(location, LocationToken.Companion.from((StackFrame)stackFrame), (StackFrame)stackFrame);
        }
        return true;
    }

    public abstract boolean isAcceptable(@NotNull Location var1, @NotNull LocationToken var2, @NotNull StackFrame var3);

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        throw new IllegalStateException("Should not be called from Kotlin hint");
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return null;
    }
}

