/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.xdebugger.XSourcePosition;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\t\u001a\u00020\n*\u00020\f\u001a\n\u0010\r\u001a\u00020\u0004*\u00020\f\u001a\n\u0010\u000e\u001a\u00020\u0004*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u000f\u001a\u0012\u0010\u0011\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0013\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\f\u001a\n\u0010\u0014\u001a\u00020\u0004*\u00020\f\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0001\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\u000b\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u000b\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u00020\u000b\u001a\f\u0010\u001b\u001a\u00020\u0004*\u00020\u0005H\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f\u001a\n\u0010 \u001a\u00020\u0004*\u00020!\u001a\u0019\u0010\"\u001a\t\u0018\u00010#\u00a2\u0006\u0002\b$*\u00020\f2\u0006\u0010%\u001a\u00020&\u001a\f\u0010'\u001a\u0004\u0018\u00010(*\u00020)\u001a+\u0010*\u001a\u0004\u0018\u0001H+\"\b\b\u0000\u0010+*\u00020,*\u00020)2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H+0.\u00a2\u0006\u0002\u0010/\u001a\n\u00100\u001a\u00020\u0004*\u000201\u001a\n\u00100\u001a\u00020\u0004*\u00020)\u001a\u0018\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020)2\b\u00104\u001a\u0004\u0018\u00010\u000b\u001a\u0014\u00105\u001a\u00020\u0004*\u00020\f2\b\u00106\u001a\u0004\u0018\u00010\f\u001a\u0014\u00107\u001a\u00020\u0004*\u00020\f2\b\u00106\u001a\u0004\u0018\u00010\f\u001a\u0014\u00108\u001a\u00020\u0004*\u00020\f2\b\u00106\u001a\u0004\u0018\u00010\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"CREATION_STACK_TRACE_SEPARATOR", "", "CREATION_CLASS_NAME", "isInvokeSuspend", "", "Lcom/sun/jdi/Method;", "isInvoke", "isSuspendLambda", "hasContinuationParameter", "getSuspendExitMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendExitMode;", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "Lcom/sun/jdi/Location;", "safeCoroutineExitPointLineNumber", "isBaseContinuationImpl", "Lcom/sun/jdi/Type;", "isCoroutineScope", "isSubTypeOrSame", "className", "Lcom/sun/jdi/ReferenceType;", "isInvokeSuspendWithNegativeLineNumber", "variableValue", "Lcom/sun/jdi/ObjectReference;", "variableName", "completionVariableValue", "continuationVariableValue", "thisVariableValue", "isGetCoroutineSuspended", "hasGetCoroutineSuspended", "", "frames", "", "isCreationSeparatorFrame", "Ljava/lang/StackTraceElement;", "findPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "Lorg/jetbrains/annotations/Nullable;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function0;", "(Lcom/intellij/debugger/engine/SuspendContextImpl;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "supportsEvaluation", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "threadAndContextSupportsEvaluation", "suspendContext", "frameProxy", "sameLineAndMethod", "location", "isFilterFromTop", "isFilterFromBottom", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineUtils.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineUtilsKt\n+ 2 safeUtil.kt\norg/jetbrains/kotlin/idea/debugger/base/util/SafeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,124:1\n157#2,4:125\n1755#3,3:129\n360#3,7:132\n73#4:139\n*S KotlinDebug\n*F\n+ 1 CoroutineUtils.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineUtilsKt\n*L\n51#1:125,4\n63#1:129,3\n89#1:132,7\n108#1:139\n*E\n"})
public final class CoroutineUtilsKt {
    @NotNull
    public static final String CREATION_STACK_TRACE_SEPARATOR = "\b\b\b";
    @NotNull
    public static final String CREATION_CLASS_NAME = "_COROUTINE._CREATION";

    public static final boolean isInvokeSuspend(@NotNull Method $this$isInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspend, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isInvokeSuspend.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)$this$isInvokeSuspend.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInvoke(@NotNull Method $this$isInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvoke, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isInvoke.name(), (Object)"invoke")) return false;
        String string = $this$isInvoke.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Ljava/lang/Object;)Ljava/lang/Object;", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuspendLambda(@NotNull Method $this$isSuspendLambda) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendLambda, (String)"<this>");
        if (!CoroutineUtilsKt.isInvokeSuspend($this$isSuspendLambda)) return false;
        ReferenceType referenceType = $this$isSuspendLambda.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
        if (!CoroutineUtilsKt.isSuspendLambda(referenceType)) return false;
        return true;
    }

    public static final boolean hasContinuationParameter(@NotNull Method $this$hasContinuationParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasContinuationParameter, (String)"<this>");
        String string = $this$hasContinuationParameter.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Lkotlin/coroutines/Continuation;)", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final SuspendExitMode getSuspendExitMode(@NotNull StackFrameProxyImpl $this$getSuspendExitMode) {
        Intrinsics.checkNotNullParameter((Object)$this$getSuspendExitMode, (String)"<this>");
        Object object = SafeUtilKt.safeLocation((StackFrameProxy)$this$getSuspendExitMode);
        if (object == null || (object = CoroutineUtilsKt.getSuspendExitMode(object)) == null) {
            return SuspendExitMode.NONE;
        }
        return object;
    }

    @NotNull
    public static final SuspendExitMode getSuspendExitMode(@NotNull Location $this$getSuspendExitMode) {
        Intrinsics.checkNotNullParameter((Object)$this$getSuspendExitMode, (String)"<this>");
        Method method = SafeUtilKt.safeMethod($this$getSuspendExitMode);
        if (method == null) {
            return SuspendExitMode.NONE;
        }
        Method method2 = method;
        if (CoroutineUtilsKt.isSuspendLambda(method2)) {
            return SuspendExitMode.SUSPEND_LAMBDA;
        }
        if (CoroutineUtilsKt.hasContinuationParameter(method2)) {
            return SuspendExitMode.SUSPEND_METHOD_PARAMETER;
        }
        if ((CoroutineUtilsKt.isInvokeSuspend(method2) || CoroutineUtilsKt.isInvoke(method2)) && CoroutineUtilsKt.safeCoroutineExitPointLineNumber($this$getSuspendExitMode)) {
            return SuspendExitMode.SUSPEND_METHOD;
        }
        return SuspendExitMode.NONE;
    }

    public static final boolean safeCoroutineExitPointLineNumber(@NotNull Location $this$safeCoroutineExitPointLineNumber) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$safeCoroutineExitPointLineNumber, (String)"<this>");
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            boolean bl = false;
            n = DebuggerUtilsEx.getLineNumber((Location)$this$safeCoroutineExitPointLineNumber, (boolean)false);
        }
        catch (IllegalArgumentException e$iv) {
            n = null;
        }
        Integer n2 = n;
        return (n2 != null ? n2 : -2) == -1;
    }

    public static final boolean isBaseContinuationImpl(@NotNull Type $this$isBaseContinuationImpl) {
        Intrinsics.checkNotNullParameter((Object)$this$isBaseContinuationImpl, (String)"<this>");
        return JdiTypeUtils.isSubtype($this$isBaseContinuationImpl, "kotlin.coroutines.jvm.internal.BaseContinuationImpl");
    }

    public static final boolean isCoroutineScope(@NotNull Type $this$isCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)$this$isCoroutineScope, (String)"<this>");
        return JdiTypeUtils.isSubtype($this$isCoroutineScope, "kotlinx.coroutines.CoroutineScope");
    }

    public static final boolean isSubTypeOrSame(@NotNull Type $this$isSubTypeOrSame, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubTypeOrSame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return Intrinsics.areEqual((Object)$this$isSubTypeOrSame.name(), (Object)className) || JdiTypeUtils.isSubtype($this$isSubTypeOrSame, className);
    }

    public static final boolean isSuspendLambda(@NotNull ReferenceType $this$isSuspendLambda) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isSuspendLambda, (String)"<this>");
            Iterable $this$any$iv = org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!JdiTypeUtils.isSubtype((Type)$this$isSuspendLambda, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInvokeSuspend(@NotNull Location $this$isInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspend, (String)"<this>");
        Method method = SafeUtilKt.safeMethod($this$isInvokeSuspend);
        return method != null ? CoroutineUtilsKt.isInvokeSuspend(method) : false;
    }

    public static final boolean isInvokeSuspendWithNegativeLineNumber(@NotNull Location $this$isInvokeSuspendWithNegativeLineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspendWithNegativeLineNumber, (String)"<this>");
        return CoroutineUtilsKt.isInvokeSuspend($this$isInvokeSuspendWithNegativeLineNumber) && SafeUtilKt.safeLineNumber($this$isInvokeSuspendWithNegativeLineNumber) < 0;
    }

    @Nullable
    public static final ObjectReference variableValue(@NotNull StackFrameProxyImpl $this$variableValue, @NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)$this$variableValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName($this$variableValue, variableName);
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value = $this$variableValue.getValue(continuationVariable);
        ObjectReference objectReference = value instanceof ObjectReference ? (ObjectReference)value : null;
        if (objectReference == null) {
            return null;
        }
        return objectReference;
    }

    @Nullable
    public static final ObjectReference completionVariableValue(@NotNull StackFrameProxyImpl $this$completionVariableValue) {
        Intrinsics.checkNotNullParameter((Object)$this$completionVariableValue, (String)"<this>");
        return CoroutineUtilsKt.variableValue($this$completionVariableValue, "$completion");
    }

    @Nullable
    public static final ObjectReference continuationVariableValue(@NotNull StackFrameProxyImpl $this$continuationVariableValue) {
        Intrinsics.checkNotNullParameter((Object)$this$continuationVariableValue, (String)"<this>");
        return CoroutineUtilsKt.variableValue($this$continuationVariableValue, "$continuation");
    }

    @Nullable
    public static final ObjectReference thisVariableValue(@NotNull StackFrameProxyImpl $this$thisVariableValue) {
        Intrinsics.checkNotNullParameter((Object)$this$thisVariableValue, (String)"<this>");
        return $this$thisVariableValue.thisObject();
    }

    private static final boolean isGetCoroutineSuspended(Method $this$isGetCoroutineSuspended) {
        return Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.signature(), (Object)"()Ljava/lang/Object;") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.name(), (Object)"getCOROUTINE_SUSPENDED") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.declaringType().name(), (Object)"kotlin.coroutines.intrinsics.IntrinsicsKt__IntrinsicsKt");
    }

    public static final int hasGetCoroutineSuspended(@NotNull List<? extends StackFrameProxyImpl> frames) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(frames, (String)"frames");
            List<? extends StackFrameProxyImpl> $this$indexOfFirst$iv = frames;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends StackFrameProxyImpl> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                StackFrameProxyImpl item$iv;
                StackFrameProxyImpl it = item$iv = iterator2.next();
                boolean bl = false;
                Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)it);
                boolean bl2 = comparable != null && (comparable = SafeUtilKt.safeMethod(comparable)) != null ? CoroutineUtilsKt.isGetCoroutineSuspended((Method)comparable) : false;
                if (bl2) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public static final boolean isCreationSeparatorFrame(@NotNull StackTraceElement $this$isCreationSeparatorFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$isCreationSeparatorFrame, (String)"<this>");
        String string = $this$isCreationSeparatorFrame.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        return StringsKt.startsWith$default((String)string, (String)CREATION_STACK_TRACE_SEPARATOR, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)$this$isCreationSeparatorFrame.getClassName(), (Object)CREATION_CLASS_NAME);
    }

    @Nullable
    public static final XSourcePosition findPosition(@NotNull Location $this$findPosition, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)$this$findPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return (XSourcePosition)ReadAction.nonBlocking(() -> CoroutineUtilsKt.findPosition$lambda$3(debugProcess, $this$findPosition)).executeSynchronously();
    }

    @Nullable
    public static final DefaultExecutionContext executionContext(@NotNull SuspendContextImpl $this$executionContext) {
        Intrinsics.checkNotNullParameter((Object)$this$executionContext, (String)"<this>");
        return (DefaultExecutionContext)CoroutineUtilsKt.invokeInManagerThread($this$executionContext, () -> CoroutineUtilsKt.executionContext$lambda$4($this$executionContext));
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull SuspendContextImpl $this$invokeInManagerThread, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        DebugProcessImpl debugProcessImpl = $this$invokeInManagerThread.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        return DebuggerUtil.invokeInManagerThread(debugProcessImpl, arg_0 -> CoroutineUtilsKt.invokeInManagerThread$lambda$5(f, arg_0));
    }

    public static final boolean supportsEvaluation(@NotNull ThreadReferenceProxyImpl $this$supportsEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsEvaluation, (String)"<this>");
        ThreadReference threadReference = $this$supportsEvaluation.getThreadReference();
        return threadReference != null ? threadReference.isSuspended() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean supportsEvaluation(@NotNull SuspendContextImpl $this$supportsEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsEvaluation, (String)"<this>");
        DebugProcessImpl debugProcessImpl = $this$supportsEvaluation.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        if (DebuggerUtil.getCanRunEvaluation(debugProcessImpl)) return true;
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) return false;
        return true;
    }

    public static final boolean threadAndContextSupportsEvaluation(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Boolean bl = (Boolean)CoroutineUtilsKt.invokeInManagerThread(suspendContext, () -> CoroutineUtilsKt.threadAndContextSupportsEvaluation$lambda$6(suspendContext, frameProxy));
        return bl != null ? bl : false;
    }

    public static final boolean sameLineAndMethod(@NotNull Location $this$sameLineAndMethod, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)$this$sameLineAndMethod, (String)"<this>");
        return location != null && Intrinsics.areEqual((Object)SafeUtilKt.safeMethod(location), (Object)SafeUtilKt.safeMethod($this$sameLineAndMethod)) && SafeUtilKt.safeLineNumber(location) == SafeUtilKt.safeLineNumber($this$sameLineAndMethod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFilterFromTop(@NotNull Location $this$isFilterFromTop, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilterFromTop, (String)"<this>");
        if (CoroutineUtilsKt.isInvokeSuspendWithNegativeLineNumber($this$isFilterFromTop)) return true;
        if (CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromTop, location)) return true;
        Location location2 = location;
        if (!Intrinsics.areEqual((Object)(location2 != null ? SafeUtilKt.safeMethod(location2) : null), (Object)SafeUtilKt.safeMethod($this$isFilterFromTop))) return false;
        return true;
    }

    public static final boolean isFilterFromBottom(@NotNull Location $this$isFilterFromBottom, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilterFromBottom, (String)"<this>");
        return CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromBottom, location);
    }

    private static final XSourcePosition findPosition$lambda$3(DebugProcessImpl $debugProcess, Location $this_findPosition) {
        return DebuggerUtilsEx.toXSourcePosition((SourcePosition)$debugProcess.getPositionManager().getSourcePosition($this_findPosition));
    }

    private static final DefaultExecutionContext executionContext$lambda$4(SuspendContextImpl $this_executionContext) {
        return new DefaultExecutionContext($this_executionContext, $this_executionContext.getFrameProxy());
    }

    private static final Object invokeInManagerThread$lambda$5(Function0 $f, DebuggerContextImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $f.invoke();
    }

    private static final Boolean threadAndContextSupportsEvaluation$lambda$6(SuspendContextImpl $suspendContext, StackFrameProxyImpl $frameProxy) {
        StackFrameProxyImpl stackFrameProxyImpl;
        return CoroutineUtilsKt.supportsEvaluation($suspendContext) && ((stackFrameProxyImpl = $frameProxy) != null && (stackFrameProxyImpl = stackFrameProxyImpl.threadProxy()) != null ? CoroutineUtilsKt.supportsEvaluation((ThreadReferenceProxyImpl)stackFrameProxyImpl) : false);
    }
}

