/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.similarity;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesProvider;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.findUsages.similarity.KotlinSimilarityFeaturesExtractor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/similarity/KotlinUsageSimilarityFeaturesProvider;", "Lcom/intellij/usages/similarity/features/UsageSimilarityFeaturesProvider;", "<init>", "()V", "getFeatures", "Lcom/intellij/usages/similarity/bag/Bag;", "usage", "Lcom/intellij/psi/PsiElement;", "collectFeaturesForFunctionSignature", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "context", "toFeature", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getContext", "element", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nKotlinUsageSimilarityFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinUsageSimilarityFeaturesProvider.kt\norg/jetbrains/kotlin/idea/findUsages/similarity/KotlinUsageSimilarityFeaturesProvider\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,58:1\n67#2:59\n1863#3,2:60\n488#4,11:62\n*S KotlinDebug\n*F\n+ 1 KotlinUsageSimilarityFeaturesProvider.kt\norg/jetbrains/kotlin/idea/findUsages/similarity/KotlinUsageSimilarityFeaturesProvider\n*L\n28#1:59\n44#1:60,2\n49#1:62,11\n*E\n"})
public final class KotlinUsageSimilarityFeaturesProvider
implements UsageSimilarityFeaturesProvider {
    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public Bag getFeatures(@NotNull PsiElement usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Bag features = new Bag();
        if (!Registry.Companion.is("similarity.find.usages.kotlin.clustering.enable")) {
            return features;
        }
        PsiElement context2 = this.getContext(usage);
        if (context2 instanceof KtParameter || context2 instanceof KtFunction) {
            void $this$parentOfType$iv;
            PsiElement psiElement = context2;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
            if (ktFunction != null) {
                KtFunction it = ktFunction;
                boolean bl = false;
                features.addAll(this.collectFeaturesForFunctionSignature(it, context2));
            }
        } else if (context2 != null) {
            features.addAll(new KotlinSimilarityFeaturesExtractor(usage, context2).getFeatures());
        }
        return features;
    }

    private final Bag collectFeaturesForFunctionSignature(KtFunction function, PsiElement context2) {
        Bag bag;
        Bag $this$collectFeaturesForFunctionSignature_u24lambda_u242 = bag = new Bag();
        boolean bl = false;
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("OVERRIDE: " + function.hasModifier(KtTokens.OVERRIDE_KEYWORD));
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("NAME: " + function.getName());
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("FUNCTION_CLASS: " + Reflection.getOrCreateKotlinClass(function.getClass()));
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("RETURN_TYPE: " + this.toFeature(function.getTypeReference()));
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("RECEIVER_TYPE_REFERENCE: " + (function.getReceiverTypeReference() != null));
        List list2 = function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl2 = false;
            $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("PARAMETER_TYPE: " + (Intrinsics.areEqual((Object)it, (Object)context2) ? "USAGE: " : "") + this.toFeature(it.getTypeReference()));
        }
        return bag;
    }

    /*
     * WARNING - void declaration
     */
    private final String toFeature(KtTypeReference typeReference) {
        String string;
        Object object = typeReference;
        if (object != null && (object = object.getText()) != null) {
            void $this$filterNotTo$iv$iv;
            Object $this$filterNot$iv = object;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int j = 0; j < $this$filterNotTo$iv$iv.length(); ++j) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(j);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final PsiElement getContext(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, KotlinUsageSimilarityFeaturesProvider::getContext$lambda$4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getContext$lambda$4(PsiElement e) {
        if (e instanceof KtStatementExpression) return true;
        PsiElement psiElement = e;
        if ((psiElement != null ? psiElement.getParent() : null) instanceof KtBlockExpression) return true;
        if (!(e instanceof KtImportDirective)) return false;
        return true;
    }
}

