/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"counterpartNames", "", "", "getCounterpart", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "nameResolvesToStdlib", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "name", "startInPlaceRename", "", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nScopeFunctionConversionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ScopeFunctionConversionInspectionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1734#2,3:369\n*S KotlinDebug\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ScopeFunctionConversionInspectionKt\n*L\n93#1:369,3\n*E\n"})
public final class ScopeFunctionConversionInspectionKt {
    @NotNull
    private static final Map<String, String> counterpartNames;

    private static final String getCounterpart(KtCallExpression expression) {
        KtLambdaExpression lambdaExpression;
        KtExpression ktExpression = expression.getCalleeExpression();
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (ktNameReferenceExpression == null) {
            return null;
        }
        KtNameReferenceExpression callee = ktNameReferenceExpression;
        String calleeName = callee.getReferencedName();
        String counterpartName = counterpartNames.get(calleeName);
        List list2 = expression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        Object object = lambdaExpression = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
        if (counterpartName != null && lambdaExpression != null) {
            List list3 = lambdaExpression.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
            if (!((Collection)list3).isEmpty()) {
                return null;
            }
            BindingContext bindingContext = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)callee, BodyResolveMode.PARTIAL);
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)callee), (BindingContext)bindingContext);
            if (resolvedCall == null) {
                return null;
            }
            ResolvedCall resolvedCall2 = resolvedCall;
            CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
            CallableDescriptor descriptor2 = callableDescriptor;
            if (descriptor2.getDispatchReceiverParameter() == null && descriptor2.getExtensionReceiverParameter() == null) {
                return null;
            }
            if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)).asString(), (Object)("kotlin." + calleeName)) && ScopeFunctionConversionInspectionKt.nameResolvesToStdlib(expression, bindingContext, counterpartName)) {
                return counterpartName;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean nameResolvesToStdlib(KtCallExpression expression, BindingContext bindingContext, String name2) {
        DeclarationDescriptor it;
        LexicalScope lexicalScope = ScopeUtils.getResolutionScope((PsiElement)expression, bindingContext);
        if (lexicalScope == null) {
            return true;
        }
        LexicalScope scope = lexicalScope;
        Collection descriptors = ScopeUtilsKt.collectDescriptorsFiltered$default((HierarchicalScope)((HierarchicalScope)scope), null, arg_0 -> ScopeFunctionConversionInspectionKt.nameResolvesToStdlib$lambda$0(name2, arg_0), (boolean)false, (int)5, null);
        if (descriptors.isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$all$iv = descriptors;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (DeclarationDescriptor)element$iv;
            boolean bl2 = false;
        } while (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it).asString(), (Object)("kotlin." + name2)));
        return false;
    }

    private static final void startInPlaceRename(PsiElement $this$startInPlaceRename) {
        Project project = $this$startInPlaceRename.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = $this$startInPlaceRename.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        Document document2 = document;
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (Intrinsics.areEqual((Object)editor2.getDocument(), (Object)document2)) {
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            editor2.getCaretModel().moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)$this$startInPlaceRename));
            new KotlinVariableInplaceRenameHandler().doRename($this$startInPlaceRename, editor2, null);
        }
    }

    private static final boolean nameResolvesToStdlib$lambda$0(String $name, Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.asString(), (Object)$name);
    }

    public static final /* synthetic */ String access$getCounterpart(KtCallExpression expression) {
        return ScopeFunctionConversionInspectionKt.getCounterpart(expression);
    }

    public static final /* synthetic */ void access$startInPlaceRename(PsiElement $receiver) {
        ScopeFunctionConversionInspectionKt.startInPlaceRename($receiver);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"apply", (Object)"also"), TuplesKt.to((Object)"run", (Object)"let"), TuplesKt.to((Object)"also", (Object)"apply"), TuplesKt.to((Object)"let", (Object)"run")};
        counterpartNames = MapsKt.mapOf((Pair[])pairArray);
    }
}

