/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInspection.dataFlow.jvm.descriptors.JvmVariableDescriptor;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtLambdaSpecialVariableDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtThisDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaAndParameter;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaVariableKind;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessorKt;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\tH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtVariableDescriptor;", "Lcom/intellij/codeInspection/dataFlow/jvm/descriptors/JvmVariableDescriptor;", "variable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)V", "getVariable", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "stable", "", "getStable", "()Z", "calculateStable", "getVariablesChangedInNestedFunctions", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "parent", "Lcom/intellij/psi/PsiElement;", "isStable", "canBeCapturedInClosure", "getPsiElement", "getDfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "qualifier", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "kotlin.idea"})
public final class KtVariableDescriptor
extends JvmVariableDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCallableDeclaration variable;
    private final boolean stable;

    public KtVariableDescriptor(@NotNull KtCallableDeclaration variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.variable = variable;
        this.stable = this.calculateStable();
    }

    @NotNull
    public final KtCallableDeclaration getVariable() {
        return this.variable;
    }

    public final boolean getStable() {
        return this.stable;
    }

    private final boolean calculateStable() {
        if (this.variable instanceof KtParameter && ((KtParameter)this.variable).isMutable()) {
            return false;
        }
        if (!(this.variable instanceof KtProperty) || !((KtProperty)this.variable).isVar()) {
            return true;
        }
        if (!((KtProperty)this.variable).isLocal()) {
            return false;
        }
        PsiElement psiElement = ((KtProperty)this.variable).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        return !this.getVariablesChangedInNestedFunctions(psiElement).contains(this.variable);
    }

    private final Set<KtProperty> getVariablesChangedInNestedFunctions(PsiElement parent) {
        Object object = CachedValuesManager.getProjectPsiDependentCache((PsiElement)parent, arg_0 -> KtVariableDescriptor.getVariablesChangedInNestedFunctions$lambda$1(arg_0 -> KtVariableDescriptor.getVariablesChangedInNestedFunctions$lambda$0(parent, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProjectPsiDependentCache(...)");
        return (Set)object;
    }

    public boolean isStable() {
        return this.stable;
    }

    public boolean canBeCapturedInClosure() {
        if (this.variable instanceof KtParameter && ((KtParameter)this.variable).isMutable()) {
            return false;
        }
        return !(this.variable instanceof KtProperty) || !((KtProperty)this.variable).isVar();
    }

    @NotNull
    public KtCallableDeclaration getPsiElement() {
        return this.variable;
    }

    @NotNull
    public DfType getDfType(@Nullable DfaVariableValue qualifier2) {
        return KtDfaHelpersKt.toDfType(MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)this.variable));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof KtVariableDescriptor && Intrinsics.areEqual((Object)((KtVariableDescriptor)((Object)other)).variable, (Object)this.variable);
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.variable.getName();
        if (string == null) {
            string = "<unknown>";
        }
        return string;
    }

    private static final HashSet getVariablesChangedInNestedFunctions$lambda$0(PsiElement $parent, PsiElement scope) {
        HashSet<KtProperty> result2 = new HashSet<KtProperty>();
        PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)new PsiElementProcessor($parent, result2){
            final /* synthetic */ PsiElement $parent;
            final /* synthetic */ HashSet<KtProperty> $result;
            {
                this.$parent = $parent;
                this.$result = $result;
            }

            public final boolean execute(PsiElement e) {
                PsiElement target;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e instanceof KtSimpleNameExpression && ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)e), (boolean)false).isWrite() && (target = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)e)).resolve()) instanceof KtProperty && ((KtProperty)target).isLocal() && PsiTreeUtil.isAncestor((PsiElement)this.$parent, (PsiElement)target, (boolean)true)) {
                    KtFunction parentScope = null;
                    PsiElement context2 = e;
                    while (true) {
                        KtCallExpression maybeCall;
                        KtLambdaExpression maybeLambda;
                        KtFunction ktFunction = parentScope = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)context2, KtFunction.class);
                        PsiElement psiElement = ktFunction != null ? ktFunction.getParent() : null;
                        KtLambdaExpression ktLambdaExpression = maybeLambda = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
                        PsiElement psiElement2 = ktLambdaExpression != null ? ktLambdaExpression.getParent() : null;
                        KtLambdaArgument ktLambdaArgument = psiElement2 instanceof KtLambdaArgument ? (KtLambdaArgument)psiElement2 : null;
                        PsiElement psiElement3 = ktLambdaArgument != null ? ktLambdaArgument.getParent() : null;
                        KtCallExpression ktCallExpression = maybeCall = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
                        if (maybeCall == null) break;
                        LambdaAndParameter lambdaAndParameter = KtDfaHelpersKt.getInlineableLambda(maybeCall);
                        if (!Intrinsics.areEqual((Object)(lambdaAndParameter != null ? lambdaAndParameter.getLambda() : null), (Object)maybeLambda)) break;
                        context2 = (PsiElement)maybeCall;
                    }
                    if (parentScope != null && PsiTreeUtil.isAncestor((PsiElement)this.$parent, (PsiElement)((PsiElement)parentScope), (boolean)true)) {
                        this.$result.add((KtProperty)target);
                    }
                }
                return true;
            }
        });
        return result2;
    }

    private static final HashSet getVariablesChangedInNestedFunctions$lambda$1(Function1 $tmp0, Object p0) {
        return (HashSet)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtVariableDescriptor$Companion;", "", "<init>", "()V", "getSingleLambdaParameter", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "getLambdaReceiver", "createFromQualified", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createFromSimpleName", "isTrackableProperty", "", "target", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DfaVariableValue getSingleLambdaParameter(@NotNull DfaValueFactory factory2, @NotNull KtLambdaExpression lambda2) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
            List list2 = lambda2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            List parameters2 = list2;
            if (parameters2.size() > 1) {
                return null;
            }
            if (parameters2.size() == 1) {
                DfaVariableValue dfaVariableValue;
                if (((KtParameter)parameters2.get(0)).getDestructuringDeclaration() == null) {
                    DfaVariableValue.Factory factory3 = factory2.getVarFactory();
                    Object e = parameters2.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    dfaVariableValue = factory3.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)e));
                } else {
                    dfaVariableValue = null;
                }
                return dfaVariableValue;
            }
            Object object = UtilsKt.resolveType$default((KtExpression)lambda2, null, 1, null);
            if (object == null || (object = FunctionTypesKt.getValueParameterTypesFromFunctionType((KotlinType)object)) == null || (object = (TypeProjection)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getType()) == null) {
                return null;
            }
            Object kotlinType = object;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
            KtLambdaSpecialVariableDescriptor descriptor2 = new KtLambdaSpecialVariableDescriptor(ktFunctionLiteral, LambdaVariableKind.IT, (KotlinType)kotlinType);
            return factory2.getVarFactory().createVariableValue((VariableDescriptor)descriptor2);
        }

        @Nullable
        public final DfaVariableValue getLambdaReceiver(@NotNull DfaValueFactory factory2, @NotNull KtLambdaExpression lambda2) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
            KotlinType kotlinType = UtilsKt.resolveType$default((KtExpression)lambda2, null, 1, null);
            if (kotlinType == null || (kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType((KotlinType)kotlinType)) == null) {
                return null;
            }
            KotlinType receiverType = kotlinType;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
            KtLambdaSpecialVariableDescriptor descriptor2 = new KtLambdaSpecialVariableDescriptor(ktFunctionLiteral, LambdaVariableKind.THIS, receiverType);
            return factory2.getVarFactory().createVariableValue((VariableDescriptor)descriptor2);
        }

        @Nullable
        public final DfaVariableValue createFromQualified(@NotNull DfaValueFactory factory2, @Nullable KtExpression expr) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            KtExpression selector2 = expr;
            while (selector2 instanceof KtQualifiedExpression) {
                selector2 = ((KtQualifiedExpression)selector2).getSelectorExpression();
            }
            return this.createFromSimpleName(factory2, selector2);
        }

        @Nullable
        public final DfaVariableValue createFromSimpleName(@NotNull DfaValueFactory factory2, @Nullable KtExpression expr) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            DfaVariableValue.Factory factory3 = factory2.getVarFactory();
            Intrinsics.checkNotNullExpressionValue((Object)factory3, (String)"getVarFactory(...)");
            DfaVariableValue.Factory varFactory = factory3;
            if (expr instanceof KtSimpleNameExpression) {
                DeclarationDescriptor descriptor2;
                PsiElement target = ResolutionUtils.resolveMainReference((KtReferenceExpression)expr);
                if (target instanceof KtCallableDeclaration) {
                    if (target instanceof KtParameter && !(((KtParameter)target).getOwnerFunction() instanceof KtPrimaryConstructor) || target instanceof KtProperty && ((KtProperty)target).isLocal() || target instanceof KtDestructuringDeclarationEntry) {
                        return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target));
                    }
                    if (this.isTrackableProperty(target)) {
                        PsiElement parent = ((KtSimpleNameExpression)expr).getParent();
                        DfaVariableValue qualifier2 = null;
                        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtClassBody.class)};
                        if (CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)target), kClassArray, Reflection.getOrCreateKotlinClass(KtObjectDeclaration.class)) != null) {
                            return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target), null);
                        }
                        if (parent instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent).getSelectorExpression(), (Object)expr)) {
                            KtExpression receiver2 = ((KtQualifiedExpression)parent).getReceiverExpression();
                            qualifier2 = this.createFromSimpleName(factory2, receiver2);
                        } else {
                            ClassDescriptor classOrObject;
                            if (((KtCallableDeclaration)target).getParent() instanceof KtFile) {
                                return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target), null);
                            }
                            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)target));
                            ClassDescriptor classDescriptor = classOrObject = ktClassOrObject != null ? ResolutionUtils.resolveToDescriptorIfAny$default(ktClassOrObject, null, 1, null) : null;
                            if (classOrObject != null) {
                                DfType dfType = KtDfaHelpersKt.toDfType((KotlinType)classOrObject.getDefaultType());
                                qualifier2 = varFactory.createVariableValue((VariableDescriptor)new KtThisDescriptor((DeclarationDescriptor)classOrObject, dfType));
                            }
                        }
                        if (qualifier2 != null) {
                            return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target), qualifier2);
                        }
                    }
                }
                if (((KtSimpleNameExpression)expr).textMatches((CharSequence)StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier()) && (descriptor2 = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)expr))) instanceof ValueParameterDescriptor) {
                    KtElement fn;
                    SourceElement sourceElement = ModuleVisibilityUtilsKt.getToSourceElement((DeclarationDescriptor)((DeclarationDescriptor)((ValueParameterDescriptor)descriptor2).getContainingDeclaration()));
                    KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
                    Object object = fn = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
                    if (fn instanceof KtFunctionLiteral) {
                        KotlinType kotlinType = ((ValueParameterDescriptor)descriptor2).getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                        KotlinType type2 = kotlinType;
                        return varFactory.createVariableValue((VariableDescriptor)new KtLambdaSpecialVariableDescriptor((KtFunctionLiteral)fn, LambdaVariableKind.IT, type2));
                    }
                }
            }
            return null;
        }

        private final boolean isTrackableProperty(PsiElement target) {
            return target instanceof KtParameter && ((KtParameter)target).getOwnerFunction() instanceof KtPrimaryConstructor || target instanceof KtProperty && !((KtProperty)target).hasDelegate() && ((KtProperty)target).getGetter() == null && ((KtProperty)target).getSetter() == null && !PsiModificationUtilsKt.isOverridable((KtProperty)target) && !KtPsiUtilKt.isExtensionDeclaration((PsiElement)target) && ModifierListModifactorKt.findAnnotation((KtAnnotated)target, JvmAnnotationUtilKt.VOLATILE_ANNOTATION_FQ_NAME) == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

