/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\f\u0010\b\u001a\u00020\u0002*\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\u00020\u0006*\u0004\u0018\u00010\nH\u0002J\u001d\u0010\u001b\u001a\u00020\u0006*\u00020\n2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u001dJ\f\u0010\u001e\u001a\u00020\u0006*\u00020\nH\u0002J\f\u0010\u001f\u001a\u00020\u0006*\u00020\nH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SimplifyBooleanWithConstantsIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "isApplicableTo", "", "element", "topBinary", "areThereExpressionsToBeSimplified", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isPositiveNegativeZeroComparison", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "removeRedundantAssertion", "expression", "removeRedundantAssertion$kotlin_idea", "toSimplifiedExpression", "toSimplifiedBooleanBinaryExpressionWithConstantOperand", "constantOperand", "otherOperand", "operation", "Lcom/intellij/psi/tree/IElementType;", "simplifyExpression", "hasBooleanType", "canBeReducedToBooleanConstant", "constant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Boolean;)Z", "canBeReducedToTrue", "canBeReducedToFalse", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSimplifyBooleanWithConstantsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyBooleanWithConstantsIntention.kt\norg/jetbrains/kotlin/idea/intentions/SimplifyBooleanWithConstantsIntention\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,196:1\n26#2,7:197\n22#2:205\n22#2:206\n26#2,7:207\n154#3:204\n*S KotlinDebug\n*F\n+ 1 SimplifyBooleanWithConstantsIntention.kt\norg/jetbrains/kotlin/idea/intentions/SimplifyBooleanWithConstantsIntention\n*L\n92#1:197,7\n132#1:205\n157#1:206\n182#1:207,7\n97#1:204\n*E\n"})
public final class SimplifyBooleanWithConstantsIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    public SimplifyBooleanWithConstantsIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage((String)"simplify.boolean.expression", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.areThereExpressionsToBeSimplified((KtExpression)this.topBinary(element));
    }

    private final KtBinaryExpression topBinary(KtBinaryExpression $this$topBinary) {
        Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)$this$topBinary)), SimplifyBooleanWithConstantsIntention::topBinary$lambda$0));
        KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
        if (ktBinaryExpression == null) {
            ktBinaryExpression = $this$topBinary;
        }
        return ktBinaryExpression;
    }

    private final boolean areThereExpressionsToBeSimplified(KtExpression element) {
        if (element == null) {
            return false;
        }
        KtExpression ktExpression = element;
        if (ktExpression instanceof KtParenthesizedExpression) {
            return this.areThereExpressionsToBeSimplified(((KtParenthesizedExpression)element).getExpression());
        }
        if (ktExpression instanceof KtBinaryExpression) {
            IElementType iElementType = ((KtBinaryExpression)element).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
            IElementType op = iElementType;
            if (Intrinsics.areEqual((Object)op, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)op, (Object)KtTokens.OROR) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EXCLEQ)) {
                if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element).getLeft()) && this.hasBooleanType(((KtBinaryExpression)element).getRight())) {
                    return true;
                }
                if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element).getRight()) && this.hasBooleanType(((KtBinaryExpression)element).getLeft())) {
                    return true;
                }
            }
            if (this.isPositiveNegativeZeroComparison((KtBinaryExpression)element)) {
                return false;
            }
        }
        return SimplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant$default(this, element, null, 1, null);
    }

    private final boolean isPositiveNegativeZeroComparison(KtBinaryExpression element) {
        IElementType iElementType = element.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType op = iElementType;
        if (!Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) && !Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQEQ)) {
            return false;
        }
        KtExpression ktExpression = element.getLeft();
        KtElement ktElement = ktExpression != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression)) : null;
        KtExpression ktExpression2 = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression left = ktExpression2;
        KtExpression ktExpression3 = element.getRight();
        KtElement ktElement2 = ktExpression3 != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression3)) : null;
        KtExpression ktExpression4 = ktElement2 instanceof KtExpression ? (KtExpression)ktElement2 : null;
        if (ktExpression4 == null) {
            return false;
        }
        KtExpression right = ktExpression4;
        BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)element, BodyResolveMode.PARTIAL);
        Object leftValue = SimplifyBooleanWithConstantsIntention.isPositiveNegativeZeroComparison$getConstantValue(left, context2);
        Object rightValue = SimplifyBooleanWithConstantsIntention.isPositiveNegativeZeroComparison$getConstantValue(right, context2);
        boolean hasPositiveZero = SimplifyBooleanWithConstantsIntention.isPositiveNegativeZeroComparison$isPositiveZero(leftValue) || SimplifyBooleanWithConstantsIntention.isPositiveNegativeZeroComparison$isPositiveZero(rightValue);
        boolean hasNegativeZero = SimplifyBooleanWithConstantsIntention.isPositiveNegativeZeroComparison$isNegativeZero(leftValue) || SimplifyBooleanWithConstantsIntention.isPositiveNegativeZeroComparison$isNegativeZero(rightValue);
        return hasPositiveZero && hasNegativeZero;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtBinaryExpression element, @Nullable Editor editor) {
        PsiElement psiElement;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtBinaryExpression topBinary = this.topBinary(element);
        KtExpression simplified = this.toSimplifiedExpression((KtExpression)topBinary);
        PsiElement psiElement2 = (PsiElement)topBinary;
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)simplified, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(...)");
        PsiElement newElement$iv = (PsiElement)ktExpression;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression2;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"replaced(...)");
        KtExpression result2 = (KtExpression)psiElement;
        this.removeRedundantAssertion$kotlin_idea(result2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeRedundantAssertion$kotlin_idea(@NotNull KtExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)expression;
        boolean $i$f$getNonStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtCallExpression.class, (boolean)false);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor((KtExpression)callExpression);
        FqName fqName2 = callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null;
        List list2 = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        List valueArguments = list2;
        FqName fqName3 = fqName2;
        if (!Intrinsics.areEqual((Object)(fqName3 != null ? fqName3.asString() : null), (Object)"kotlin.assert")) return;
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)valueArguments);
        if (!KotlinPsiUtilsKt.isTrueConstant((KtExpression)(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null))) return;
        boolean bl = true;
        boolean isRedundant = bl;
        if (!isRedundant) return;
        callExpression.delete();
    }

    private final KtExpression toSimplifiedExpression(KtExpression expression) {
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        if (this.canBeReducedToTrue(expression)) {
            return psiFactory.createExpression("true");
        }
        if (this.canBeReducedToFalse(expression)) {
            return psiFactory.createExpression("false");
        }
        if (expression instanceof KtParenthesizedExpression) {
            KtExpression expr = ((KtParenthesizedExpression)expression).getExpression();
            if (expr != null) {
                KtExpression ktExpression;
                KtExpression simplified = this.toSimplifiedExpression(expr);
                if (simplified instanceof KtBinaryExpression) {
                    Object[] objectArray = new Object[]{simplified};
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"($0)", (Object[])objectArray, (boolean)false, (int)4, null);
                } else {
                    ktExpression = simplified;
                }
                return ktExpression;
            }
        } else if (expression instanceof KtBinaryExpression) {
            if (!this.areThereExpressionsToBeSimplified(expression)) {
                PsiElement $this$copied$iv = (PsiElement)expression;
                boolean $i$f$copied = false;
                PsiElement psiElement = $this$copied$iv.copy();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                return (KtExpression)((PsiElement)((KtBinaryExpression)psiElement));
            }
            KtExpression left = ((KtBinaryExpression)expression).getLeft();
            KtExpression right = ((KtBinaryExpression)expression).getRight();
            IElementType iElementType = ((KtBinaryExpression)expression).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
            IElementType op = iElementType;
            if (left != null && right != null && (Intrinsics.areEqual((Object)op, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)op, (Object)KtTokens.OROR) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EXCLEQ))) {
                KtExpression ktExpression;
                KtExpression simpleLeft = this.simplifyExpression(left);
                KtExpression simpleRight = this.simplifyExpression(right);
                if (this.canBeReducedToTrue(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleRight, op);
                } else if (this.canBeReducedToFalse(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleRight, op);
                } else if (this.canBeReducedToTrue(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleLeft, op);
                } else if (this.canBeReducedToFalse(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleLeft, op);
                } else {
                    String opText = ((KtBinaryExpression)expression).getOperationReference().getText();
                    Object[] objectArray = new Object[]{simpleLeft, simpleRight};
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0 " + opText + " $1"), (Object[])objectArray, (boolean)false, (int)4, null);
                }
                return ktExpression;
            }
        }
        PsiElement $this$copied$iv = (PsiElement)expression;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        return (KtExpression)((PsiElement)((KtExpression)psiElement));
    }

    private final KtExpression toSimplifiedBooleanBinaryExpressionWithConstantOperand(boolean constantOperand, KtExpression otherOperand, IElementType operation) {
        Project project = otherOperand.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        IElementType iElementType = operation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
            if (constantOperand) {
                return psiFactory.createExpression("true");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
            if (!constantOperand) {
                return psiFactory.createExpression("false");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            KtExpression ktExpression;
            KtExpression it = this.toSimplifiedExpression(otherOperand);
            boolean bl = false;
            if (constantOperand == Intrinsics.areEqual((Object)operation, (Object)KtTokens.EQEQ)) {
                ktExpression = it;
            } else {
                Object[] objectArray = new Object[]{it};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"!$0", (Object[])objectArray, (boolean)false, (int)4, null);
            }
            return ktExpression;
        }
        return this.toSimplifiedExpression(otherOperand);
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression simplifyExpression(KtExpression expression) {
        PsiElement psiElement;
        void $this$replaced$iv;
        PsiElement psiElement2 = (PsiElement)expression;
        PsiElement newElement$iv = (PsiElement)this.toSimplifiedExpression(expression);
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression;
            }
        }
        return (KtExpression)psiElement;
    }

    private final boolean hasBooleanType(KtExpression $this$hasBooleanType) {
        KtExpression ktExpression = $this$hasBooleanType;
        if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)$this$hasBooleanType, BodyResolveMode.PARTIAL))) == null) {
            return false;
        }
        KtExpression type2 = ktExpression;
        return KotlinBuiltIns.isBoolean((KotlinType)type2) && !FlexibleTypesKt.isFlexible((KotlinType)type2);
    }

    private final boolean canBeReducedToBooleanConstant(KtExpression $this$canBeReducedToBooleanConstant, Boolean constant) {
        return CompileTimeConstantUtils.canBeReducedToBooleanConstant((KtExpression)$this$canBeReducedToBooleanConstant, (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)$this$canBeReducedToBooleanConstant, BodyResolveMode.PARTIAL), (Boolean)constant);
    }

    static /* synthetic */ boolean canBeReducedToBooleanConstant$default(SimplifyBooleanWithConstantsIntention simplifyBooleanWithConstantsIntention, KtExpression ktExpression, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return simplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant(ktExpression, bl);
    }

    private final boolean canBeReducedToTrue(KtExpression $this$canBeReducedToTrue) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToTrue, true);
    }

    private final boolean canBeReducedToFalse(KtExpression $this$canBeReducedToFalse) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToFalse, false);
    }

    private static final boolean topBinary$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtBinaryExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object isPositiveNegativeZeroComparison$getConstantValue(KtExpression $this$isPositiveNegativeZeroComparison_u24getConstantValue, BindingContext context2) {
        CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant($this$isPositiveNegativeZeroComparison_u24getConstantValue, context2);
        CompileTimeConstant compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant == null) return null;
        SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
        ConstantValue constantValue = compileTimeConstant2.toConstantValue((KotlinType)simpleType);
        compileTimeConstant2 = constantValue;
        if (constantValue == null) return null;
        Object object = compileTimeConstant2.getValue();
        return object;
    }

    private static final boolean isPositiveNegativeZeroComparison$isPositiveZero(Object value) {
        return Intrinsics.areEqual((Object)value, (Object)0.0) || Intrinsics.areEqual((Object)value, (Object)Float.valueOf(0.0f));
    }

    private static final boolean isPositiveNegativeZeroComparison$isNegativeZero(Object value) {
        return Intrinsics.areEqual((Object)value, (Object)-0.0) || Intrinsics.areEqual((Object)value, (Object)Float.valueOf(-0.0f));
    }
}

