/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.joinLines.JoinToStringTemplateHandlerKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinToStringTemplateHandler;", "Lcom/intellij/codeInsight/editorActions/JoinRawLinesHandlerDelegate;", "<init>", "()V", "tryJoinRawLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "unescape", "", "expr", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "createStringTemplate", "left", "rightText", "tryJoinLines", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nJoinToStringTemplateHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JoinToStringTemplateHandler.kt\norg/jetbrains/kotlin/idea/joinLines/JoinToStringTemplateHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class JoinToStringTemplateHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start2, int end) {
        int n;
        KtExpression ktExpression;
        KtBinaryExpression ktBinaryExpression;
        block19: {
            block18: {
                KtBinaryExpression it;
                Object object;
                block17: {
                    block16: {
                        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (!(file instanceof KtFile)) {
                            return -1;
                        }
                        if (start2 == 0) {
                            return -1;
                        }
                        char c = document.getCharsSequence().charAt(start2);
                        int index2 = c == '\n' ? start2 - 1 : start2;
                        object = ((KtFile)file).findElementAt(index2);
                        if (object == null) break block16;
                        it = ktBinaryExpression = object;
                        boolean bl = false;
                        ASTNode aSTNode = it.getNode();
                        object = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.PLUS) ? ktBinaryExpression : null;
                        if (object != null) break block17;
                    }
                    return -1;
                }
                KtBinaryExpression plus = object;
                ktBinaryExpression = new KtBinaryExpression[]{Reflection.getOrCreateKotlinClass(KtOperationReferenceExpression.class)};
                KtBinaryExpression ktBinaryExpression2 = (KtBinaryExpression)CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)plus), ktBinaryExpression, Reflection.getOrCreateKotlinClass(KtBinaryExpression.class));
                if (ktBinaryExpression2 == null) break block18;
                KtBinaryExpression p0 = it = ktBinaryExpression2;
                boolean $i$f$tryJoinRawLines$stub_for_inlining = false;
                boolean bl = false;
                Object object2 = ktBinaryExpression = JoinToStringTemplateHandlerKt.access$joinable(p0) ? it : null;
                if (ktBinaryExpression != null) break block19;
            }
            return -1;
        }
        KtBinaryExpression binaryExpr = ktBinaryExpression;
        int lineCount = PsiLinesUtilsKt.getLineCount((PsiElement)binaryExpr);
        PsiElement parent = binaryExpr.getParent();
        while (parent instanceof KtBinaryExpression && JoinToStringTemplateHandlerKt.access$joinable((KtBinaryExpression)parent) && PsiLinesUtilsKt.getLineCount(parent) == lineCount) {
            binaryExpr = (KtBinaryExpression)parent;
            parent = ((KtBinaryExpression)parent).getParent();
        }
        KtExpression ktExpression2 = binaryExpr.getRight();
        Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        Object rightText = this.unescape((KtStringTemplateExpression)ktExpression2);
        KtExpression left = binaryExpr.getLeft();
        while (left instanceof KtBinaryExpression && JoinToStringTemplateHandlerKt.access$joinable((KtBinaryExpression)left)) {
            KtBinaryExpression leftLeft;
            KtExpression ktExpression3 = left;
            KtBinaryExpression ktBinaryExpression3 = ktExpression3 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression3 : null;
            if (ktBinaryExpression3 == null) break;
            if ((ktBinaryExpression3 = ktBinaryExpression3.getLeft()) == null || PsiLinesUtilsKt.getLineCount((PsiElement)(leftLeft = ktBinaryExpression3)) < lineCount - 1) break;
            KtExpression ktExpression4 = ((KtBinaryExpression)left).getRight();
            Intrinsics.checkNotNull((Object)ktExpression4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
            rightText = this.unescape((KtStringTemplateExpression)ktExpression4) + (String)rightText;
            left = ((KtBinaryExpression)left).getLeft();
        }
        if ((ktExpression = left) instanceof KtStringTemplateExpression) {
            int offset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)left)) - 1;
            binaryExpr.replace((PsiElement)this.createStringTemplate((KtStringTemplateExpression)left, (String)rightText));
            n = offset;
        } else if (ktExpression instanceof KtBinaryExpression) {
            KtExpression leftRight = ((KtBinaryExpression)left).getRight();
            if (leftRight instanceof KtStringTemplateExpression) {
                int offset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)leftRight)) - 1;
                ((KtStringTemplateExpression)leftRight).replace((PsiElement)this.createStringTemplate((KtStringTemplateExpression)leftRight, (String)rightText));
                binaryExpr.replace((PsiElement)left);
                n = offset;
            } else {
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    private final String unescape(KtStringTemplateExpression expr) {
        String string;
        String expressionText = expr.getText();
        Intrinsics.checkNotNull((Object)expressionText);
        if (StringsKt.startsWith$default((String)expressionText, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)expressionText, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            String string2 = expressionText.substring(3, expressionText.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String unquoted = string2;
            String string3 = StringUtil.escapeStringCharacters((String)unquoted);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            String string4 = StringUtil.unquoteString((String)expressionText);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        return string;
    }

    private final KtStringTemplateExpression createStringTemplate(KtStringTemplateExpression left, String rightText) {
        String leftText = this.unescape(left);
        Project project = left.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression ktExpression = new KtPsiFactory(project, false, 2, null).createExpression("\"" + leftText + rightText + "\"");
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        return (KtStringTemplateExpression)ktExpression;
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return -1;
    }
}

