/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionInfo;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinImportQuickFixAction;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.SymbolBasedAutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.ImportFixHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001$B'\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0094\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J:\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010#\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinImportQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/codeInspection/HintAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "text", "", "importVariants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;Ljava/util/List;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "createImportAction", "Lcom/intellij/codeInsight/hint/QuestionAction;", "createAutoImportAction", "filterSuggestions", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/name/FqName;", "showHint", "", "modificationCountOnCreate", "", "isOutdated", "isAvailable", "ImportQuestionAction", "kotlin.code-insight.fixes.k2"})
@SourceDebugExtension(value={"SMAP\nImportQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportQuickFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1557#2:151\n1628#2,3:152\n774#2:155\n865#2,2:156\n*S KotlinDebug\n*F\n+ 1 ImportQuickFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportQuickFix\n*L\n53#1:151\n53#1:152,3\n56#1:155\n56#1:156,2\n*E\n"})
public final class ImportQuickFix
extends KotlinImportQuickFixAction<KtElement>
implements HintAction,
HighPriorityAction {
    @NotNull
    private final String text;
    @NotNull
    private final List<AutoImportVariant> importVariants;
    private final long modificationCountOnCreate;

    public ImportQuickFix(@NotNull KtElement element, @IntentionName @NotNull String text, @NotNull List<? extends AutoImportVariant> importVariants) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(importVariants, (String)"importVariants");
        super(element);
        this.text = text;
        this.importVariants = importVariants;
        if (!(!((Collection)this.importVariants).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.modificationCountOnCreate = PsiModificationTracker.getInstance((Project)element.getProject()).getModificationCount();
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.import", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (editor == null) {
                return;
            }
            QuestionAction questionAction = this.createImportAction(editor, file);
            if (questionAction == null) break block1;
            questionAction.execute();
        }
    }

    @Override
    @Nullable
    public QuestionAction createImportAction(@NotNull Editor editor, @NotNull KtFile file) {
        QuestionAction questionAction;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.getElement() != null) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            questionAction = new ImportQuestionAction(project, editor, file, this.importVariants, false, 16, null);
        } else {
            questionAction = null;
        }
        return questionAction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public QuestionAction createAutoImportAction(@NotNull Editor editor, @NotNull KtFile file, @NotNull Function1<? super Collection<FqName>, ? extends Collection<FqName>> filterSuggestions) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(filterSuggestions, (String)"filterSuggestions");
        Iterable iterable = this.importVariants;
        Function1<? super Collection<FqName>, ? extends Collection<FqName>> function1 = filterSuggestions;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AutoImportVariant autoImportVariant = (AutoImportVariant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFqName());
        }
        Set filteredFqNames = CollectionsKt.toSet((Iterable)((Iterable)function1.invoke((Object)((List)destination$iv$iv))));
        if (filteredFqNames.size() != 1) {
            return null;
        }
        Iterable $this$filter$iv = this.importVariants;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AutoImportVariant it = (AutoImportVariant)element$iv$iv;
            boolean bl = false;
            if (!filteredFqNames.contains(it.getFqName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        AutoImportVariant singleSuggestion = (AutoImportVariant)CollectionsKt.first((List)((List)destination$iv$iv2));
        Intrinsics.checkNotNull((Object)singleSuggestion, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.SymbolBasedAutoImportVariant");
        if (((SymbolBasedAutoImportVariant)singleSuggestion).getCanNotBeImportedOnTheFly()) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new ImportQuestionAction(project, editor, file, CollectionsKt.listOf((Object)singleSuggestion), true);
    }

    public boolean showHint(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return false;
        }
        KtElement element = ktElement;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        TextRange elementRange = element.getTextRange();
        Object[] objectArray = new Object[]{((AutoImportVariant)CollectionsKt.first(this.importVariants)).getFqName().asString()};
        String autoImportHintText = KotlinBundle.message((String)"fix.import.question", (Object[])objectArray);
        QuestionAction questionAction = this.createImportAction(editor, file);
        if (questionAction == null) {
            return false;
        }
        QuestionAction importAction = questionAction;
        HintManager.getInstance().showQuestionHint(editor, autoImportHintText, elementRange.getStartOffset(), elementRange.getEndOffset(), importAction);
        return true;
    }

    private final boolean isOutdated(Project project) {
        return this.modificationCountOnCreate != PsiModificationTracker.getInstance((Project)project).getModificationCount();
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !this.isOutdated(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportQuickFix$ImportQuestionAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "importVariants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "onTheFly", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/List;Z)V", "execute", "addImport", "", "importVariant", "kotlin.code-insight.fixes.k2"})
    private static final class ImportQuestionAction
    implements QuestionAction {
        @NotNull
        private final Project project;
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFile file;
        @NotNull
        private final List<AutoImportVariant> importVariants;
        private final boolean onTheFly;

        public ImportQuestionAction(@NotNull Project project, @NotNull Editor editor, @NotNull KtFile file, @NotNull List<? extends AutoImportVariant> importVariants, boolean onTheFly) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(importVariants, (String)"importVariants");
            this.project = project;
            this.editor = editor;
            this.file = file;
            this.importVariants = importVariants;
            this.onTheFly = onTheFly;
            if (!(!((Collection)this.importVariants).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ ImportQuestionAction(Project project, Editor editor, KtFile ktFile2, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(project, editor, ktFile2, list2, bl);
        }

        public boolean execute() {
            KotlinAddImportActionInfo.ExecuteListener executeListener = KotlinAddImportActionInfo.INSTANCE.getExecuteListener((PsiFile)this.file);
            if (executeListener != null) {
                executeListener.onExecute(this.importVariants);
            }
            switch (this.importVariants.size()) {
                case 1: {
                    this.addImport((AutoImportVariant)CollectionsKt.single(this.importVariants));
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            if (this.onTheFly) {
                return false;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.addImport((AutoImportVariant)CollectionsKt.first(this.importVariants));
                return true;
            }
            ImportFixHelper.INSTANCE.createListPopupWithImportVariants(this.project, this.importVariants, (Function1<? super AutoImportVariant, Unit>)((Function1)new Function1<AutoImportVariant, Unit>((Object)this){

                public final void invoke(AutoImportVariant p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ImportQuestionAction.access$addImport((ImportQuestionAction)this.receiver, p0);
                }
            })).showInBestPositionFor(this.editor);
            return true;
        }

        private final void addImport(AutoImportVariant importVariant) {
            if (!(importVariant instanceof SymbolBasedAutoImportVariant)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            StatisticsManager.getInstance().incUseCount(((SymbolBasedAutoImportVariant)importVariant).getStatisticsInfo());
            String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ApplicationUtilsKt.executeWriteCommand(this.project, string, (Function0<Unit>)((Function0)() -> ImportQuestionAction.addImport$lambda$0(this, importVariant)));
        }

        private static final Unit addImport$lambda$0(ImportQuestionAction this$0, AutoImportVariant $importVariant) {
            ImportInsertionKt.addImport$default(this$0.file, ((SymbolBasedAutoImportVariant)$importVariant).getFqName(), false, null, null, 14, null);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$addImport(ImportQuestionAction $this, AutoImportVariant importVariant) {
            $this.addImport(importVariant);
        }
    }
}

