/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.macros;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinBundledRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBundledRefresher.kt\norg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,65:1\n73#2:66\n*S KotlinDebug\n*F\n+ 1 KotlinBundledRefresher.kt\norg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher\n*L\n28#1:66\n*E\n"})
public final class KotlinBundledRefresher
implements ProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INSTALLED_KOTLIN_VERSION = "installed.kotlin.plugin.version";

    public KotlinBundledRefresher() {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.blockingContext(KotlinBundledRefresher::execute$lambda$0, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$0() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String installedKotlinVersion = propertiesComponent.getValue(INSTALLED_KOTLIN_VERSION);
        if (!Intrinsics.areEqual((Object)KotlinIdePlugin.INSTANCE.getVersion(), (Object)installedKotlinVersion)) {
            Path path2 = KotlinPluginLayout.getKotlinc().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            Companion.requestKotlinDistRefresh(path2);
            propertiesComponent.setValue(INSTALLED_KOTLIN_VERSION, KotlinIdePlugin.INSTANCE.getVersion());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher$Companion;", "", "<init>", "()V", "INSTALLED_KOTLIN_VERSION", "", "requestFullJarUpdate", "", "jarFilePath", "Ljava/nio/file/Path;", "requestKotlinDistRefresh", "kotlinBundledPath", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinBundledRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBundledRefresher.kt\norg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1#2:66\n774#3:67\n865#3,2:68\n1863#3,2:70\n*S KotlinDebug\n*F\n+ 1 KotlinBundledRefresher.kt\norg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher$Companion\n*L\n60#1:67\n60#1:68,2\n61#1:70,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void requestFullJarUpdate(Path jarFilePath) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(jarFilePath);
            if (virtualFile == null) {
                return;
            }
            VirtualFile localVirtualFile = virtualFile;
            VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(localVirtualFile);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile jarFile = virtualFile2;
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtilCore.visitChildrenRecursively((VirtualFile)jarFile, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(optionArray){}));
            ((NewVirtualFile)jarFile).markDirtyRecursively();
        }

        /*
         * WARNING - void declaration
         */
        public final void requestKotlinDistRefresh(@NotNull Path kotlinBundledPath) {
            void $this$filterTo$iv$iv;
            Path path2;
            Intrinsics.checkNotNullParameter((Object)kotlinBundledPath, (String)"kotlinBundledPath");
            Iterable<Path> it = path2 = kotlinBundledPath.resolve("lib");
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22 = false;
                String $i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22 = "kotlin-dist invalid dir layout";
                throw new IllegalArgumentException($i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22.toString());
            }
            Path path3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"also(...)");
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)path3, null, (int)1, null);
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it2 = (Path)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it2), (Object)"jar")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it3 = (Path)element$iv;
                boolean bl3 = false;
                Companion.requestFullJarUpdate(it3);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

