/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.IKotlinFacetSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixFactory;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.inspections.KotlinInspectionsBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\tJ\b\u0010\u0015\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "featureSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "featureShortName", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature;Lorg/jetbrains/kotlin/config/LanguageFeature$State;Ljava/lang/String;)V", "getFeature", "()Lorg/jetbrains/kotlin/config/LanguageFeature;", "getFeatureSupport", "()Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "featureSupportEnabled", "", "getFeatureSupportEnabled", "()Z", "getFamilyName", "getText", "Companion", "FeatureSupportIntentionActionsFactory", "kotlin.inspections"})
public abstract class AbstractChangeFeatureSupportLevelFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageFeature feature;
    @NotNull
    private final LanguageFeature.State featureSupport;
    @NotNull
    private final String featureShortName;

    public AbstractChangeFeatureSupportLevelFix(@NotNull PsiElement element, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State featureSupport, @NotNull String featureShortName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)featureSupport, (String)"featureSupport");
        Intrinsics.checkNotNullParameter((Object)featureShortName, (String)"featureShortName");
        super(element);
        this.feature = feature;
        this.featureSupport = featureSupport;
        this.featureShortName = featureShortName;
    }

    public /* synthetic */ AbstractChangeFeatureSupportLevelFix(PsiElement psiElement, LanguageFeature languageFeature, LanguageFeature.State state, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = languageFeature.getPresentableName();
        }
        this(psiElement, languageFeature, state, string);
    }

    @NotNull
    protected final LanguageFeature getFeature() {
        return this.feature;
    }

    @NotNull
    protected final LanguageFeature.State getFeatureSupport() {
        return this.featureSupport;
    }

    protected final boolean getFeatureSupportEnabled() {
        return this.featureSupport == LanguageFeature.State.ENABLED || this.featureSupport == LanguageFeature.State.ENABLED_WITH_WARNING;
    }

    @NotNull
    public final String getFamilyName() {
        Object[] objectArray = new Object[]{this.featureShortName};
        return KotlinInspectionsBundle.message("fix.change.feature.support.family", objectArray);
    }

    @NotNull
    public String getText() {
        return Companion.getFixText(this.featureSupport, this.featureShortName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix$Companion;", "", "<init>", "()V", "getFixText", "", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "featureShortName", "kotlin.inspections"})
    public static final class Companion {
        private Companion() {
        }

        @Nls
        @NotNull
        public final String getFixText(@NotNull LanguageFeature.State state, @NotNull String featureShortName) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)featureShortName, (String)"featureShortName");
            return switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1 -> {
                    Object[] var3_3 = new Object[]{featureShortName};
                    yield KotlinInspectionsBundle.message("fix.change.feature.support.enabled", var3_3);
                }
                case 2 -> {
                    Object[] var3_4 = new Object[]{featureShortName};
                    yield KotlinInspectionsBundle.message("fix.change.feature.support.enabled.warning", var3_4);
                }
                case 3 -> {
                    Object[] var3_5 = new Object[]{featureShortName};
                    yield KotlinInspectionsBundle.message("fix.change.feature.support.disabled", var3_5);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LanguageFeature.State.values().length];
                try {
                    nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LanguageFeature.State.DISABLED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix$FeatureSupportIntentionActionsFactory;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixFactory;", "shouldConfigureInProject", "", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.inspections"})
    public static interface FeatureSupportIntentionActionsFactory
    extends QuickFixFactory {
        default public boolean shouldConfigureInProject(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Object object = KotlinFacet.Companion.get(module);
            IKotlinFacetSettings facetSettings = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null ? object.getSettings() : null;
            return (facetSettings == null || facetSettings.getUseProjectSettings()) && BuildSystemTypeKt.getBuildSystemType(module) == BuildSystemType.JPS;
        }
    }
}

