/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.ConvertToIsArrayOfCallFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertToIsArrayOfCallFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class ConvertToIsArrayOfCallFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final ConvertToIsArrayOfCallFixFactory INSTANCE = new ConvertToIsArrayOfCallFixFactory();

    private ConvertToIsArrayOfCallFixFactory() {
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticWithParameters1 casted = (DiagnosticWithParameters1)Errors.CANNOT_CHECK_FOR_ERASED.cast((UnboundDiagnostic)diagnostic);
        PsiElement psiElement = casted.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"<get-psiElement>(...)");
        KtElement element = (KtElement)psiElement;
        if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform(element))) {
            return null;
        }
        PsiElement psiElement2 = element.getParent();
        KtIsExpression ktIsExpression = psiElement2 instanceof KtIsExpression ? (KtIsExpression)psiElement2 : null;
        if (ktIsExpression == null) {
            return null;
        }
        KtIsExpression parentIsExpression = ktIsExpression;
        Object object = casted.getA();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
        KotlinType type2 = (KotlinType)object;
        if (!SimpleClassicTypeSystemContext.INSTANCE.isArrayOrNullableArray((KotlinTypeMarker)type2)) {
            return null;
        }
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)type2.getArguments());
        if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
            return null;
        }
        TypeProjection arrayArgumentType = typeProjection;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)parentIsExpression, BodyResolveMode.PARTIAL);
        KtExpression ktExpression = parentIsExpression.getLeftHandSide();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"getLeftHandSide(...)");
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType lhsType = kotlinType;
        boolean lhsIsNullable = KotlinTypeKt.isNullable((KotlinType)lhsType);
        boolean lhsIsArray = SimpleClassicTypeSystemContext.INSTANCE.isArrayOrNullableArray((KotlinTypeMarker)lhsType);
        String arrayArgumentTypeText = IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType((KotlinType)arrayArgumentType);
        return new ConvertToIsArrayOfCallFix(parentIsExpression, lhsIsNullable, lhsIsArray, arrayArgumentTypeText).asIntention();
    }
}

