/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction;", "Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Handler", "kotlin.jvm"})
public final class RunScratchAction
extends ScratchAction {
    public RunScratchAction() {
        block0: {
            String string = KotlinJvmBundle.message("scratch.run.button", new Object[0]);
            Icon icon2 = AllIcons.Actions.Execute;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Execute");
            super(string, icon2);
            Shortcut[] shortcutArray = KeymapManager.getInstance().getActiveKeymap().getShortcuts("Kotlin.RunScratch");
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Shortcut shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])shortcutArray);
            if (shortcut == null) break block0;
            Shortcut it = shortcut;
            boolean bl = false;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(presentation.getText() + " (" + KeymapUtil.getShortcutText((Shortcut)it) + ")");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ScratchFile scratchFile = this.getCurrentScratchFile(e);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        Handler.INSTANCE.doAction(scratchFile2, false);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabled(!ScratchCompilationSupport.INSTANCE.isAnyInProgress());
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
        } else {
            e.getPresentation().setText(KotlinJvmBundle.message("other.scratch.file.execution.is.in.progress", new Object[0]));
        }
        ScratchFile scratchFile = this.getCurrentScratchFile(e);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        e.getPresentation().setVisible(!ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile2));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction$Handler;", "", "<init>", "()V", "doAction", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "isAutoRun", "", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nRunScratchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunScratchAction.kt\norg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction$Handler\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,103:1\n122#2:104\n*S KotlinDebug\n*F\n+ 1 RunScratchAction.kt\norg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction$Handler\n*L\n61#1:104\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final void doAction(@NotNull ScratchFile scratchFile, boolean isAutoRun) {
            Intrinsics.checkNotNullParameter((Object)scratchFile, (String)"scratchFile");
            Project project = scratchFile.getProject();
            boolean isRepl = scratchFile.getOptions().isRepl();
            ScratchExecutor scratchExecutor = isRepl ? (ScratchExecutor)scratchFile.getReplScratchExecutor() : scratchFile.getCompilingScratchExecutor();
            if (scratchExecutor == null) {
                return;
            }
            ScratchExecutor executor = scratchExecutor;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isRepl = " + isRepl);
            boolean isMakeBeforeRun = scratchFile.getOptions().isMakeBeforeRun();
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isMakeBeforeRun = " + isMakeBeforeRun);
            ScriptConfigurationManager $this$cast$iv = ScriptConfigurationManager.Companion.getInstance(project);
            boolean $i$f$cast = false;
            ScriptConfigurationManager scriptConfigurationManager = $this$cast$iv;
            if (scriptConfigurationManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager");
            }
            ((CompositeScriptConfigurationManager)scriptConfigurationManager).updateScriptDependenciesIfNeeded(scratchFile.getFile());
            Module module = scratchFile.getModule();
            Module module2 = module;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: module = " + (module2 != null ? module2.getName() : null));
            if (!isAutoRun && module != null && isMakeBeforeRun) {
                ProjectTaskManagerImpl.putBuildOriginator((Project)project, this.getClass());
                Module[] moduleArray = new Module[]{module};
                Promise promise = ProjectTaskManager.getInstance((Project)project).build(moduleArray).onSuccess(arg_0 -> Handler.doAction$lambda$2(arg_0 -> Handler.doAction$lambda$1(executor, module, project, isAutoRun, arg_0), arg_0));
                Intrinsics.checkNotNull((Object)promise);
            } else {
                Handler.doAction$executeScratch(isAutoRun, executor);
            }
        }

        private static final void doAction$executeScratch(boolean $isAutoRun, ScratchExecutor executor) {
            try {
                if ($isAutoRun && executor instanceof SequentialScratchExecutor) {
                    ((SequentialScratchExecutor)executor).executeNew();
                } else {
                    executor.execute();
                }
            }
            catch (Throwable ex) {
                executor.errorOccurs(KotlinJvmBundle.message("exception.occurs.during.run.scratch.action", new Object[0]), ex, true);
            }
        }

        private static final void doAction$lambda$1$lambda$0(boolean $isAutoRun, ScratchExecutor $executor) {
            Handler.doAction$executeScratch($isAutoRun, $executor);
        }

        private static final Unit doAction$lambda$1(ScratchExecutor $executor, Module $module, Project $project, boolean $isAutoRun, ProjectTaskManager.Result executionResult) {
            if (executionResult.isAborted() || executionResult.hasErrors()) {
                Object[] objectArray = new Object[]{$module.getName()};
                ScratchExecutor.errorOccurs$default($executor, KotlinJvmBundle.message("there.were.compilation.errors.in.module.0", objectArray), null, false, 6, null);
            }
            if (DumbService.Companion.isDumb($project)) {
                DumbService.Companion.getInstance($project).smartInvokeLater(() -> Handler.doAction$lambda$1$lambda$0($isAutoRun, $executor));
            } else {
                Handler.doAction$executeScratch($isAutoRun, $executor);
            }
            return Unit.INSTANCE;
        }

        private static final void doAction$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

