/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.declarationsSearch;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearch;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchyTraverser;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.PsiMethodOverridingHierarchyTraverser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0014J&\u0010\f\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/search/declarationsSearch/KotlinPsiMethodOverridersSearch;", "Lorg/jetbrains/kotlin/idea/search/declarationsSearch/HierarchySearch;", "Lcom/intellij/psi/PsiMethod;", "<init>", "()V", "searchDirectOverriders", "", "psiMethod", "isApplicable", "", "request", "Lorg/jetbrains/kotlin/idea/search/declarationsSearch/HierarchySearchRequest;", "doSearchDirect", "", "consumer", "Lcom/intellij/util/Processor;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\noverridersSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 overridersSearch.kt\norg/jetbrains/kotlin/idea/search/declarationsSearch/KotlinPsiMethodOverridersSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1863#2,2:148\n*S KotlinDebug\n*F\n+ 1 overridersSearch.kt\norg/jetbrains/kotlin/idea/search/declarationsSearch/KotlinPsiMethodOverridersSearch\n*L\n89#1:148,2\n*E\n"})
public final class KotlinPsiMethodOverridersSearch
extends HierarchySearch<PsiMethod> {
    @NotNull
    public static final KotlinPsiMethodOverridersSearch INSTANCE = new KotlinPsiMethodOverridersSearch();

    private KotlinPsiMethodOverridersSearch() {
        super(PsiMethodOverridingHierarchyTraverser.INSTANCE);
    }

    @NotNull
    public final Iterable<PsiMethod> searchDirectOverriders(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
            return list2;
        }
        PsiClass psiClass2 = psiClass;
        LinkedHashMap<PsiClass, PsiMethod> classToMethod = new LinkedHashMap<PsiClass, PsiMethod>();
        HierarchyTraverser<PsiClass> classTraverser2 = new HierarchyTraverser<PsiClass>(classToMethod){
            final /* synthetic */ LinkedHashMap<PsiClass, PsiMethod> $classToMethod;
            {
                this.$classToMethod = $classToMethod;
            }

            public Iterable<PsiClass> nextElements(PsiClass current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                Project project = current.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Query query = DirectClassInheritorsSearch.search((PsiClass)current, (SearchScope)((SearchScope)KotlinScopeUtils.allScope(project)), (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                return (Iterable)query;
            }

            public boolean shouldDescend(PsiClass element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return ClassInheritorsSearchKt.isInheritable(element) && !this.$classToMethod.containsKey(element);
            }
        };
        classTraverser2.forEach(psiClass2, arg_0 -> KotlinPsiMethodOverridersSearch.searchDirectOverriders$lambda$0(psiClass2, psiMethod, classToMethod, arg_0));
        Collection<PsiMethod> collection = classToMethod.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @Override
    protected boolean isApplicable(@NotNull HierarchySearchRequest<PsiMethod> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        return (Boolean)ActionsKt.runReadAction(() -> KotlinPsiMethodOverridersSearch.isApplicable$lambda$1(request));
    }

    @Override
    protected void doSearchDirect(@NotNull HierarchySearchRequest<PsiMethod> request, @NotNull Processor<? super PsiMethod> consumer) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable<PsiMethod> $this$forEach$iv = this.searchDirectOverriders(request.getOriginalElement());
        boolean $i$f$forEach = false;
        Iterator<PsiMethod> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            PsiMethod element$iv;
            PsiMethod method = element$iv = iterator2.next();
            boolean bl = false;
            consumer.process((Object)method);
        }
    }

    private static final boolean searchDirectOverriders$isAcceptable(PsiMethod $this$searchDirectOverriders_u24isAcceptable, PsiClass inheritor, PsiMethod baseMethod, PsiClass baseClass) {
        return $this$searchDirectOverriders_u24isAcceptable.hasModifierProperty("static") ? false : (baseMethod.hasModifierProperty("packageLocal") ? JavaPsiFacade.getInstance((Project)$this$searchDirectOverriders_u24isAcceptable.getProject()).arePackagesTheSame((PsiElement)baseClass, (PsiElement)inheritor) : true);
    }

    private static final Unit searchDirectOverriders$lambda$0(PsiClass $psiClass, PsiMethod $psiMethod, LinkedHashMap $classToMethod, PsiClass inheritor) {
        Intrinsics.checkNotNullParameter((Object)inheritor, (String)"inheritor");
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)$psiClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSuperClassSubstitutor(...)");
        PsiSubstitutor substitutor2 = psiSubstitutor;
        MethodSignature methodSignature = $psiMethod.getSignature(substitutor2);
        Intrinsics.checkNotNullExpressionValue((Object)methodSignature, (String)"getSignature(...)");
        MethodSignature signature = methodSignature;
        PsiMethod candidate = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)signature, (boolean)false);
        if (candidate != null && KotlinPsiMethodOverridersSearch.searchDirectOverriders$isAcceptable(candidate, inheritor, $psiMethod, $psiClass)) {
            ((Map)$classToMethod).put(inheritor, candidate);
        }
        return Unit.INSTANCE;
    }

    private static final boolean isApplicable$lambda$1(HierarchySearchRequest $request) {
        return OverridersSearchKt.isOverridableElement($request.getOriginalElement());
    }
}

