/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/j2k/IdeaReferenceSearcher;", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "<init>", "()V", "findLocalUsages", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "scope", "hasInheritors", "", "class", "Lcom/intellij/psi/PsiClass;", "hasOverrides", "method", "Lcom/intellij/psi/PsiMethod;", "findUsagesForExternalCodeProcessing", "searchJava", "searchKotlin", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nReferenceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceSearcher.kt\norg/jetbrains/kotlin/j2k/IdeaReferenceSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n1#2:47\n37#3,2:48\n*S KotlinDebug\n*F\n+ 1 ReferenceSearcher.kt\norg/jetbrains/kotlin/j2k/IdeaReferenceSearcher\n*L\n42#1:48,2\n*E\n"})
public final class IdeaReferenceSearcher
implements ReferenceSearcher {
    @NotNull
    public static final IdeaReferenceSearcher INSTANCE = new IdeaReferenceSearcher();

    private IdeaReferenceSearcher() {
    }

    @Override
    @NotNull
    public Collection<PsiReference> findLocalUsages(@NotNull PsiElement element, @NotNull PsiElement scope) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)((SearchScope)new LocalSearchScope(scope))).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        return collection;
    }

    @Override
    public boolean hasInheritors(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"class");
        Query query = ClassInheritorsSearch.search((PsiClass)psiClass, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        return CollectionsKt.any((Iterable)((Iterable)query));
    }

    @Override
    public boolean hasOverrides(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Query query = OverridingMethodsSearch.search((PsiMethod)method, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        return CollectionsKt.any((Iterable)((Iterable)query));
    }

    @Override
    @NotNull
    public Collection<PsiReference> findUsagesForExternalCodeProcessing(@NotNull PsiElement element, boolean searchJava, boolean searchKotlin) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] it = objectArray = JavaLanguage.INSTANCE.getAssociatedFileType();
        boolean bl = false;
        Object[] javaFileType = searchJava ? objectArray : null;
        Object[] it2 = it = KotlinLanguage.INSTANCE.getAssociatedFileType();
        boolean bl2 = false;
        Object[] kotlinFileType = searchKotlin ? it : null;
        it2 = new LanguageFileType[]{javaFileType, kotlinFileType};
        List fileTypes = CollectionsKt.listOfNotNull((Object[])it2);
        Collection $this$toTypedArray$iv = fileTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LanguageFileType[] languageFileTypeArray = thisCollection$iv.toArray(new LanguageFileType[0]);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), (FileType[])((FileType[])Arrays.copyOf(languageFileTypeArray, languageFileTypeArray.length)));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)((SearchScope)searchScope)).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        return collection;
    }
}

