/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.CodeBuilderKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.LBrace;
import org.jetbrains.kotlin.j2k.ast.RBrace;
import org.jetbrains.kotlin.j2k.ast.Statement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/Block;", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "statements", "", "lBrace", "Lorg/jetbrains/kotlin/j2k/ast/LBrace;", "rBrace", "Lorg/jetbrains/kotlin/j2k/ast/RBrace;", "notEmpty", "", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/j2k/ast/LBrace;Lorg/jetbrains/kotlin/j2k/ast/RBrace;Z)V", "getStatements", "()Ljava/util/List;", "getLBrace", "()Lorg/jetbrains/kotlin/j2k/ast/LBrace;", "getRBrace", "()Lorg/jetbrains/kotlin/j2k/ast/RBrace;", "getNotEmpty", "()Z", "isEmpty", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "Companion", "kotlin.j2k.k1.old"})
@SourceDebugExtension(value={"SMAP\nBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Block.kt\norg/jetbrains/kotlin/j2k/ast/Block\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1734#2,3:42\n1734#2,3:45\n*S KotlinDebug\n*F\n+ 1 Block.kt\norg/jetbrains/kotlin/j2k/ast/Block\n*L\n10#1:42,3\n13#1:45,3\n*E\n"})
public final class Block
extends Statement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Statement> statements;
    @NotNull
    private final LBrace lBrace;
    @NotNull
    private final RBrace rBrace;
    private final boolean notEmpty;
    @NotNull
    private static final Block Empty = new Block(CollectionsKt.emptyList(), new LBrace(), new RBrace(), false, 8, null);

    public Block(@NotNull List<? extends Statement> statements2, @NotNull LBrace lBrace, @NotNull RBrace rBrace, boolean notEmpty) {
        Intrinsics.checkNotNullParameter(statements2, (String)"statements");
        Intrinsics.checkNotNullParameter((Object)lBrace, (String)"lBrace");
        Intrinsics.checkNotNullParameter((Object)rBrace, (String)"rBrace");
        this.statements = statements2;
        this.lBrace = lBrace;
        this.rBrace = rBrace;
        this.notEmpty = notEmpty;
    }

    public /* synthetic */ Block(List list2, LBrace lBrace, RBrace rBrace, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list2, lBrace, rBrace, bl);
    }

    @NotNull
    public final List<Statement> getStatements() {
        return this.statements;
    }

    @NotNull
    public final LBrace getLBrace() {
        return this.lBrace;
    }

    @NotNull
    public final RBrace getRBrace() {
        return this.rBrace;
    }

    public final boolean getNotEmpty() {
        return this.notEmpty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        Statement it;
        if (this.notEmpty) return false;
        Iterable $this$all$iv = this.statements;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (Statement)element$iv;
            boolean bl = false;
        } while (it.isEmpty());
        return false;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Iterable $this$all$iv = this.statements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Statement it = (Statement)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            if (!this.isEmpty()) {
                builder2.append(this.lBrace).append(this.rBrace);
            }
            return;
        }
        CodeBuilderKt.appendElements(builder2.append(this.lBrace), (Collection<? extends Element>)this.statements, "\n", "\n", "\n").append(this.rBrace);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\b\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/Block$Companion;", "", "<init>", "()V", "Empty", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "getEmpty", "()Lorg/jetbrains/kotlin/j2k/ast/Block;", "of", "statement", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "statements", "", "kotlin.j2k.k1.old"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Block getEmpty() {
            return Empty;
        }

        @NotNull
        public final Block of(@NotNull Statement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            return this.of(CollectionsKt.listOf((Object)statement));
        }

        @NotNull
        public final Block of(@NotNull List<? extends Statement> statements2) {
            Intrinsics.checkNotNullParameter(statements2, (String)"statements");
            return new Block(statements2, (LBrace)ElementKt.assignNoPrototype((Element)new LBrace()), (RBrace)ElementKt.assignNoPrototype((Element)new RBrace()), true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

