/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.compatibility;

import com.intellij.openapi.module.Module;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinLibraryVersionProvider;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinLibrariesCompatibilityStore;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/DefaultKotlinLibraryVersionProvider;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinLibraryVersionProvider;", "<init>", "()V", "getVersion", "", "module", "Lcom/intellij/openapi/module/Module;", "groupId", "artifactId", "kotlin.project-wizard.core"})
public final class DefaultKotlinLibraryVersionProvider
implements KotlinLibraryVersionProvider {
    @Override
    @Nullable
    public String getVersion(@NotNull Module module, @NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        KotlinVersion projectKotlinVersion = LanguageVersionSettingsKt.toKotlinVersion((LanguageVersion)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(module).getLanguageVersion());
        Map map = KotlinLibrariesCompatibilityStore.Companion.getInstance().getVersions(groupId, artifactId);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map versions = map;
        String kotlinShortVersion = projectKotlinVersion.getMajor() + "." + projectKotlinVersion.getMinor();
        return (String)versions.get(kotlinShortVersion);
    }
}

