/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.templates;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizardBundle;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.ListBuilder;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.ModuleIR;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.ConfiguratorsKt;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.ModuleConfiguratorWithTestsKt;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.MppModuleConfigurator;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.WasmTargetConfigurator;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ModuleType;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Module;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.SourcesetType;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptorKt;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptorWithPath;
import org.jetbrains.kotlin.tools.projectWizard.templates.JsClientTemplate;
import org.jetbrains.kotlin.tools.projectWizard.templates.TemplateEnvironment;
import org.jetbrains.kotlin.tools.projectWizard.templates.TemplateKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n0\u0018R\u00020\u0019j\u0002`\u001aH\u0016J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e*\n0\u0018R\u00020\u0019j\u0002`\u001a2\u0006\u0010\u0013\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\u00020\u00058\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/templates/SimpleWasmClientTemplate;", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/JsClientTemplate;", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "description", "getDescription", "id", "getId", "clientFileToCreate", "filesToOpenInEditor", "", "getFilesToOpenInEditor", "()Ljava/util/List;", "isApplicableTo", "", "module", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/buildsystem/Module;", "projectKind", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ProjectKind;", "reader", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "getFileTemplates", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileTemplateDescriptorWithPath;", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/ModuleIR;", "indexTitleName", "kotlin.project-wizard.core"})
public final class SimpleWasmClientTemplate
extends JsClientTemplate {
    @NotNull
    public static final SimpleWasmClientTemplate INSTANCE = new SimpleWasmClientTemplate();
    @NotNull
    private static final String title = KotlinNewProjectWizardBundle.message("module.template.wasm.browser.title", new Object[0]);
    @NotNull
    private static final String description = KotlinNewProjectWizardBundle.message("module.template.wasm.browser.description", new Object[0]);
    @NonNls
    @NotNull
    private static final String id = "simpleWasmClient";
    @NotNull
    private static final String clientFileToCreate = "Simple.kt";
    @NotNull
    private static final List<String> filesToOpenInEditor = CollectionsKt.listOf((Object)"Simple.kt");

    private SimpleWasmClientTemplate() {
    }

    @Override
    @NotNull
    public String getTitle() {
        return title;
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    @NotNull
    public String getId() {
        return id;
    }

    @Override
    @NotNull
    public List<String> getFilesToOpenInEditor() {
        return filesToOpenInEditor;
    }

    @Override
    public boolean isApplicableTo(@NotNull Module module, @NotNull ProjectKind projectKind, @NotNull Context.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return ConfiguratorsKt.getModuleType(module.getConfigurator()) == ModuleType.wasm && Intrinsics.areEqual((Object)module.getConfigurator(), (Object)WasmTargetConfigurator.INSTANCE);
    }

    @Override
    @NotNull
    public List<FileTemplateDescriptorWithPath> getFileTemplates(@NotNull Context.Reader $this$getFileTemplates, @NotNull ModuleIR module) {
        Intrinsics.checkNotNullParameter((Object)$this$getFileTemplates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (List)TemplateKt.withSettingsOf$default(module.getOriginalModule(), null, arg_0 -> SimpleWasmClientTemplate.getFileTemplates$lambda$1(module, $this$getFileTemplates, arg_0), 2, null);
    }

    @Override
    @NotNull
    protected String indexTitleName() {
        return "Kotlin/Wasm";
    }

    private static final Unit getFileTemplates$lambda$1$lambda$0(ModuleIR $module, Context.Reader $this_getFileTemplates, ListBuilder $this$buildList) {
        Intrinsics.checkNotNullParameter((Object)$this$buildList, (String)"$this$buildList");
        boolean hasKtorServNeighbourTarget = INSTANCE.hasKtorServNeighbourTarget($module);
        if (!hasKtorServNeighbourTarget) {
            $this$buildList.unaryPlus(FileTemplateDescriptorKt.asResourceOf(new FileTemplateDescriptor("jsClient/index.html.vm"), SourcesetType.main));
        }
        $this$buildList.unaryPlus(FileTemplateDescriptorKt.asSrcOf(new FileTemplateDescriptor(INSTANCE.getId() + "/simple.kt.vm", UtilsKt.asPath(clientFileToCreate)), SourcesetType.main));
        if (ModuleConfiguratorWithTestsKt.isPresent(MppModuleConfigurator.INSTANCE.getTestFramework($this_getFileTemplates, $module.getOriginalModule()))) {
            $this$buildList.unaryPlus(FileTemplateDescriptorKt.asSrcOf(new FileTemplateDescriptor(INSTANCE.getId() + "/SimpleTest.kt.vm", UtilsKt.asPath("SimpleTest.kt")), SourcesetType.test));
        }
        return Unit.INSTANCE;
    }

    private static final List getFileTemplates$lambda$1(ModuleIR $module, Context.Reader $this_getFileTemplates, TemplateEnvironment $this$withSettingsOf) {
        Intrinsics.checkNotNullParameter((Object)$this$withSettingsOf, (String)"$this$withSettingsOf");
        return UtilsKt.buildList(arg_0 -> SimpleWasmClientTemplate.getFileTemplates$lambda$1$lambda$0($module, $this_getFileTemplates, arg_0));
    }
}

