/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.actions.GitSingleCommitActionGroup;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitRebaseOntoCommitAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitLogBranchOperationsActionGroup
extends GitSingleCommitActionGroup {
    private static final int MAX_BRANCH_GROUPS = 2;
    private static final int MAX_TAG_GROUPS = 1;

    public GitLogBranchOperationsActionGroup() {
        this.setPopup(false);
    }

    @Override
    public AnAction @NotNull [] getChildren(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository root, @NotNull CommitId commit) {
        if (e == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(1);
        }
        if (root == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(2);
        }
        if (commit == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(3);
        }
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        List refs = (List)e.getData(VcsLogDataKeys.VCS_LOG_REFS);
        if (logUI == null || refs == null) {
            if (EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        List branchRefs = ContainerUtil.filter((Collection)refs, ref -> {
            if (ref.getType() == GitRefManager.LOCAL_BRANCH) {
                return !ref.getName().equals(root.getCurrentBranchName());
            }
            return ref.getType() == GitRefManager.REMOTE_BRANCH;
        });
        List tagRefs = ContainerUtil.filter((Collection)refs, ref -> ref.getType() == GitRefManager.TAG);
        VcsLogProvider provider = (VcsLogProvider)logUI.getDataPack().getLogProviders().get(root.getRoot());
        if (provider != null) {
            VcsLogRefManager refManager = provider.getReferenceManager();
            Comparator comparator = refManager.getLabelsOrderComparator();
            branchRefs = ContainerUtil.sorted((Collection)branchRefs, (Comparator)comparator);
            tagRefs = ContainerUtil.sorted((Collection)tagRefs, (Comparator)comparator);
        }
        ArrayList<Object> groups = new ArrayList<Object>();
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        List<GitRepository> allRepositories = repositoryManager.getRepositories();
        if (!branchRefs.isEmpty()) {
            GitVcsSettings settings = GitVcsSettings.getInstance(project);
            boolean showBranchesPopup = branchRefs.size() > 2;
            HashSet<GitBranch> commonBranches = new HashSet<GitBranch>();
            commonBranches.addAll(GitBranchUtil.getCommonLocalBranches(allRepositories));
            commonBranches.addAll(GitBranchUtil.getCommonRemoteBranches(allRepositories));
            ArrayList branchActionGroups = new ArrayList();
            for (VcsRef ref2 : branchRefs) {
                AnAction group = GitLogBranchOperationsActionGroup.createBranchGroup(project, ref2, root, allRepositories, (Set<GitBranch>)commonBranches, settings, showBranchesPopup);
                ContainerUtil.addIfNotNull(branchActionGroups, (Object)group);
            }
            DefaultActionGroup branchesGroup = new DefaultActionGroup(GitBundle.message("branches.branches", new Object[0]), branchActionGroups);
            branchesGroup.setPopup(showBranchesPopup);
            groups.add(branchesGroup);
        } else {
            GitRebaseOntoCommitAction rebaseOntoCommitAction = new GitRebaseOntoCommitAction(project, root, commit);
            groups.add((Object)rebaseOntoCommitAction);
        }
        if (!tagRefs.isEmpty()) {
            boolean showTagsPopup = tagRefs.size() > 1;
            ArrayList<AnAction> tagActionGroups = new ArrayList<AnAction>();
            for (VcsRef ref3 : tagRefs) {
                tagActionGroups.add(GitLogBranchOperationsActionGroup.createTagGroup(project, ref3, root, showTagsPopup));
            }
            DefaultActionGroup tagsGroup = new DefaultActionGroup(GitBundle.message("branches.tags", new Object[0]), tagActionGroups);
            tagsGroup.setPopup(showTagsPopup);
            groups.add(tagsGroup);
        }
        AnAction[] anActionArray = groups.toArray(EMPTY_ARRAY);
        if (anActionArray == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    @Nullable
    private static AnAction createBranchGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, @NotNull List<? extends GitRepository> allRepositories, @NotNull Set<GitBranch> commonBranches, @NotNull GitVcsSettings settings, boolean showBranchesPopup) {
        ActionGroup singleRepoActions;
        ActionGroup allReposActions;
        boolean isSyncBranch;
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(6);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(8);
        }
        if (allRepositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(9);
        }
        if (commonBranches == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(11);
        }
        GitBranch branch = ref.getType() == GitRefManager.LOCAL_BRANCH ? new GitLocalBranch(ref.getName()) : GitUtil.parseRemoteBranch(ref.getName(), repository.getRemotes());
        ArrayList<Object> actions2 = new ArrayList<Object>(3);
        boolean bl = isSyncBranch = settings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC && allRepositories.size() > 1 && commonBranches.contains(branch);
        if (isSyncBranch && (allReposActions = GitLogBranchOperationsActionGroup.createBranchActions(project, allRepositories, branch, repository)) != null) {
            allReposActions.getTemplatePresentation().setText(GitBundle.message("in.branches.all.repositories", new Object[0]));
            allReposActions.setPopup(true);
            actions2.add(allReposActions);
            actions2.add(Separator.getInstance());
        }
        if ((singleRepoActions = GitLogBranchOperationsActionGroup.createBranchActions(project, Collections.singletonList(repository), branch, repository)) == null) {
            return null;
        }
        singleRepoActions.setPopup(false);
        actions2.add(singleRepoActions);
        String text2 = showBranchesPopup ? ref.getName() : GitBundle.message("branches.branch.0", ref.getName());
        DefaultActionGroup group = new DefaultActionGroup(actions2);
        group.getTemplatePresentation().setText(text2, false);
        group.setPopup(true);
        return group;
    }

    @NotNull
    private static AnAction createTagGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, boolean showTagsPopup) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(12);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(13);
        }
        if (repository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(14);
        }
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createTagActions(project, Collections.singletonList(repository), ref);
        singleRepoActions.setPopup(false);
        String text2 = showTagsPopup ? ref.getName() : GitBundle.message("branches.tag.0", ref.getName());
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{singleRepoActions});
        group.getTemplatePresentation().setText(text2, false);
        group.setPopup(true);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(15);
        }
        return defaultActionGroup;
    }

    @Nullable
    private static ActionGroup createBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch, @NotNull GitRepository selectedRepository) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(16);
        }
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(17);
        }
        if (branch == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(18);
        }
        if (selectedRepository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(19);
        }
        if (branch instanceof GitLocalBranch) {
            for (GitRepository gitRepository : repositories) {
                if (gitRepository.getBranches().getLocalBranches().contains(branch)) continue;
                return null;
            }
            return new GitBranchPopupActions.LocalBranchActions(project, repositories, (GitLocalBranch)branch, selectedRepository);
        }
        if (branch instanceof GitRemoteBranch) {
            for (GitRepository gitRepository : repositories) {
                if (gitRepository.getBranches().getRemoteBranches().contains(branch)) continue;
                return null;
            }
            return new GitBranchPopupActions.RemoteBranchActions(project, repositories, (GitRemoteBranch)branch, selectedRepository);
        }
        return null;
    }

    @NotNull
    private static ActionGroup createTagActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull VcsRef ref) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(20);
        }
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(21);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(22);
        }
        return new GitBranchPopupActions.TagActions(project, repositories, ref.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 4: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 7: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositories";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonBranches";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBranchGroup";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTagGroup";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createBranchActions";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createTagActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 15 -> new IllegalStateException(string);
        };
    }
}

