/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.util.PathUtilRt;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;

@ApiStatus.Internal
public final class BuildDataPathsImpl
implements BuildDataPaths {
    private final File myDataStorageRoot;

    public BuildDataPathsImpl(@NotNull File dataStorageRoot) {
        if (dataStorageRoot == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(0);
        }
        this.myDataStorageRoot = dataStorageRoot;
    }

    @Override
    @NotNull
    public File getDataStorageRoot() {
        File file = this.myDataStorageRoot;
        if (file == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Override
    @NotNull
    public File getTargetsDataRoot() {
        return new File(this.myDataStorageRoot, "targets");
    }

    @Override
    @NotNull
    public File getTargetTypeDataRoot(@NotNull BuildTargetType<?> targetType) {
        if (targetType == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(2);
        }
        return new File(this.getTargetsDataRoot(), targetType.getTypeId());
    }

    @NotNull
    public Path getTargetTypeDataRootDir(@NotNull BuildTargetType<?> targetType) {
        if (targetType == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(3);
        }
        Path path = this.getTargetsDataRoot().toPath().resolve(targetType.getTypeId());
        if (path == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(4);
        }
        return path;
    }

    @Override
    @NotNull
    public File getTargetDataRoot(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(5);
        }
        File file = this.getTargetDataRootDir(target).toFile();
        if (file == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(6);
        }
        return file;
    }

    @Override
    @NotNull
    public Path getTargetDataRootDir(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(7);
        }
        Path path = this.getTargetDataRoot(target.getTargetType(), target.getId());
        if (path == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(8);
        }
        return path;
    }

    @Override
    @NotNull
    public Path getTargetDataRoot(@NotNull BuildTargetType<?> targetType, @NotNull String targetId) {
        if (targetType == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(9);
        }
        if (targetId == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(10);
        }
        Path path = this.getTargetTypeDataRootDir(targetType).resolve(BuildDataPathsImpl.targetIdToFilename(targetId));
        if (path == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(11);
        }
        return path;
    }

    @NotNull
    private static String targetIdToFilename(@NotNull String targetId) {
        if (targetId == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(12);
        }
        String string = PathUtilRt.suggestFileName((String)targetId, (boolean)true, (boolean)false) + "_" + Integer.toHexString(targetId.hashCode());
        if (string == null) {
            BuildDataPathsImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/impl/BuildDataPathsImpl";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/impl/BuildDataPathsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataStorageRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetTypeDataRootDir";
                break;
            }
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataRootDir";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "targetIdToFilename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeDataRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeDataRootDir";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDataRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDataRootDir";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "targetIdToFilename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

