/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.MapHandle;
import org.jetbrains.jps.incremental.storage.OneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B3\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006H\u0004J\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u0006J-\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0004\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0006R\"\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "Lorg/jetbrains/jps/incremental/storage/OneToManyPathMapping;", "mapHandle", "Lorg/jetbrains/jps/incremental/storage/MapHandle;", "", "", "", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "valueOffset", "", "<init>", "(Lorg/jetbrains/jps/incremental/storage/MapHandle;Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;I)V", "getKey", "path", "getOutputs", "", "normalizeOutputPaths", "outPaths", "relativeSourcePath", "(Ljava/util/List;Ljava/lang/String;)[Ljava/lang/String;", "setOutputs", "", "remove", "intellij.platform.jps.build"})
@ApiStatus.Internal
public class ExperimentalOneToManyPathMapping
implements OneToManyPathMapping {
    @JvmField
    @NotNull
    protected final MapHandle<long[], String[]> mapHandle;
    @JvmField
    @NotNull
    public final PathRelativizerService relativizer;
    private final int valueOffset;

    public ExperimentalOneToManyPathMapping(@NotNull MapHandle<long[], String[]> mapHandle, @NotNull PathRelativizerService relativizer, int valueOffset) {
        Intrinsics.checkNotNullParameter(mapHandle, (String)"mapHandle");
        Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
        this.mapHandle = mapHandle;
        this.relativizer = relativizer;
        this.valueOffset = valueOffset;
    }

    public /* synthetic */ ExperimentalOneToManyPathMapping(MapHandle mapHandle, PathRelativizerService pathRelativizerService, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(mapHandle, pathRelativizerService, n);
    }

    @NotNull
    protected final long[] getKey(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = this.relativizer.toRelative(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
        return LongPairKeyDataTypeKt.stringTo128BitHash(string);
    }

    @Nullable
    public final List<String> getOutputs(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long[] key = this.getKey(path);
        String[] stringArray = (String[])this.mapHandle.map.get((Object)key);
        if (stringArray == null) {
            return null;
        }
        String[] list = stringArray;
        int n = 0;
        int n2 = list.length - this.valueOffset;
        Object[] objectArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            Intrinsics.checkNotNullExpressionValue((Object)this.relativizer.toFull(list[n3 + this.valueOffset]), (String)"toFull(...)");
        }
        return ArraysKt.asList((Object[])objectArray);
    }

    @Nullable
    protected final String[] normalizeOutputPaths(@NotNull List<String> outPaths, @Nullable String relativeSourcePath) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter(outPaths, (String)"outPaths");
        if (outPaths.isEmpty()) {
            stringArray = null;
        } else if (relativeSourcePath != null) {
            int n = outPaths.size() + 1;
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                String string;
                int n2 = i;
                if (n2 == 0) {
                    string = relativeSourcePath;
                } else {
                    String string2 = this.relativizer.toRelative(outPaths.get(n2 - 1));
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toRelative(...)");
                }
                stringArray2[n2] = string;
            }
            stringArray = stringArray2;
        } else {
            int n = 0;
            int n3 = outPaths.size();
            String[] stringArray3 = new String[n3];
            while (n < n3) {
                int n4 = n++;
                Intrinsics.checkNotNullExpressionValue((Object)this.relativizer.toRelative(outPaths.get(n4)), (String)"toRelative(...)");
            }
            stringArray = stringArray3;
        }
        return stringArray;
    }

    @Override
    public void setOutputs(@NotNull String path, @NotNull List<String> outPaths) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(outPaths, (String)"outPaths");
        String string = this.relativizer.toRelative(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
        String relativeSourcePath = string;
        long[] key = LongPairKeyDataTypeKt.stringTo128BitHash(relativeSourcePath);
        String[] normalizeOutputPaths = this.normalizeOutputPaths(outPaths, null);
        String[] stringArray = normalizeOutputPaths == null ? (String[])this.mapHandle.map.remove((Object)key) : (String[])this.mapHandle.map.put((Object)key, (Object)normalizeOutputPaths);
    }

    @Override
    public final void remove(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.mapHandle.map.remove((Object)this.getKey(path));
    }
}

