/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.LongStorageValueType;
import org.jetbrains.jps.incremental.storage.MapHandle;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataType;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B%\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J/\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalTimeStampStorage;", "Lorg/jetbrains/jps/incremental/storage/StampsStorage;", "", "mapHandle", "Lorg/jetbrains/jps/incremental/storage/MapHandle;", "", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "<init>", "(Lorg/jetbrains/jps/incremental/storage/MapHandle;Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;)V", "getStorageRoot", "Ljava/nio/file/Path;", "updateStamp", "", "file", "buildTarget", "Lorg/jetbrains/jps/builders/BuildTarget;", "currentFileTimestamp", "createKey", "removeStamp", "target", "getCurrentStampIfUpToDate", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;Lorg/jetbrains/jps/builders/BuildTarget;Ljava/nio/file/attribute/BasicFileAttributes;)Ljava/lang/Long;", "Companion", "intellij.platform.jps.build"})
@ApiStatus.Internal
public final class ExperimentalTimeStampStorage
implements StampsStorage<Long> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapHandle<long[], Long> mapHandle;
    @NotNull
    private final PathRelativizerService relativizer;

    private ExperimentalTimeStampStorage(MapHandle<long[], Long> mapHandle, PathRelativizerService relativizer) {
        this.mapHandle = mapHandle;
        this.relativizer = relativizer;
    }

    @Override
    @Nullable
    public Path getStorageRoot() {
        return null;
    }

    @Override
    public void updateStamp(@NotNull Path file, @Nullable BuildTarget<?> buildTarget, long currentFileTimestamp) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.mapHandle.map.put((Object)this.createKey(file), (Object)currentFileTimestamp);
    }

    private final long[] createKey(Path file) {
        String string = this.relativizer.toRelative(file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
        return LongPairKeyDataTypeKt.stringTo128BitHash(string);
    }

    @Override
    public void removeStamp(@NotNull Path file, @Nullable BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.mapHandle.map.remove((Object)this.createKey(file));
    }

    @Override
    @Nullable
    public Long getCurrentStampIfUpToDate(@NotNull Path file, @Nullable BuildTarget<?> target, @Nullable BasicFileAttributes attrs) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Long l2 = (Long)this.mapHandle.map.get((Object)this.createKey(file));
        if (l2 != null) {
            Long l3 = l2;
            long it = ((Number)l3).longValue();
            boolean bl = false;
            l = it == (attrs == null || !attrs.isRegularFile() ? FSOperations.lastModified(file) : attrs.lastModifiedTime().toMillis()) ? l3 : null;
        } else {
            l = null;
        }
        return l;
    }

    public /* synthetic */ ExperimentalTimeStampStorage(MapHandle mapHandle, PathRelativizerService relativizer, DefaultConstructorMarker $constructor_marker) {
        this(mapHandle, relativizer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalTimeStampStorage$Companion;", "", "<init>", "()V", "createSourceToStampMap", "Lorg/jetbrains/jps/incremental/storage/ExperimentalTimeStampStorage;", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "targetId", "", "targetTypeId", "intellij.platform.jps.build"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final ExperimentalTimeStampStorage createSourceToStampMap(@NotNull StorageManager storageManager, @NotNull PathRelativizerService relativizer, @NotNull String targetId, @NotNull String targetTypeId) {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
            Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
            Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
            String mapName = storageManager.getMapName(targetId, targetTypeId, "file-hash-and-mtime-v1");
            return new ExperimentalTimeStampStorage(storageManager.openMap(mapName, LongPairKeyDataType.INSTANCE, LongStorageValueType.INSTANCE), relativizer, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

