/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "source", "", "renameLocalNames", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "refreshLabelNames", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nnamingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 namingUtils.kt\norg/jetbrains/kotlin/js/inline/util/NamingUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context, @NotNull List<? extends JsExpression> arguments, @NotNull List<JsParameter> parameters, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        if (!(arguments.size() <= parameters.size())) {
            boolean bl = false;
            String string = "arguments.size (" + arguments.size() + ") should be less or equal to parameters.size (" + parameters.size() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        List defaultParams = new ArrayList();
        for (Pair pair : CollectionsKt.zip((Iterable)arguments, (Iterable)parameters)) {
            JsNameRef replacement;
            JsName paramName;
            JsName jsName;
            JsExpression arg = (JsExpression)pair.component1();
            JsParameter param = (JsParameter)pair.component2();
            if (JsAstUtils.isUndefinedExpression(arg)) {
                ((Collection)defaultParams).add(param);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)param.getName(), (String)"getName(...)");
            JsName $this$aliasArgumentsIfNeeded_u24lambda_u241 = jsName = JsScope.declareTemporaryName(paramName.getIdent());
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$aliasArgumentsIfNeeded_u24lambda_u241);
            MetadataProperties.setStaticRef($this$aliasArgumentsIfNeeded_u24lambda_u241, arg);
            context.newVar($this$aliasArgumentsIfNeeded_u24lambda_u241, arg.deepCopy(), source);
            Intrinsics.checkNotNullExpressionValue((Object)jsName.makeRef(), (String)"makeRef(...)");
            replacement.setSource(arg.getSource());
            context.replaceName(paramName, replacement);
        }
        CollectionsKt.addAll((Collection)defaultParams, (Iterable)parameters.subList(arguments.size(), parameters.size()));
        for (JsParameter defaultParam : defaultParams) {
            JsName freshName;
            JsName paramName;
            Intrinsics.checkNotNullExpressionValue((Object)defaultParam.getName(), (String)"getName(...)");
            Intrinsics.checkNotNullExpressionValue((Object)JsScope.declareTemporaryName(paramName.getIdent()), (String)"declareTemporaryName(...)");
            freshName.copyMetadataFrom(paramName);
            NamingContext.newVar$default(context, freshName, null, source, 2, null);
            JsNameRef jsNameRef = freshName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            context.replaceName(paramName, jsNameRef);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        for (JsName name : CollectUtilsKt.collectDefinedNames(jsBlock)) {
            JsName temporaryName;
            JsName jsName;
            JsName $this$renameLocalNames_u24lambda_u242 = jsName = JsScope.declareTemporaryName(name.getIdent());
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$renameLocalNames_u24lambda_u242);
            MetadataProperties.setStaticRef($this$renameLocalNames_u24lambda_u242, MetadataProperties.getStaticRef(name));
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"apply(...)");
            JsNameRef jsNameRef = temporaryName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            context.replaceName(name, jsNameRef);
        }
    }

    @NotNull
    public static final JsNode refreshLabelNames(@NotNull JsNode node, @NotNull JsScope scope) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (!(scope instanceof JsFunctionScope)) {
            throw new AssertionError((Object)"JsFunction is expected to have JsFunctionScope");
        }
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor((JsFunctionScope)scope);
        JsNode jsNode = visitor2.accept(node);
        Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"accept(...)");
        return jsNode;
    }
}

