/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000fJ\u0012\u0010\"\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010!\u001a\u00020\u000fH\u0002J\f\u0010'\u001a\u00020\u0010*\u00020\u000fH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;", "", "parent", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getContainingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "captured", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lkotlin/collections/LinkedHashMap;", "capturedTypesImpl", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "capturedDescriptorToJsName", "", "getCapturedDescriptorToJsName", "()Ljava/util/Map;", "capturedDescriptors", "", "getCapturedDescriptors", "()Ljava/util/Set;", "capturedTypes", "getCapturedTypes", "used", "", "descriptor", "captureIfNeed", "isInLocalDeclaration", "", "isReceiverAncestor", "isSingletonReceiver", "getJsNameForCapturedDescriptor", "js.translator"})
@SourceDebugExtension(value={"SMAP\nUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageTracker.kt\norg/jetbrains/kotlin/js/translate/context/UsageTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class UsageTracker {
    @Nullable
    private final UsageTracker parent;
    @NotNull
    private final MemberDescriptor containingDescriptor;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final LinkedHashMap<DeclarationDescriptor, JsName> captured;
    @NotNull
    private final Map<TypeParameterDescriptor, JsName> capturedTypesImpl;

    public UsageTracker(@Nullable UsageTracker parent2, @NotNull MemberDescriptor containingDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)containingDescriptor, (String)"containingDescriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        this.parent = parent2;
        this.containingDescriptor = containingDescriptor;
        this.bindingContext = bindingContext;
        this.captured = new LinkedHashMap();
        this.capturedTypesImpl = new LinkedHashMap();
    }

    @NotNull
    public final MemberDescriptor getContainingDescriptor() {
        return this.containingDescriptor;
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public final Map<DeclarationDescriptor, JsName> getCapturedDescriptorToJsName() {
        return this.captured;
    }

    @NotNull
    public final Set<DeclarationDescriptor> getCapturedDescriptors() {
        Set<DeclarationDescriptor> set = this.captured.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public final Map<TypeParameterDescriptor, JsName> getCapturedTypes() {
        return this.capturedTypesImpl;
    }

    public final void used(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (UsageTrackerKt.isCaptured(this, descriptor)) {
            return;
        }
        if (descriptor instanceof FakeCallableDescriptorForObject) {
            return;
        }
        if (descriptor instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
            this.captureIfNeed(descriptor);
        } else if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
            this.captureIfNeed(descriptor);
        } else if (descriptor instanceof ReceiverParameterDescriptor) {
            this.captureIfNeed(descriptor);
        } else if (descriptor instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)descriptor).isReified()) {
            this.captureIfNeed(descriptor);
        }
    }

    private final void captureIfNeed(DeclarationDescriptor descriptor) {
        if (descriptor == null || UsageTrackerKt.isCaptured(this, descriptor) || !this.isInLocalDeclaration() || DescriptorUtils.isAncestor(this.containingDescriptor, descriptor, true) || this.isReceiverAncestor(descriptor) || this.isSingletonReceiver(descriptor)) {
            return;
        }
        if (DescriptorUtilsKt.isCoroutineLambda(descriptor) && Intrinsics.areEqual((Object)descriptor, (Object)this.containingDescriptor)) {
            return;
        }
        UsageTracker usageTracker = this.parent;
        if (usageTracker != null) {
            usageTracker.captureIfNeed(descriptor);
        }
        ((Map)this.captured).put(descriptor, this.getJsNameForCapturedDescriptor(descriptor));
        if (descriptor instanceof TypeParameterDescriptor && !Intrinsics.areEqual((Object)((TypeParameterDescriptor)descriptor).getContainingDeclaration().getOriginal(), (Object)this.containingDescriptor.getOriginal())) {
            StringBuilder stringBuilder = new StringBuilder().append("typeClosure$");
            String string = ((TypeParameterDescriptor)descriptor).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String name = stringBuilder.append(NameSuggestion.Companion.sanitizeName(string)).toString();
            this.capturedTypesImpl.put((TypeParameterDescriptor)descriptor, JsScope.declareTemporaryName(name));
        }
    }

    private final boolean isInLocalDeclaration() {
        MemberDescriptor memberDescriptor;
        MemberDescriptor container = this.containingDescriptor;
        if (container instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)container).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
            memberDescriptor = classifierDescriptorWithTypeParameters;
        } else {
            memberDescriptor = container;
        }
        return DescriptorUtils.isDescriptorWithLocalVisibility(memberDescriptor);
    }

    private final boolean isReceiverAncestor(DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        if (!(this.containingDescriptor instanceof ClassDescriptor) && !(this.containingDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        DeclarationDescriptor declarationDescriptor = ((ReceiverParameterDescriptor)descriptor).getContainingDeclaration();
        ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor currentClass = classDescriptor2;
        for (ClassDescriptor outerDeclaration : SequencesKt.generateSequence((Object)containingClass, UsageTracker::isReceiverAncestor$lambda$0)) {
            if (!Intrinsics.areEqual((Object)outerDeclaration, (Object)currentClass)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSingletonReceiver(DeclarationDescriptor descriptor) {
        ClassDescriptor containingClass;
        if (!(descriptor instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((ReceiverParameterDescriptor)descriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor container = declarationDescriptor;
        if (!DescriptorUtils.isObject(container)) {
            return false;
        }
        return this.containingDescriptor instanceof ClassDescriptor || !Intrinsics.areEqual((Object)(containingClass = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false)), (Object)container);
    }

    private final JsName getJsNameForCapturedDescriptor(DeclarationDescriptor $this$getJsNameForCapturedDescriptor) {
        String string;
        Object object = $this$getJsNameForCapturedDescriptor;
        if (object instanceof ReceiverParameterDescriptor) {
            string = UsageTrackerKt.access$getNameForCapturedReceiver((ReceiverParameterDescriptor)$this$getJsNameForCapturedDescriptor);
        } else if (object instanceof TypeParameterDescriptor) {
            String string2 = Namer.isInstanceSuggestedName((TypeParameterDescriptor)$this$getJsNameForCapturedDescriptor);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"isInstanceSuggestedName(...)");
        } else {
            SuggestedName suggestedName = new NameSuggestion().suggest($this$getJsNameForCapturedDescriptor, this.bindingContext);
            Intrinsics.checkNotNull((Object)suggestedName);
            String mangled = NameSuggestion.Companion.sanitizeName((String)CollectionsKt.last(suggestedName.getNames()));
            string = "closure$" + mangled;
        }
        String suggestedName = string;
        JsName jsName = JsScope.declareTemporaryName(suggestedName);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
        Object $this$getJsNameForCapturedDescriptor_u24lambda_u241 = object = jsName;
        boolean bl = false;
        MetadataProperties.setDescriptor((JsName)$this$getJsNameForCapturedDescriptor_u24lambda_u241, $this$getJsNameForCapturedDescriptor);
        return object;
    }

    private static final ClassDescriptor isReceiverAncestor$lambda$0(ClassDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DeclarationDescriptor declarationDescriptor = it.getContainingDeclaration();
        return declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
    }
}

