/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001a\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b*\u00020\u0003H\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\"\u0010\u0015\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003\u001a&\u0010\u0018\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "requiresExtensionReceiverParameter", "", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "translateFunction", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "outerContext", "reportInlineFunction", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "translatedFunction", "sourceInfo", "Lcom/intellij/psi/PsiElement;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nFunctionTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/FunctionTranslatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $this$translateAndAliasParameters, @NotNull FunctionDescriptor descriptor, @NotNull List<JsParameter> targetList) {
        Intrinsics.checkNotNullParameter((Object)$this$translateAndAliasParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(targetList, (String)"targetList");
        Map aliases = new LinkedHashMap();
        for (TypeParameterDescriptor type : FunctionTranslatorKt.getCorrectTypeParameters(descriptor)) {
            JsName paramName;
            String suggestedName;
            JsName paramNameForType;
            if (!type.isReified()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)$this$translateAndAliasParameters.getNameForDescriptor(type), (String)"getNameForDescriptor(...)");
            ((Collection)targetList).add(new JsParameter(paramNameForType));
            Intrinsics.checkNotNullExpressionValue((Object)Namer.isInstanceSuggestedName(type), (String)"isInstanceSuggestedName(...)");
            Intrinsics.checkNotNullExpressionValue((Object)JsScope.declareTemporaryName(suggestedName), (String)"declareTemporaryName(...)");
            ((Collection)targetList).add(new JsParameter(paramName));
            aliases.put(type, paramName.makeRef());
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
            JsName receiverParameterName = jsName;
            JsNameRef jsNameRef = receiverParameterName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            JsNameRef receiverRef = jsNameRef;
            JsExpression jsExpression = receiverRef;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
            MetadataProperties.setType(jsExpression, receiverParameterDescriptor.getType());
            ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor2);
            aliases.put(receiverParameterDescriptor2, receiverRef);
            ((Collection)targetList).add(new JsParameter(receiverParameterName));
        }
        for (ValueParameterDescriptor valueParameter : descriptor.getValueParameters()) {
            JsParameter jsParameter;
            JsNameRef parameterRef;
            JsName tmpName;
            JsName name;
            Intrinsics.checkNotNullExpressionValue((Object)$this$translateAndAliasParameters.getNameForDescriptor(valueParameter), (String)"getNameForDescriptor(...)");
            Object object = JsScope.declareTemporaryName(name.getIdent());
            JsName it = object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            MetadataProperties.setDescriptor(it, (DeclarationDescriptor)valueParameter);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"also(...)");
            Intrinsics.checkNotNullExpressionValue((Object)JsAstUtils.pureFqn(tmpName, null), (String)"pureFqn(...)");
            MetadataProperties.setType(parameterRef, valueParameter.getType());
            aliases.put(valueParameter, parameterRef);
            object = targetList;
            JsParameter $this$translateAndAliasParameters_u24lambda_u241 = jsParameter = new JsParameter(tmpName);
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)valueParameter);
            MetadataProperties.setHasDefaultValue($this$translateAndAliasParameters_u24lambda_u241, ArgumentsUtilsKt.hasDefaultValue(valueParameter));
            object.add(jsParameter);
        }
        ValueParameterDescriptor continuationDescriptor = $this$translateAndAliasParameters.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter = new JsParameter($this$translateAndAliasParameters.getNameForDescriptor(continuationDescriptor));
            ((Collection)targetList).add(jsParameter);
            aliases.put(continuationDescriptor, JsAstUtils.stateMachineReceiver());
        }
        TranslationContext translationContext = $this$translateAndAliasParameters.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerContextWithDescriptorsAliased(...)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(FunctionDescriptor $this$getCorrectTypeParameters) {
        Object object = $this$getCorrectTypeParameters instanceof PropertyAccessorDescriptor ? (PropertyAccessorDescriptor)$this$getCorrectTypeParameters : null;
        if (object == null || (object = object.getCorrespondingProperty()) == null || (object = object.getTypeParameters()) == null) {
            List<TypeParameterDescriptor> list = $this$getCorrectTypeParameters.getTypeParameters();
            object = list;
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
        }
        return object;
    }

    private static final boolean getRequiresExtensionReceiverParameter(FunctionDescriptor $this$requiresExtensionReceiverParameter) {
        return DescriptorUtils.isExtension($this$requiresExtensionReceiverParameter);
    }

    public static final void translateFunction(@NotNull TranslationContext $this$translateFunction, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter((Object)$this$translateFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor($this$translateFunction.bindingContext(), declaration);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionDescriptor(...)");
        FunctionDescriptor descriptor = functionDescriptor;
        if (declaration.hasBody()) {
            JsBlock jsBlock = FunctionBodyTranslator.translateFunctionBody(descriptor, declaration, $this$translateFunction);
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"translateFunctionBody(...)");
            JsBlock body = jsBlock;
            List<JsStatement> list = function2.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
            Collection collection = list;
            List<JsStatement> list2 = body.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
            CollectionsKt.addAll((Collection)collection, (Iterable)list2);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $this$wrapWithInlineMetadata, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$wrapWithInlineMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SourceElement sourceElement = descriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement sourceInfo = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        if (descriptor.isInline()) {
            IncrementalResultsConsumer incrementalResults;
            JsExpression jsExpression2;
            JsExpression jsExpression3;
            DeclarationDescriptor declarationDescriptor = descriptor;
            JsConfig jsConfig = $this$wrapWithInlineMetadata.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)jsConfig, (String)"getConfig(...)");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) {
                InlineMetadata metadata = InlineMetadata.Companion.compose(function2, descriptor, $this$wrapWithInlineMetadata);
                jsExpression3 = metadata.functionWithMetadata(outerContext, sourceInfo);
            } else {
                InlineFunctionContext inlineFunctionContext = $this$wrapWithInlineMetadata.getInlineFunctionContext();
                Intrinsics.checkNotNull((Object)inlineFunctionContext);
                InlineFunctionContext it = inlineFunctionContext;
                boolean bl = false;
                List<JsStatement> list = it.getImportBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                Collection collection = list;
                List<JsStatement> list2 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
                Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                List<JsStatement> list3 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)list3), (Object)new JsReturn(function2)));
                jsExpression3 = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
            JsExpression it = jsExpression2 = jsExpression3;
            boolean bl = false;
            IncrementalResultsConsumer incrementalResultsConsumer = incrementalResults = (IncrementalResultsConsumer)$this$wrapWithInlineMetadata.getConfig().getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
            if (incrementalResultsConsumer != null) {
                FunctionTranslatorKt.reportInlineFunction(incrementalResultsConsumer, descriptor, it, sourceInfo);
            }
            jsExpression = jsExpression2;
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private static final void reportInlineFunction(IncrementalResultsConsumer $this$reportInlineFunction, FunctionDescriptor descriptor, JsExpression translatedFunction, PsiElement sourceInfo) {
        String string;
        SourceFile sourceFile = descriptor.getSource().getContainingFile();
        PsiSourceFile psiSourceFile = sourceFile instanceof PsiSourceFile ? (PsiSourceFile)sourceFile : null;
        if (psiSourceFile == null || (psiSourceFile = psiSourceFile.getPsiFile()) == null) {
            return;
        }
        PsiSourceFile psiFile = psiSourceFile;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)psiFile.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        File file2 = file;
        DescriptorVisibility descriptorVisibility = descriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
        if (EffectiveVisibilityUtilsKt.effectiveVisibility(descriptorVisibility, descriptor, true).getPrivateApi()) {
            return;
        }
        FunctionDescriptor functionDescriptor = descriptor;
        if (functionDescriptor instanceof PropertyGetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<get>");
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
            string = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else if (functionDescriptor instanceof PropertySetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<set>");
            PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
            string = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else {
            string = DescriptorUtilsKt.getFqNameSafe(descriptor).asString();
        }
        String fqName = string;
        PsiElement psiElement = sourceInfo;
        Integer offset2 = psiElement != null && (psiElement = psiElement.getNode()) != null ? Integer.valueOf(psiElement.getStartOffset()) : null;
        Document document = psiFile.getViewProvider().getDocument();
        int sourceLine = -1;
        int sourceColumn = -1;
        if (offset2 != null && document != null) {
            sourceLine = document.getLineNumber(offset2.intValue());
            sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
        }
        $this$reportInlineFunction.processInlineFunction(file2, fqName, (Object)translatedFunction, sourceLine, sourceColumn);
    }
}

