/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.ArrayList;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorConfigActionUtil {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("EditorConfig");

    public static AnAction[] createNavigationActions(@NotNull PsiFile file) {
        EditorConfigNavigationActionsFactory navigationActionsFactory;
        if (file == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(0);
        }
        if ((navigationActionsFactory = EditorConfigNavigationActionsFactory.Companion.getInstance(file)) == null) {
            return AnAction.EMPTY_ARRAY;
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>(navigationActionsFactory.getNavigationActions(file.getProject(), file.getVirtualFile()));
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    public static AnAction createDisableAction(@NotNull Project project, @NotNull @Nls String message) {
        if (project == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(1);
        }
        if (message == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(2);
        }
        return DumbAwareAction.create((String)message, e -> {
            EditorConfigSettings settings = (EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = false;
            CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
            EditorConfigActionUtil.showDisabledDetectionNotification(project);
        });
    }

    private static void showDisabledDetectionNotification(@NotNull Project project) {
        if (project == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(3);
        }
        EditorConfigDisabledNotification notification = new EditorConfigDisabledNotification(project);
        notification.notify(project);
    }

    public static AnAction createShowEditorConfigFilesAction() {
        return new DumbAwareAction(EditorConfigBundle.message("editor.config.files.show")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null) {
                    EditorConfigActionUtil.showEditorConfigFiles(e.getProject(), e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/editorconfig/configmanagement/EditorConfigActionUtil$1", "actionPerformed"));
            }
        };
    }

    public static void showEditorConfigFiles(@NotNull Project project, @NotNull AnActionEvent event) {
        if (project == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(4);
        }
        if (event == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(5);
        }
        SearchEverywhereManager seManager = SearchEverywhereManager.getInstance((Project)project);
        String searchProviderID = "SearchEverywhereContributor.All";
        if (seManager.isShown() && !searchProviderID.equals(seManager.getSelectedTabID())) {
            seManager.setSelectedTabID(searchProviderID);
        }
        seManager.show(searchProviderID, ".editorconfig", event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigActionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createNavigationActions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDisableAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showDisabledDetectionNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorConfigFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class EditorConfigDisabledNotification
    extends Notification {
        private EditorConfigDisabledNotification(Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), EditorConfigBundle.message("disabled.notification"), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableAction(project, this));
            this.addAction((AnAction)new ShowEditorConfigOption(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }

    private static final class ReEnableAction
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableAction(@NotNull Project project, Notification notification) {
            if (project == null) {
                ReEnableAction.$$$reportNull$$$0(0);
            }
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReEnableAction.$$$reportNull$$$0(1);
            }
            CodeStyleSettings rootSettings = CodeStyle.getSettings((Project)this.myProject);
            EditorConfigSettings settings = (EditorConfigSettings)rootSettings.getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = true;
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
            this.myNotification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigActionUtil$ReEnableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ShowEditorConfigOption
    extends DumbAwareAction {
        private ShowEditorConfigOption(@Nullable @Nls String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowEditorConfigOption.$$$reportNull$$$0(0);
            }
            ShowSettingsUtilImpl.showSettingsDialog((Project)e.getProject(), (String)"preferences.sourceCode", (String)"EditorConfig");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/editorconfig/configmanagement/EditorConfigActionUtil$ShowEditorConfigOption", "actionPerformed"));
        }
    }
}

