/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.MemoryDumpHelper;
import com.jetbrains.performancePlugin.commands.MemoryDumpCommand;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/ConditionalMemoryDumpCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nConditionalMemoryDumpCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConditionalMemoryDumpCommand.kt\ncom/jetbrains/performancePlugin/commands/ConditionalMemoryDumpCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,41:1\n14#2:42\n*S KotlinDebug\n*F\n+ 1 ConditionalMemoryDumpCommand.kt\ncom/jetbrains/performancePlugin/commands/ConditionalMemoryDumpCommand\n*L\n14#1:42\n*E\n"})
public final class ConditionalMemoryDumpCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "conditionalMemoryDumpCommand";
    @NotNull
    public static final String PREFIX = "%conditionalMemoryDumpCommand";
    @NotNull
    public static final String WITH_ERROR_TEXT = "WITH_ERROR_MESSAGE";
    @NotNull
    private static final Logger LOG;

    public ConditionalMemoryDumpCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String string = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List params = regex.split(charSequence, n);
        int targetMessageCount = Integer.parseInt((String)params.get(0));
        Ref.IntRef currentMessageCount = new Ref.IntRef();
        boolean withErrorMessages = params.contains(WITH_ERROR_TEXT);
        LowMemoryWatcher.register(() -> ConditionalMemoryDumpCommand.doExecute$lambda$0(currentMessageCount, targetMessageCount, withErrorMessages), (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC, (Disposable)((Disposable)ApplicationManager.getApplication()));
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    protected String getName() {
        return NAME;
    }

    private static final void doExecute$lambda$0(Ref.IntRef $currentMessageCount, int $targetMessageCount, boolean $withErrorMessages) {
        int n = $currentMessageCount.element;
        $currentMessageCount.element = n + 1;
        if ($currentMessageCount.element == $targetMessageCount) {
            String string = MemoryDumpCommand.getMemoryDumpPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemoryDumpPath(...)");
            String memoryDumpPath = string;
            LOG.info("Dumping memory snapshot to: " + memoryDumpPath);
            MemoryDumpHelper.captureMemoryDump((String)memoryDumpPath);
            if ($withErrorMessages) {
                LOG.error("Got low memory signal, memory dump attached");
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConditionalMemoryDumpCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/performancePlugin/commands/ConditionalMemoryDumpCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "WITH_ERROR_TEXT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

