/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import java.awt.Container;
import javax.swing.JFrame;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.fixture.FrameFixture;

public final class Containers {
    public static final String CREATED_FRAME_NAME = "org.assertj.swing.CreatedFrameForContainer";

    @Nonnull
    @RunsInEDT
    public static FrameFixture showInFrame(@Nonnull Container contentPane) {
        FrameFixture frameFixture = Containers.frameFixtureFor(contentPane);
        frameFixture.show();
        return frameFixture;
    }

    @Nonnull
    @RunsInEDT
    public static FrameFixture showInFrame(@Nonnull Robot robot, @Nonnull Container contentPane) {
        FrameFixture frameFixture = Containers.frameFixtureFor(robot, contentPane);
        frameFixture.show();
        return frameFixture;
    }

    @Nonnull
    @RunsInEDT
    public static FrameFixture frameFixtureFor(@Nonnull Container contentPane) {
        return new FrameFixture(Containers.frameFor(contentPane));
    }

    @Nonnull
    @RunsInEDT
    public static FrameFixture frameFixtureFor(@Nonnull Robot robot, @Nonnull Container contentPane) {
        return new FrameFixture(robot, Containers.frameFor(contentPane));
    }

    @Nonnull
    @RunsInEDT
    public static JFrame frameFor(final @Nonnull Container contentPane) {
        JFrame result = GuiActionRunner.execute(new GuiQuery<JFrame>(){

            @Override
            protected JFrame executeInEDT() throws Throwable {
                JFrame frame = new JFrame("Created by FEST");
                frame.setName(Containers.CREATED_FRAME_NAME);
                frame.setContentPane(contentPane);
                return frame;
            }
        });
        return Preconditions.checkNotNull(result);
    }

    private Containers() {
    }
}

