/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.DynamicBundle;
import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.ReportStatusDispatcher;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.ReportStatus;
import org.gradle.launcher.daemon.protocol.Status;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.registry.DaemonStopEvents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonAction;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u001c\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0016H\u0002J\f\u0010!\u001a\u00020\"*\u00020\u0016H\u0002J\u0019\u0010#\u001a\n %*\u0004\u0018\u00010$0$*\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010&J\u0019\u0010'\u001a\n %*\u0004\u0018\u00010$0$*\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010&J\u0019\u0010(\u001a\n %*\u0004\u0018\u00010)0)*\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0,*\u00020\u001bH\u0002J\f\u0010-\u001a\u00020 *\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/gradle/internal/daemon/ReportDaemonStatusClient;", "", "daemonRegistry", "Lorg/gradle/launcher/daemon/registry/DaemonRegistry;", "connector", "Lorg/gradle/launcher/daemon/client/DaemonConnector;", "idGenerator", "Lorg/gradle/internal/id/IdGenerator;", "<init>", "(Lorg/gradle/launcher/daemon/registry/DaemonRegistry;Lorg/gradle/launcher/daemon/client/DaemonConnector;Lorg/gradle/internal/id/IdGenerator;)V", "reportStatusDispatcher", "Lorg/gradle/launcher/daemon/client/ReportStatusDispatcher;", "get", "", "Lorg/jetbrains/plugins/gradle/internal/daemon/DaemonState;", "forEachAliveDaemon", "", "action", "Lkotlin/Function1;", "forEachStoppedDaemon", "getStoppedDaemonState", "event", "Lorg/gradle/launcher/daemon/registry/DaemonStopEvent;", "getDaemonState", "connection", "Lorg/gradle/launcher/daemon/client/DaemonClientConnection;", "daemon", "Lorg/gradle/launcher/daemon/registry/DaemonInfo;", "getState", "status", "Lorg/gradle/launcher/daemon/protocol/Status;", "getTimestampTime", "", "getExpirationStatus", "", "getRegistryDir", "Ljava/io/File;", "kotlin.jvm.PlatformType", "(Lorg/gradle/launcher/daemon/registry/DaemonInfo;)Ljava/io/File;", "getJavaHome", "getIdleTimeout", "", "(Lorg/gradle/launcher/daemon/registry/DaemonInfo;)Ljava/lang/Integer;", "getDaemonOpts", "", "getLastBusyTimestamp", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nReportDaemonStatusClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportDaemonStatusClient.kt\norg/jetbrains/plugins/gradle/internal/daemon/ReportDaemonStatusClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1863#2,2:148\n1863#2,2:150\n*S KotlinDebug\n*F\n+ 1 ReportDaemonStatusClient.kt\norg/jetbrains/plugins/gradle/internal/daemon/ReportDaemonStatusClient\n*L\n38#1:148,2\n49#1:150,2\n*E\n"})
public final class ReportDaemonStatusClient {
    @NotNull
    private final DaemonRegistry daemonRegistry;
    @NotNull
    private final DaemonConnector connector;
    @NotNull
    private final IdGenerator<?> idGenerator;
    @NotNull
    private final ReportStatusDispatcher reportStatusDispatcher;

    public ReportDaemonStatusClient(@NotNull DaemonRegistry daemonRegistry, @NotNull DaemonConnector connector, @NotNull IdGenerator<?> idGenerator) {
        Intrinsics.checkNotNullParameter((Object)daemonRegistry, (String)"daemonRegistry");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter(idGenerator, (String)"idGenerator");
        this.daemonRegistry = daemonRegistry;
        this.connector = connector;
        this.idGenerator = idGenerator;
        this.reportStatusDispatcher = new ReportStatusDispatcher();
    }

    @NotNull
    public final List<DaemonState> get() {
        List daemons = new ArrayList();
        this.forEachAliveDaemon((Function1<? super DaemonState, Unit>)((Function1)arg_0 -> ReportDaemonStatusClient.get$lambda$0(daemons, arg_0)));
        this.forEachStoppedDaemon((Function1<? super DaemonState, Unit>)((Function1)arg_0 -> ReportDaemonStatusClient.get$lambda$1(daemons, arg_0)));
        return daemons;
    }

    private final void forEachAliveDaemon(Function1<? super DaemonState, Unit> action) {
        List list = this.daemonRegistry.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAll(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DaemonInfo it = (DaemonInfo)element$iv;
            boolean bl = false;
            DaemonClientConnection connection = this.connector.maybeConnect((DaemonConnectDetails)it);
            if (connection == null) continue;
            Intrinsics.checkNotNull((Object)it);
            DaemonState state = this.getDaemonState(connection, it);
            action.invoke((Object)state);
        }
    }

    private final void forEachStoppedDaemon(Function1<? super DaemonState, Unit> action) {
        List list = DaemonStopEvents.uniqueRecentDaemonStopEvents((List)this.daemonRegistry.getStopEvents());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"uniqueRecentDaemonStopEvents(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DaemonStopEvent it = (DaemonStopEvent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            DaemonState state = this.getStoppedDaemonState(it);
            action.invoke((Object)state);
        }
    }

    private final DaemonState getStoppedDaemonState(DaemonStopEvent event) {
        return new DaemonState(event.getPid(), null, null, "Stopped", event.getReason(), this.getTimestampTime(event), this.getExpirationStatus(event), null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DaemonState getDaemonState(DaemonClientConnection connection, DaemonInfo daemon) {
        DaemonInfo daemonInfo;
        if (connection.getDaemon() instanceof DaemonInfo) {
            DaemonConnectDetails daemonConnectDetails = connection.getDaemon();
            Intrinsics.checkNotNull((Object)daemonConnectDetails, (String)"null cannot be cast to non-null type org.gradle.launcher.daemon.registry.DaemonInfo");
            daemonInfo = (DaemonInfo)daemonConnectDetails;
        } else {
            daemonInfo = daemon;
        }
        DaemonInfo connectionDaemon = daemonInfo;
        try {
            Object object = this.idGenerator.generateId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"generateId(...)");
            ReportStatus statusCommand = DaemonAction.Companion.createCommand(ReportStatus.class, object, daemon.getToken());
            Status status = this.reportStatusDispatcher.dispatch((Connection)connection, (Command)statusCommand);
            DaemonState daemonState = this.getState(connectionDaemon, status);
            return daemonState;
        }
        finally {
            connection.stop();
        }
    }

    private final DaemonState getState(DaemonInfo daemon, Status status) {
        DaemonState daemonState;
        if (status != null) {
            Long l = daemon.getPid();
            byte[] byArray = daemon.getToken();
            String string = status.getVersion();
            String string2 = status.getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatus(...)");
            daemonState = new DaemonState(l, byArray, string, string2, null, this.getLastBusyTimestamp(daemon), null, this.getDaemonOpts(daemon), this.getJavaHome(daemon), this.getIdleTimeout(daemon), this.getRegistryDir(daemon));
        } else {
            daemonState = new DaemonState(daemon.getPid(), daemon.getToken(), "UNKNOWN", "UNKNOWN", null, this.getLastBusyTimestamp(daemon), null, this.getDaemonOpts(daemon), this.getJavaHome(daemon), this.getIdleTimeout(daemon), this.getRegistryDir(daemon));
        }
        return daemonState;
    }

    private final long getTimestampTime(DaemonStopEvent $this$getTimestampTime) {
        return $this$getTimestampTime.getTimestamp().getTime();
    }

    private final String getExpirationStatus(DaemonStopEvent $this$getExpirationStatus) {
        Object object;
        block3: {
            block2: {
                object = $this$getExpirationStatus.getStatus();
                if (object == null || (object = object.name()) == null || (object = StringsKt.replace$default((String)object, (String)"_", (String)" ", (boolean)false, (int)4, null)) == null) break block2;
                Object object2 = object;
                Locale locale = DynamicBundle.getLocale();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
                String string = ((String)object2).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final File getRegistryDir(DaemonInfo $this$getRegistryDir) {
        return $this$getRegistryDir.getContext().getDaemonRegistryDir();
    }

    private final File getJavaHome(DaemonInfo $this$getJavaHome) {
        return $this$getJavaHome.getContext().getJavaHome();
    }

    private final Integer getIdleTimeout(DaemonInfo $this$getIdleTimeout) {
        return $this$getIdleTimeout.getContext().getIdleTimeout();
    }

    private final Collection<String> getDaemonOpts(DaemonInfo $this$getDaemonOpts) {
        try {
            Object object = GradleReflectionUtil.reflectiveCall((Object)$this$getDaemonOpts.getContext(), (String)"getDaemonOpts", Collection.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Collection<kotlin.String>");
            return (Collection)object;
        }
        catch (Throwable t) {
            return CollectionsKt.emptyList();
        }
    }

    private final long getLastBusyTimestamp(DaemonInfo $this$getLastBusyTimestamp) {
        return $this$getLastBusyTimestamp.getLastBusy().getTime();
    }

    private static final Unit get$lambda$0(List $daemons, DaemonState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $daemons.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$1(List $daemons, DaemonState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $daemons.add(it);
        return Unit.INSTANCE;
    }
}

