/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0010\u0018\u0000 '2\u00020\u0001:\u0001'B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0018H\u0014J\r\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010#\u001a\u00020\u0005H\u0002J\u0015\u0010$\u001a\n %*\u0004\u0018\u00010\u00050\u0005H\u0002\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0014\u0010\u000bR\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\r\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters;", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "gradleHome", "Lcom/intellij/execution/target/value/TargetValue;", "getGradleHome", "()Lcom/intellij/execution/target/value/TargetValue;", "gradleHome$delegate", "Lkotlin/Lazy;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGradleVersion", "()Lorg/gradle/util/GradleVersion;", "gradleVersion$delegate", "gradleUserHome", "getGradleUserHome", "gradleUserHome$delegate", "getGradleProjectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "Lorg/jetbrains/annotations/Nullable;", "getGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "Lorg/jetbrains/annotations/NotNull;", "wrapperConfiguration", "Lorg/gradle/wrapper/WrapperConfiguration;", "getWrapperConfiguration", "()Lorg/gradle/wrapper/WrapperConfiguration;", "wrapperConfiguration$delegate", "findGradleHome", "guessGradleVersion", "findGradleUserHomeDir", "defaultGradleUserHome", "kotlin.jvm.PlatformType", "()Ljava/lang/String;", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nLocalBuildLayoutParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n1#2:105\n14#3:106\n*S KotlinDebug\n*F\n+ 1 LocalBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters\n*L\n102#1:106\n*E\n"})
public class LocalBuildLayoutParameters
implements BuildLayoutParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final String projectPath;
    @NotNull
    private final Lazy gradleHome$delegate;
    @NotNull
    private final Lazy gradleVersion$delegate;
    @NotNull
    private final Lazy gradleUserHome$delegate;
    @NotNull
    private final Lazy wrapperConfiguration$delegate;
    @NotNull
    private static final Logger log;

    public LocalBuildLayoutParameters(@NotNull Project project2, @Nullable String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.projectPath = projectPath;
        this.gradleHome$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.gradleHome_delegate$lambda$1(this));
        this.gradleVersion$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.gradleVersion_delegate$lambda$2(this));
        this.gradleUserHome$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.gradleUserHome_delegate$lambda$3(this));
        this.wrapperConfiguration$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.wrapperConfiguration_delegate$lambda$6(this));
    }

    @Override
    @Nullable
    public TargetValue<String> getGradleHome() {
        Lazy lazy = this.gradleHome$delegate;
        return (TargetValue)lazy.getValue();
    }

    @Override
    @Nullable
    public GradleVersion getGradleVersion() {
        Lazy lazy = this.gradleVersion$delegate;
        return (GradleVersion)lazy.getValue();
    }

    @Override
    @NotNull
    public TargetValue<String> getGradleUserHome() {
        Lazy lazy = this.gradleUserHome$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (TargetValue)object;
    }

    @Nullable
    protected GradleProjectSettings getGradleProjectSettings() {
        GradleProjectSettings gradleProjectSettings;
        String string = this.projectPath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            gradleProjectSettings = (GradleProjectSettings)this.getGradleSettings().getLinkedProjectSettings(it);
        } else {
            gradleProjectSettings = null;
        }
        return gradleProjectSettings;
    }

    private final GradleSettings getGradleSettings() {
        GradleSettings gradleSettings = GradleSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        return gradleSettings;
    }

    private final WrapperConfiguration getWrapperConfiguration() {
        Lazy lazy = this.wrapperConfiguration$delegate;
        return (WrapperConfiguration)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findGradleHome() {
        GradleProjectSettings gradleProjectSettings = this.getGradleProjectSettings();
        Object object = gradleProjectSettings;
        if (object == null || (object = object.getDistributionType()) == null) {
            File file = GradleInstallationManager.getInstance().getAutodetectedGradleHome(this.project);
            return file != null ? file.getPath() : null;
        }
        Object distributionType = object;
        if (distributionType == DistributionType.LOCAL) {
            return gradleProjectSettings.getGradleHome();
        }
        if (distributionType == DistributionType.WRAPPED) {
            return GradleLocalSettings.getInstance(this.project).getGradleHome(this.projectPath);
        }
        if (this.getWrapperConfiguration() == null) {
            return null;
        }
        String string = GradleTargetUtil.maybeGetLocalValue(this.getGradleUserHome());
        if (string == null) {
            return null;
        }
        String localGradleUserHome = string;
        PathAssembler.LocalDistribution localDistribution = new PathAssembler(new File(localGradleUserHome), new File(gradleProjectSettings.getExternalProjectPath())).getDistribution(this.getWrapperConfiguration());
        File file = localDistribution.getDistributionDir();
        if (file == null) {
            return null;
        }
        File distributionDir = file;
        if (!distributionDir.exists()) {
            return null;
        }
        try {
            List list;
            AutoCloseable autoCloseable = Files.list(distributionDir.toPath());
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                list = ((Stream)it.filter(arg_0 -> LocalBuildLayoutParameters.findGradleHome$lambda$9$lambda$8(LocalBuildLayoutParameters::findGradleHome$lambda$9$lambda$7, arg_0)).unordered()).limit(2L).toList();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            List dirs = list;
            if (dirs.size() == 1) {
                Intrinsics.checkNotNull(dirs);
                return CollectionsKt.first(dirs).toString();
            }
        }
        catch (Exception e) {
            log.debug("Can not find Gradle installation inside " + distributionDir.getPath(), (Throwable)e);
        }
        return null;
    }

    private final GradleVersion guessGradleVersion() {
        Object object = this.getGradleProjectSettings();
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        GradleProjectSettings distributionType = object;
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
            case 2: {
                return GradleVersion.current();
            }
            case 3: {
                GradleVersion gradleVersion;
                TargetValue<String> targetValue = this.getGradleHome();
                String string = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string != null) {
                    String $this$guessGradleVersion_u24lambda_u2410 = string;
                    boolean bl = false;
                    gradleVersion = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u2410);
                } else {
                    gradleVersion = null;
                }
                return gradleVersion;
            }
            case 1: {
                GradleVersion gradleVersion;
                TargetValue<String> targetValue = this.getGradleHome();
                String string = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string != null) {
                    String $this$guessGradleVersion_u24lambda_u2411 = string;
                    boolean bl = false;
                    v6 = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u2411);
                } else {
                    v6 = gradleVersion = null;
                }
                if (gradleVersion == null) {
                    String path;
                    Object object2 = this.getWrapperConfiguration();
                    String string2 = object2 != null && (object2 = object2.getDistribution()) != null ? ((URI)object2).getRawPath() : (path = null);
                    if (path == null) break;
                    return GradleInstallationManager.parseDistributionVersion(path);
                }
                return gradleVersion;
            }
            case 4: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    private final String findGradleUserHomeDir() {
        if (this.projectPath == null) {
            String string = this.defaultGradleUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultGradleUserHome(...)");
            return string;
        }
        String string = this.getGradleSettings().getServiceDirectoryPath();
        if (string == null) {
            String string2 = this.defaultGradleUserHome();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultGradleUserHome(...)");
        }
        return string;
    }

    private final String defaultGradleUserHome() {
        return GradleUserHomeUtil.gradleUserHomeDir().getPath();
    }

    private static final TargetValue gradleHome_delegate$lambda$1(LocalBuildLayoutParameters this$0) {
        TargetValue targetValue;
        String string = this$0.findGradleHome();
        if (string != null) {
            String it = string;
            boolean bl = false;
            targetValue = TargetValue.fixed((Object)it);
        } else {
            targetValue = null;
        }
        return targetValue;
    }

    private static final GradleVersion gradleVersion_delegate$lambda$2(LocalBuildLayoutParameters this$0) {
        return this$0.guessGradleVersion();
    }

    private static final TargetValue gradleUserHome_delegate$lambda$3(LocalBuildLayoutParameters this$0) {
        return TargetValue.fixed((Object)this$0.findGradleUserHomeDir());
    }

    private static final WrapperConfiguration wrapperConfiguration_delegate$lambda$6(LocalBuildLayoutParameters this$0) {
        Object object = this$0.getGradleProjectSettings();
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        GradleProjectSettings distributionType = object;
        return switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
            case 1 -> GradleUtil.getWrapperConfiguration(this$0.projectPath);
            case 2 -> {
                WrapperConfiguration var2_2;
                WrapperConfiguration $this$wrapperConfiguration_delegate_u24lambda_u246_u24lambda_u245 = var2_2 = new WrapperConfiguration();
                boolean $i$a$-apply-LocalBuildLayoutParameters$wrapperConfiguration$2$1 = false;
                $this$wrapperConfiguration_delegate_u24lambda_u246_u24lambda_u245.setDistribution(GradleUtil.getWrapperDistributionUri(GradleVersion.current()));
                yield var2_2;
            }
            default -> null;
        };
    }

    private static final boolean findGradleHome$lambda$9$lambda$7(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean findGradleHome$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalGradleExecutionAware.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DistributionType.values().length];
            try {
                nArray[DistributionType.DEFAULT_WRAPPED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.BUNDLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.LOCAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.WRAPPED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

