/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.linux;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.linux.FixDialog;
import com.intellij.profiler.linux.InfoDialog;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesFixer;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.VariableValidationResult;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00122\r\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/linux/FixDialog;", "Lcom/intellij/profiler/linux/InfoDialog;", "validationResult", "", "Lcom/intellij/profiler/linux/KernelVariable;", "Lcom/intellij/profiler/linux/VariableValidationResult;", "Lcom/intellij/profiler/linux/AllVariablesValidationResult;", "fixer", "Lcom/intellij/profiler/linux/KernelVariablesFixer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/util/Map;Lcom/intellij/profiler/linux/KernelVariablesFixer;Lcom/intellij/openapi/project/Project;)V", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "onError", "", "message", "", "Lorg/jetbrains/annotations/Nls;", "onSuccess", "intellij.profiler.common"})
final class FixDialog
extends InfoDialog {
    @NotNull
    private final KernelVariablesFixer fixer;

    public FixDialog(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult, @NotNull KernelVariablesFixer fixer, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter((Object)fixer, (String)"fixer");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(validationResult, project, false);
        this.fixer = fixer;
    }

    @NotNull
    protected Action[] createActions() {
        String string = this.getProfilerName().toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String sysctlPath = "/etc/sysctl.d/99-" + string + ".conf";
        Object object = new Object[]{sysctlPath};
        String string2 = CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.changePerm", object);
        DialogWrapper.DialogWrapperAction changePermanently2 = new DialogWrapper.DialogWrapperAction(this, sysctlPath, string2){
            final /* synthetic */ FixDialog this$0;
            final /* synthetic */ String $sysctlPath;
            {
                this.this$0 = $receiver;
                this.$sysctlPath = $sysctlPath;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                FixDialog.access$getFixer$p(this.this$0).changeVarsPermanently(this.$sysctlPath, this.this$0.getValidationResult(), (Function0<Unit>)((Function0)() -> createActions.changePermanently.1.doAction$lambda$0(this.this$0)), (Function1<? super String, Unit>)((Function1)arg_0 -> createActions.changePermanently.1.doAction$lambda$1(this.this$0, arg_0)), KernelVariablesValidatorKt.access$getLOG$p(), this.this$0.getProject());
            }

            private static final Unit doAction$lambda$0(FixDialog this$0) {
                FixDialog.access$onSuccess(this$0);
                return Unit.INSTANCE;
            }

            private static final Unit doAction$lambda$1(FixDialog this$0, String it) {
                FixDialog.access$setErrorText(this$0, it);
                return Unit.INSTANCE;
            }
        };
        object = CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.changeUntilRestart", new Object[0]);
        OptionAction changeUntilRestart2 = new OptionAction(this, changePermanently2, (String)object){
            final /* synthetic */ FixDialog this$0;
            final /* synthetic */ createActions.changePermanently.1 $changePermanently;
            {
                this.this$0 = $receiver;
                this.$changePermanently = $changePermanently;
                super($super_call_param$1);
                this.putValue("DefaultAction", true);
            }

            public void actionPerformed(ActionEvent e) {
                FixDialog.access$getFixer$p(this.this$0).changeVarsUntilRestart(this.this$0.getValidationResult(), (Function0<Unit>)((Function0)() -> createActions.changeUntilRestart.1.actionPerformed$lambda$0(this.this$0)), (Function1<? super String, Unit>)((Function1)arg_0 -> createActions.changeUntilRestart.1.actionPerformed$lambda$1(this.this$0, arg_0)), KernelVariablesValidatorKt.access$getLOG$p(), this.this$0.getProject());
            }

            public createActions.changePermanently.1[] getOptions() {
                createActions.changePermanently.1[] nullArray = new createActions.changePermanently.1[]{this.$changePermanently};
                return nullArray;
            }

            private static final Unit actionPerformed$lambda$0(FixDialog this$0) {
                FixDialog.access$onSuccess(this$0);
                return Unit.INSTANCE;
            }

            private static final Unit actionPerformed$lambda$1(FixDialog this$0, String it) {
                FixDialog.access$onError(this$0, it);
                return Unit.INSTANCE;
            }
        };
        object = new Action[]{changeUntilRestart2, this.getCancelAction()};
        return object;
    }

    private final void onError(String message) {
        this.setErrorText(message);
    }

    private final void onSuccess() {
        this.setErrorText(null);
        ApplicationManager.getApplication().invokeLater(() -> FixDialog.onSuccess$lambda$0(this));
    }

    private static final void onSuccess$lambda$0(FixDialog this$0) {
        this$0.close(0);
    }

    public static final /* synthetic */ KernelVariablesFixer access$getFixer$p(FixDialog $this) {
        return $this.fixer;
    }

    public static final /* synthetic */ void access$onSuccess(FixDialog $this) {
        $this.onSuccess();
    }

    public static final /* synthetic */ void access$setErrorText(FixDialog $this, String p0) {
        $this.setErrorText(p0);
    }

    public static final /* synthetic */ void access$onError(FixDialog $this, String message) {
        $this.onError(message);
    }
}

