/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.statistic;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.kotlin.build.report.FileReportSettings;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.JpsBuildTime;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.HttpReportService;
import org.jetbrains.kotlin.build.report.statistics.file.ReadableFileReportData;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinLogger;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporterImpl;
import org.jetbrains.kotlin.jps.statistic.JpsFileReportService;
import org.jetbrains.kotlin.jps.statistic.JpsStatisticsReportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0016J1\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H(0,H\u0016\u00a2\u0006\u0002\u0010-R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportServiceImpl;", "Lorg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService;", "fileReportSettings", "Lorg/jetbrains/kotlin/build/report/FileReportSettings;", "httpReportSettings", "Lorg/jetbrains/kotlin/build/report/HttpReportSettings;", "(Lorg/jetbrains/kotlin/build/report/FileReportSettings;Lorg/jetbrains/kotlin/build/report/HttpReportSettings;)V", "buildMetrics", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "finishedModuleBuildMetrics", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "httpService", "Lorg/jetbrains/kotlin/build/report/statistics/HttpReportService;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loggerAdapter", "Lorg/jetbrains/kotlin/compilerRunner/JpsKotlinLogger;", "buildFinish", "", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "buildStarted", "getMetricReporter", "moduleName", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "moduleBuildFinished", "exitCode", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "moduleBuildStarted", "reportCompilerArguments", "kotlinChunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "reportDirtyFiles", "kotlinDirtySourceFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "reportMetrics", "T", "metric", "Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildTime;", "action", "Lkotlin/Function0;", "(Lorg/jetbrains/jps/ModuleChunk;Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildTime;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nJpsStatisticsReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsStatisticsReportService.kt\norg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,180:1\n1#2:181\n1557#3:182\n1628#3,3:183\n1557#3:191\n1628#3,3:192\n1557#3:195\n1628#3,3:196\n31#4,5:186\n*S KotlinDebug\n*F\n+ 1 JpsStatisticsReportService.kt\norg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportServiceImpl\n*L\n143#1:182\n143#1:183,3\n164#1:191\n164#1:192,3\n165#1:195\n165#1:196,3\n159#1:186,5\n*E\n"})
public final class JpsStatisticsReportServiceImpl
extends JpsStatisticsReportService {
    @Nullable
    private final FileReportSettings fileReportSettings;
    @NotNull
    private final ConcurrentHashMap<String, JpsBuilderMetricReporter> buildMetrics;
    @NotNull
    private final ConcurrentLinkedQueue<JpsBuilderMetricReporter> finishedModuleBuildMetrics;
    @NotNull
    private final Logger log;
    @NotNull
    private final JpsKotlinLogger loggerAdapter;
    @Nullable
    private final HttpReportService httpService;

    /*
     * WARNING - void declaration
     */
    public JpsStatisticsReportServiceImpl(@Nullable FileReportSettings fileReportSettings, @Nullable HttpReportSettings httpReportSettings) {
        super(null);
        HttpReportService httpReportService;
        this.fileReportSettings = fileReportSettings;
        this.buildMetrics = new ConcurrentHashMap();
        this.finishedModuleBuildMetrics = new ConcurrentLinkedQueue();
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.statistic.KotlinBuilderReportService");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#org.jetbra\u2026linBuilderReportService\")");
        this.log = logger;
        this.loggerAdapter = new JpsKotlinLogger(this.log);
        JpsStatisticsReportServiceImpl jpsStatisticsReportServiceImpl = this;
        HttpReportSettings httpReportSettings2 = httpReportSettings;
        if (httpReportSettings2 != null) {
            void it;
            HttpReportSettings httpReportSettings3 = httpReportSettings2;
            JpsStatisticsReportServiceImpl jpsStatisticsReportServiceImpl2 = jpsStatisticsReportServiceImpl;
            boolean bl = false;
            httpReportService = new HttpReportService(it.getUrl(), it.getUser(), it.getPassword());
            jpsStatisticsReportServiceImpl = jpsStatisticsReportServiceImpl2;
        } else {
            httpReportService = null;
        }
        jpsStatisticsReportServiceImpl.httpService = httpReportService;
    }

    @Override
    public void moduleBuildStarted(@NotNull ModuleChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        String string2 = chunk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"chunk.name");
        String moduleName = string2;
        JpsBuilderMetricReporterImpl jpsReporter = new JpsBuilderMetricReporterImpl(chunk, new BuildMetricsReporterImpl(), null, null, 12, null);
        if (!Intrinsics.areEqual((Object)this.buildMetrics.putIfAbsent(moduleName, jpsReporter), (Object)jpsReporter)) {
            this.log.warn("Service already initialized for " + moduleName + " module");
            return;
        }
        this.log.debug("JpsStatisticsReportService: Build started for " + moduleName + " module");
    }

    @Override
    @Nullable
    public JpsBuilderMetricReporter getMetricReporter(@NotNull ModuleChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        String string2 = chunk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"chunk.name");
        String moduleName = string2;
        return this.getMetricReporter(moduleName);
    }

    private final JpsBuilderMetricReporter getMetricReporter(String moduleName) {
        JpsBuilderMetricReporter metricReporter = this.buildMetrics.get(moduleName);
        if (metricReporter == null) {
            this.log.warn("Service hasn't initialized for " + moduleName + " module");
            return null;
        }
        return metricReporter;
    }

    @Override
    public void moduleBuildFinished(@NotNull ModuleChunk chunk, @NotNull CompileContext context, @NotNull ModuleLevelBuilder.ExitCode exitCode) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        String string2 = chunk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"chunk.name");
        String moduleName = string2;
        JpsBuilderMetricReporter metrics = this.buildMetrics.remove(moduleName);
        if (metrics == null) {
            this.log.warn("Service hasn't initialized for " + moduleName + " module");
            return;
        }
        this.log.debug("JpsStatisticsReportService: Build started for " + moduleName + " module");
        metrics.buildFinish(chunk, context, exitCode.name());
        this.finishedModuleBuildMetrics.add(metrics);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void buildFinish(@NotNull CompileContext context) {
        block2: {
            FileReportSettings fileReportSettings;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$map$iv = this.finishedModuleBuildMetrics;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JpsBuilderMetricReporter jpsBuilderMetricReporter = (JpsBuilderMetricReporter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.flush(context));
            }
            List compileStatisticsData = (List)destination$iv$iv;
            HttpReportService httpReportService = this.httpService;
            if (httpReportService != null) {
                httpReportService.sendData(compileStatisticsData, this.loggerAdapter);
            }
            FileReportSettings fileReportSettings2 = this.fileReportSettings;
            if (fileReportSettings2 == null) break block2;
            FileReportSettings it = fileReportSettings = fileReportSettings2;
            boolean bl = false;
            File file2 = it.getBuildReportDir();
            String string2 = context.getProjectDescriptor().getProject().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.projectDescriptor.project.name");
            new JpsFileReportService(file2, string2, true, it.getChangedFileListPerLimit()).process(new ReadableFileReportData(compileStatisticsData, new BuildStartParameters(CollectionsKt.listOf((Object)"JPS build"), null, null, null, null, 30, null), CollectionsKt.emptyList(), 0, 8, null), this.loggerAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T reportMetrics(@NotNull ModuleChunk chunk, @NotNull JpsBuildTime metric, @NotNull Function0<? extends T> action) {
        Object object;
        block7: {
            block6: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
                Intrinsics.checkNotNullParameter(action, (String)"action");
                object = this.getMetricReporter(chunk);
                if (object == null) break block6;
                BuildMetricsReporter $this$measure$iv = (BuildMetricsReporter)object;
                boolean $i$f$measure = false;
                $this$measure$iv.startMeasure((BuildTime)metric);
                try {
                    Object object3 = action.invoke();
                    object2 = object3;
                }
                finally {
                    $this$measure$iv.endMeasure((BuildTime)metric);
                }
                object = object2;
                if (object2 != null) break block7;
            }
            object = action.invoke();
        }
        return (T)object;
    }

    @Override
    public void reportDirtyFiles(@NotNull KotlinDirtySourceFilesHolder kotlinDirtySourceFilesHolder) {
        block2: {
            File it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)kotlinDirtySourceFilesHolder, (String)"kotlinDirtySourceFilesHolder");
            JpsBuilderMetricReporter jpsBuilderMetricReporter = this.getMetricReporter(kotlinDirtySourceFilesHolder.getChunk());
            if (jpsBuilderMetricReporter == null) break block2;
            JpsBuilderMetricReporter it2 = jpsBuilderMetricReporter;
            boolean bl = false;
            Iterable iterable = kotlinDirtySourceFilesHolder.getAllRemovedFilesFiles();
            JpsBuilderMetricReporter jpsBuilderMetricReporter2 = it2;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getPath());
            }
            jpsBuilderMetricReporter2.addChangedFiles((List)destination$iv$iv);
            $this$map$iv = kotlinDirtySourceFilesHolder.getAllDirtyFiles();
            jpsBuilderMetricReporter2 = it2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getPath());
            }
            jpsBuilderMetricReporter2.addChangedFiles((List)destination$iv$iv);
        }
    }

    @Override
    public void reportCompilerArguments(@NotNull ModuleChunk chunk, @NotNull KotlinChunk kotlinChunk) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter((Object)kotlinChunk, (String)"kotlinChunk");
            JpsBuilderMetricReporter jpsBuilderMetricReporter = this.getMetricReporter(chunk);
            if (jpsBuilderMetricReporter == null) break block0;
            JpsBuilderMetricReporter it = jpsBuilderMetricReporter;
            boolean bl = false;
            it.addCompilerArguments(kotlinChunk.getCompilerArguments().getFreeArgs());
            it.setKotlinLanguageVersion(kotlinChunk.getCompilerArguments().getLanguageVersion());
        }
    }

    @Override
    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.loggerAdapter.info("Build started for " + context + " with enabled build metric reports.");
    }
}

