/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.impl.StateBase;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TerminationStateImpl
extends StateBase
implements PrevAwareState {
    private final TraceElement myResult;
    private final StreamCall myPrevCall;
    private final Map<TraceElement, List<TraceElement>> myToPrev;

    TerminationStateImpl(@NotNull TraceElement result, @NotNull StreamCall prevCall, @NotNull List<TraceElement> elements, @NotNull Map<TraceElement, List<TraceElement>> toPrevMapping) {
        if (result == null) {
            TerminationStateImpl.$$$reportNull$$$0(0);
        }
        if (prevCall == null) {
            TerminationStateImpl.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            TerminationStateImpl.$$$reportNull$$$0(2);
        }
        if (toPrevMapping == null) {
            TerminationStateImpl.$$$reportNull$$$0(3);
        }
        super(elements);
        this.myResult = result;
        this.myPrevCall = prevCall;
        this.myToPrev = toPrevMapping;
    }

    @Override
    @NotNull
    public List<Value> getRawValues() {
        List<Value> list = Collections.singletonList(this.myResult.getValue());
        if (list == null) {
            TerminationStateImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public StreamCall getPrevCall() {
        StreamCall streamCall = this.myPrevCall;
        if (streamCall == null) {
            TerminationStateImpl.$$$reportNull$$$0(5);
        }
        return streamCall;
    }

    @Override
    @NotNull
    public List<TraceElement> getPrevValues(@NotNull TraceElement value) {
        if (value == null) {
            TerminationStateImpl.$$$reportNull$$$0(6);
        }
        List<TraceElement> list = this.myToPrev.getOrDefault(value, Collections.emptyList());
        if (list == null) {
            TerminationStateImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPrevMapping";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/trace/impl/TerminationStateImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/trace/impl/TerminationStateImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevCall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPrevValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

