/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.types;

import com.intellij.debugger.mockJDI.MockLocation;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.members.MockConstructor;
import com.intellij.debugger.mockJDI.members.MockField;
import com.intellij.debugger.mockJDI.members.MockMethod;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.types.SMAPInfo;
import com.intellij.debugger.mockJDI.values.MockClassLoaderReference;
import com.intellij.debugger.mockJDI.values.MockValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class MockReferenceType
extends MockType
implements ReferenceType {
    private static final Logger LOG = Logger.getInstance(MockReferenceType.class);
    protected Class<?> myType;
    private List<String> mySourcePaths;
    private List<String> mySourceNames;
    private Map<Integer, List<Location>> myLine2Locations;
    private boolean mySMAPComputed;
    private SMAPInfo mySmapInfo;

    protected MockReferenceType(Class<?> type, MockVirtualMachine virtualMachine) {
        super(virtualMachine);
        this.myType = type;
        LOG.assertTrue(type == null || !type.isPrimitive());
    }

    @Override
    public String signature() {
        return "L" + this.name().replace('.', '/') + ";";
    }

    @Override
    public String name() {
        return this.myType.getName();
    }

    @Override
    public String genericSignature() {
        throw new UnsupportedOperationException("Not implemented: \"genericSignature\" in " + this.getClass().getName());
    }

    @Override
    public ClassLoaderReference classLoader() {
        return new MockClassLoaderReference(this.myVirtualMachine, this.myType.getClassLoader());
    }

    @Override
    public String sourceName() {
        List<String> names = this.sourceNames(null);
        return names.isEmpty() ? null : names.get(0);
    }

    @Override
    public List<String> sourceNames(String string) {
        if (this.mySourceNames == null) {
            List<String> paths = this.sourcePaths(string);
            this.mySourceNames = new ArrayList<String>(paths.size());
            for (String path : paths) {
                int i2 = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
                this.mySourceNames.add(path.substring(i2 + 1));
            }
        }
        return this.mySourceNames;
    }

    @Nullable
    private SMAPInfo getSmapInfo() {
        if (!this.mySMAPComputed) {
            this.myVirtualMachine.getReader(this.myType).accept(new ClassVisitor(589824){

                public void visitSource(String source, String debug) {
                    if (debug != null) {
                        MockReferenceType.this.mySmapInfo = SMAPInfo.parse(new StringReader(debug));
                    }
                }
            }, 0);
            this.mySMAPComputed = true;
        }
        return this.mySmapInfo;
    }

    @Override
    public List<String> sourcePaths(String stratum) {
        if (this.mySourcePaths == null) {
            this.mySourcePaths = new ArrayList<String>();
            SMAPInfo smapInfo = this.getSmapInfo();
            if (smapInfo == null) {
                ClassReader reader = this.myVirtualMachine.getReader(this.myType);
                reader.accept(new ClassVisitor(589824){

                    public void visitSource(String source, String debug) {
                        MockReferenceType.this.mySourcePaths.add(source);
                    }
                }, 0);
            } else {
                for (SMAPInfo.FileInfo info : smapInfo.getStratum(stratum).getFileInfos()) {
                    String path = info.getPath();
                    if (path == null) continue;
                    this.mySourcePaths.add(path);
                }
            }
        }
        return this.mySourcePaths;
    }

    @Override
    public String sourceDebugExtension() {
        throw new UnsupportedOperationException("Not implemented: \"sourceDebugExtension\" in " + this.getClass().getName());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.myType.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.myType.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.myType.getModifiers());
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public boolean isVerified() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean failedToInitialize() {
        return false;
    }

    @Override
    public List<com.sun.jdi.Field> fields() {
        ArrayList<com.sun.jdi.Field> fields = new ArrayList<com.sun.jdi.Field>();
        for (Field field : this.myType.getDeclaredFields()) {
            fields.add(new MockField(field, this.myVirtualMachine));
        }
        return fields;
    }

    @Override
    public List<com.sun.jdi.Field> visibleFields() {
        ArrayList<com.sun.jdi.Field> fields = new ArrayList<com.sun.jdi.Field>();
        for (Field field : this.myType.getFields()) {
            fields.add(new MockField(field, this.myVirtualMachine));
        }
        return fields;
    }

    @Override
    public List<com.sun.jdi.Field> allFields() {
        ArrayList<com.sun.jdi.Field> fields = new ArrayList<com.sun.jdi.Field>();
        List<ReferenceType> supers = this.getThisAndAllSupers();
        for (ReferenceType referenceType : supers) {
            fields.addAll(referenceType.fields());
        }
        return fields;
    }

    @Override
    public com.sun.jdi.Field fieldByName(String string) {
        for (com.sun.jdi.Field field : this.fields()) {
            if (!field.name().equals(string)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<com.sun.jdi.Method> methods() {
        ArrayList<com.sun.jdi.Method> methods = new ArrayList<com.sun.jdi.Method>();
        for (Constructor<?> constructor : this.myType.getDeclaredConstructors()) {
            methods.add(new MockConstructor(constructor, this.myVirtualMachine));
        }
        for (Executable executable : this.myType.getDeclaredMethods()) {
            methods.add(new MockMethod((Method)executable, this.myVirtualMachine));
        }
        return methods;
    }

    @Override
    public List<com.sun.jdi.Method> visibleMethods() {
        ArrayList<com.sun.jdi.Method> methods = new ArrayList<com.sun.jdi.Method>();
        for (Constructor<?> constructor : this.myType.getConstructors()) {
            methods.add(new MockConstructor(constructor, this.myVirtualMachine));
        }
        for (Executable executable : this.myType.getMethods()) {
            methods.add(new MockMethod((Method)executable, this.myVirtualMachine));
        }
        return methods;
    }

    @Override
    public List<com.sun.jdi.Method> allMethods() {
        ArrayList<com.sun.jdi.Method> methods = new ArrayList<com.sun.jdi.Method>();
        List<ReferenceType> supers = this.getThisAndAllSupers();
        for (ReferenceType referenceType : supers) {
            methods.addAll(referenceType.methods());
        }
        return methods;
    }

    protected abstract List<ReferenceType> getThisAndAllSupers();

    @Override
    public List<com.sun.jdi.Method> methodsByName(String string) {
        return ContainerUtil.filter(this.allMethods(), method -> method.name().equals(string));
    }

    @Override
    public List<com.sun.jdi.Method> methodsByName(String string, String string1) {
        return ContainerUtil.filter(this.allMethods(), method -> method.name().equals(string) && method.signature().equals(string1));
    }

    @Override
    public List<ReferenceType> nestedTypes() {
        ArrayList<ReferenceType> referenceTypes = new ArrayList<ReferenceType>();
        for (Class<?> aClass : this.myType.getDeclaredClasses()) {
            referenceTypes.add(this.myVirtualMachine.createReferenceType(aClass));
        }
        return referenceTypes;
    }

    @Override
    public Value getValue(com.sun.jdi.Field field) {
        try {
            Field refField = ((MockField)field).getField();
            refField.setAccessible(true);
            return MockValue.createValue(refField.get(null), refField.getType(), this.myVirtualMachine);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<com.sun.jdi.Field, Value> getValues(List<? extends com.sun.jdi.Field> list) {
        throw new UnsupportedOperationException("Not implemented: \"getValues\" in " + this.getClass().getName());
    }

    @Override
    public ClassObjectReference classObject() {
        throw new UnsupportedOperationException("Not implemented: \"classObject\" in " + this.getClass().getName());
    }

    @Override
    public List<Location> allLineLocations() {
        throw new UnsupportedOperationException("'allLineLocations' not implemented in " + this.getClass().getName());
    }

    @Override
    public List<Location> allLineLocations(String string, String string1) {
        return this.allLineLocations();
    }

    @Override
    public List<Location> locationsOfLine(final String stratum, String string1, int line) {
        if (this.myLine2Locations == null) {
            this.myLine2Locations = new HashMap<Integer, List<Location>>();
            ClassReader reader = this.myVirtualMachine.getReader(this.myType);
            reader.accept(new ClassVisitor(589824){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    List<com.sun.jdi.Method> methods = MockReferenceType.this.methodsByName(name, desc);
                    if (methods.isEmpty()) {
                        return super.visitMethod(access, name, desc, signature, exceptions);
                    }
                    return new LineNumbersEvaluatingVisitor(stratum, methods.get(0));
                }
            }, 0);
        }
        return this.myLine2Locations.get(line);
    }

    @Override
    public List<Location> locationsOfLine(int i2) {
        return this.locationsOfLine(this.myVirtualMachine.getDefaultStratum(), null, i2);
    }

    @Override
    public List<String> availableStrata() {
        return new ArrayList<String>();
    }

    @Override
    public String defaultStratum() {
        throw new UnsupportedOperationException("Not implemented: \"defaultStratum\" in " + this.getClass().getName());
    }

    @Override
    public int compareTo(ReferenceType o) {
        throw new UnsupportedOperationException("Not implemented: \"compareTo\" in " + this.getClass().getName());
    }

    @Override
    public int modifiers() {
        return this.myType.getModifiers();
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.myType.getModifiers());
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.myType.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.myType.getModifiers());
    }

    protected Class[] getAllInterfaces() {
        HashSet interfaces = new HashSet();
        MockReferenceType.addInterfaces(interfaces, this.myType);
        return interfaces.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    private static void addInterfaces(Set<Class<?>> interfaces, Class type) {
        for (Class<?> aClass : type.getInterfaces()) {
            interfaces.add(aClass);
            MockReferenceType.addInterfaces(interfaces, aClass);
        }
    }

    public List<InterfaceType> allInterfaces() {
        ArrayList<InterfaceType> interfaceTypes = new ArrayList<InterfaceType>();
        for (Class aClass : this.getAllInterfaces()) {
            interfaceTypes.add(this.myVirtualMachine.createInterfaceType(aClass));
        }
        return interfaceTypes;
    }

    private class LineNumbersEvaluatingVisitor
    extends MethodVisitor {
        private final String myStratum;
        private final com.sun.jdi.Method myMethod;

        LineNumbersEvaluatingVisitor(String stratum, com.sun.jdi.Method method) {
            super(589824);
            this.myStratum = stratum;
            this.myMethod = method;
        }

        public void visitLineNumber(int line, Label start) {
            SMAPInfo smapInfo = MockReferenceType.this.getSmapInfo();
            if (smapInfo != null) {
                SMAPInfo.FileInfo[] infos;
                for (SMAPInfo.FileInfo info : infos = smapInfo.getStratum(this.myStratum).getFileInfos()) {
                    int inputLine = info.getInputLine(line);
                    if (inputLine == -1) continue;
                    this.addLocation(new MockLocation(inputLine, -1L, this.myMethod, info.getPath(), info.getName()));
                }
            } else {
                this.addLocation(new MockLocation(line, -1L, this.myMethod));
            }
        }

        private void addLocation(MockLocation location) {
            int line = location.lineNumber();
            List<Location> list = MockReferenceType.this.myLine2Locations.get(line);
            if (list == null) {
                list = new ArrayList<Location>();
                MockReferenceType.this.myLine2Locations.put(line, list);
            }
            list.add(location);
        }
    }
}

