/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportCommunicator;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.PsiTestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class FrameworkSupportProviderTestCase
extends JavaProjectTestCase {
    private FrameworkSupportModelBase myFrameworkSupportModel;
    private Map<FrameworkType, FrameworkSupportInModuleConfigurable> myConfigurables;
    private Map<FrameworkType, FrameworkSupportNode> myNodes;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Project project = this.getProject();
        this.myFrameworkSupportModel = new FrameworkSupportModelImpl(project, "", LibrariesContainerFactory.createContainer((Project)project));
        this.myNodes = new LinkedHashMap<FrameworkType, FrameworkSupportNode>();
        List providers = FrameworkSupportUtil.getAllProviders();
        providers.sort(FrameworkSupportUtil.getFrameworkSupportProvidersComparator((List)providers));
        for (FrameworkSupportInModuleProvider provider : providers) {
            FrameworkSupportNode node = new FrameworkSupportNode(provider, null, this.myFrameworkSupportModel, this.getTestRootDisposable());
            this.myNodes.put((FrameworkType)provider.getFrameworkType(), node);
            this.myFrameworkSupportModel.registerComponent(provider, node);
        }
        this.myConfigurables = new HashMap<FrameworkType, FrameworkSupportInModuleConfigurable>();
    }

    protected void addSupport() {
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            VirtualFile root = this.getTempDir().createVirtualDir();
            PsiTestUtil.addContentRoot(this.myModule, root);
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            try {
                ArrayList<FrameworkSupportConfigurable> selectedConfigurables = new ArrayList<FrameworkSupportConfigurable>();
                IdeaModifiableModelsProvider modelsProvider = new IdeaModifiableModelsProvider();
                for (FrameworkSupportNode node : this.myNodes.values()) {
                    if (!node.isChecked()) continue;
                    FrameworkSupportInModuleConfigurable configurable = this.getOrCreateConfigurable((FrameworkSupportInModuleProvider)node.getUserObject());
                    configurable.addSupport(this.myModule, model, (ModifiableModelsProvider)modelsProvider);
                    if (!(configurable instanceof OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)) continue;
                    selectedConfigurables.add(((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)configurable).getConfigurable());
                }
                for (FrameworkSupportCommunicator communicator : (FrameworkSupportCommunicator[])FrameworkSupportCommunicator.EP_NAME.getExtensions()) {
                    communicator.onFrameworkSupportAdded(this.myModule, model, selectedConfigurables, (FrameworkSupportModel)this.myFrameworkSupportModel);
                }
            }
            finally {
                model.commit();
            }
            for (FrameworkSupportInModuleConfigurable configurable : this.myConfigurables.values()) {
                Disposer.dispose((Disposable)configurable);
            }
        });
    }

    protected FrameworkSupportInModuleConfigurable selectFramework(@NotNull FacetTypeId<?> id) {
        if (id == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(0);
        }
        return this.selectFramework(FacetBasedFrameworkSupportProvider.getProviderId(id));
    }

    protected FrameworkSupportInModuleConfigurable selectFramework(@NotNull String id) {
        FrameworkSupportInModuleProvider provider;
        if (id == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(1);
        }
        if ((provider = FrameworkSupportUtil.findProvider((String)id, (List)FrameworkSupportUtil.getAllProviders())) != null) {
            return this.selectFramework(provider);
        }
        FrameworkSupportProviderTestCase.fail((String)("Framework provider with id='" + id + "' not found"));
        return null;
    }

    protected FrameworkSupportInModuleConfigurable selectFramework(@NotNull FrameworkSupportInModuleProvider provider) {
        if (provider == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(2);
        }
        FrameworkSupportInModuleConfigurable configurable = this.getOrCreateConfigurable(provider);
        this.myNodes.get(provider.getFrameworkType()).setChecked(true);
        configurable.onFrameworkSelectionChanged(true);
        return configurable;
    }

    private FrameworkSupportInModuleConfigurable getOrCreateConfigurable(FrameworkSupportInModuleProvider provider) {
        FrameworkSupportInModuleConfigurable configurable = this.myConfigurables.get(provider.getFrameworkType());
        if (configurable == null) {
            configurable = provider.createConfigurable((FrameworkSupportModel)this.myFrameworkSupportModel);
            this.myConfigurables.put((FrameworkType)provider.getFrameworkType(), configurable);
        }
        return configurable;
    }

    protected void selectVersion(FrameworkType frameworkType, FrameworkVersion version) {
        this.myFrameworkSupportModel.setSelectedVersion(frameworkType.getId(), version);
    }

    @NotNull
    protected <F extends Facet> F getFacet(FacetTypeId<F> id) {
        Facet facet = FacetManager.getInstance((Module)this.myModule).getFacetByType(id);
        FrameworkSupportProviderTestCase.assertNotNull((String)(id + " facet not found"), (Object)facet);
        Facet facet2 = facet;
        if (facet2 == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(3);
        }
        return (F)facet2;
    }

    protected VirtualFile getContentRoot() {
        return ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/frameworkSupport/FrameworkSupportProviderTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/frameworkSupport/FrameworkSupportProviderTestCase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectFramework";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

