/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTypeVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00120\u0010\u0006\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0006\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrVisibilityChecker;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeVisitorVoid;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "reportError", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "", "", "Lorg/jetbrains/kotlin/backend/common/ReportIrValidationError;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function4;)V", "parentChain", "", "visibilityError", "element", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "visitElement", "isVisibleAsInternal", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "isVisibleAsPrivate", "checkVisibility", "referencedDeclarationSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "reference", "visitType", "container", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitDeclarationReference", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "Companion", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrVisibilityChecker.kt\norg/jetbrains/kotlin/backend/common/IrVisibilityChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,166:1\n11493#2,3:167\n*S KotlinDebug\n*F\n+ 1 IrVisibilityChecker.kt\norg/jetbrains/kotlin/backend/common/IrVisibilityChecker\n*L\n68#1:167,3\n*E\n"})
public final class IrVisibilityChecker
extends IrTypeVisitorVoid {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final IrModuleFragment module;
    @NotNull
    private final IrFile file;
    @NotNull
    private final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> reportError;
    @NotNull
    private final List<IrElement> parentChain;
    @NotNull
    private static final Set<Name> EXCLUDED_MODULE_NAMES;

    public IrVisibilityChecker(@NotNull IrModuleFragment module, @NotNull IrFile file, @NotNull Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        this.module = module;
        this.file = file;
        this.reportError = reportError;
        this.parentChain = new ArrayList();
    }

    private final void visibilityError(IrElement element, Visibility visibility) {
        String message = "The following element references " + (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Unknown.INSTANCE) ? "a declaration with unknown visibility:" : '\'' + visibility.getName() + "' declaration that is invisible in the current scope:");
        this.reportError.invoke((Object)this.file, (Object)element, (Object)message, this.parentChain);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (EXCLUDED_MODULE_NAMES.contains(this.module.getName())) {
            return;
        }
        UtilsKt.push(this.parentChain, element);
        IrVisitorsKt.acceptChildrenVoid(element, this);
        UtilsKt.pop(this.parentChain);
    }

    private final boolean isVisibleAsInternal(IrDeclarationWithVisibility $this$isVisibleAsInternal) {
        IrPackageFragment referencedDeclarationPackageFragment = IrUtilsKt.getPackageFragment($this$isVisibleAsInternal);
        if (referencedDeclarationPackageFragment.getSymbol() instanceof DescriptorlessExternalPackageFragmentSymbol) {
            return Intrinsics.areEqual((Object)this.module.getName().asString(), (Object)"<kotlin>");
        }
        return this.module.getDescriptor().shouldSeeInternalsOf(IrPackageFragmentsKt.getModuleDescriptor(referencedDeclarationPackageFragment));
    }

    private final boolean isVisibleAsPrivate(IrDeclarationWithVisibility $this$isVisibleAsPrivate) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$isVisibleAsPrivate);
        return Intrinsics.areEqual((Object)this.file.getFileEntry(), (Object)(irFile != null ? irFile.getFileEntry() : null));
    }

    private final void checkVisibility(IrSymbol referencedDeclarationSymbol, IrElement reference2) {
        boolean bl;
        IrSymbolOwner irSymbolOwner = referencedDeclarationSymbol.getOwner();
        IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
        if (irDeclarationWithVisibility == null) {
            return;
        }
        IrDeclarationWithVisibility referencedDeclaration = irDeclarationWithVisibility;
        IrClass classOfReferenced = IrUtilsKt.getParentClassOrNull(referencedDeclaration);
        Visibility visibility = referencedDeclaration.getVisibility().getDelegate();
        IrClass irClass = classOfReferenced;
        EffectiveVisibility effectiveVisibility = EffectiveVisibilityKt.toEffectiveVisibilityOrNull((Visibility)visibility, (TypeConstructorMarker)(irClass != null ? irClass.getSymbol() : null), (boolean)true, (boolean)IrUtilsKt.isPublishedApi(referencedDeclaration));
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility;
        if (effectiveVisibility2 instanceof EffectiveVisibility.Internal || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtected || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtectedBound) {
            bl = this.isVisibleAsInternal(referencedDeclaration);
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Local || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInClass || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInFile) {
            bl = this.isVisibleAsPrivate(referencedDeclaration);
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.PackagePrivate || effectiveVisibility2 instanceof EffectiveVisibility.Protected || effectiveVisibility2 instanceof EffectiveVisibility.ProtectedBound || effectiveVisibility2 instanceof EffectiveVisibility.Public) {
            bl = true;
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Unknown || effectiveVisibility2 == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVisible = bl;
        if (!isVisible) {
            this.visibilityError(reference2, visibility);
        }
    }

    @Override
    public void visitType(@NotNull IrElement container, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof IrSimpleType) {
            this.checkVisibility(((IrSimpleType)type).getClassifier(), container);
        }
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkVisibility(expression.getSymbol(), expression);
        super.visitDeclarationReference(expression);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"stdlib", "kotlin", "kotlin", "kotlin-test"};
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv;
            void var6_6 = item$iv = $this$mapTo$iv[i];
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(Name.special((String)('<' + (String)it + '>')));
        }
        EXCLUDED_MODULE_NAMES = (Set)var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrVisibilityChecker$Companion;", "", "<init>", "()V", "EXCLUDED_MODULE_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

