/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.service.ui.SelectExternalProjectDialog;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleParentProjectForm
implements Disposable {
    private static final String EMPTY_PARENT = "<none>";
    @Nullable
    private final Project myProjectOrNull;
    @Nullable
    private ProjectData myParent;
    @NotNull
    private final Consumer<ProjectData> myConsumer;
    private final boolean myIsVisible;
    private JPanel myPanel;
    private JButton mySelectParent;
    private EditorTextField myParentPathField;
    @NotNull
    private final WizardContext myContext;

    public GradleParentProjectForm(@NotNull WizardContext context, @Nullable @Nullable Consumer<@Nullable ProjectData> consumer) {
        if (context == null) {
            GradleParentProjectForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myProjectOrNull = context.getProject();
        this.myContext = context;
        this.myConsumer = consumer == null ? __ -> {} : consumer;
        this.myIsVisible = !context.isCreatingNewProject() && this.myProjectOrNull != null && GradleParentProjectForm.gradleModuleExists(context);
        this.initComponents();
    }

    private void createUIComponents() {
        this.myParentPathField = new TextViewer("", this.getProject());
    }

    private void initComponents() {
        this.myPanel.setVisible(this.myIsVisible);
        if (!this.myIsVisible) {
            return;
        }
        this.mySelectParent.setIcon(AllIcons.Nodes.Module);
        this.mySelectParent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleParentProjectForm.this.myParent = GradleParentProjectForm.this.doSelectProject(GradleParentProjectForm.this.myParent);
                GradleParentProjectForm.this.myConsumer.accept(GradleParentProjectForm.this.myParent);
            }
        });
        if (this.myParent == null) {
            this.myParent = this.findPotentialParentProject(this.myProjectOrNull);
        }
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    @Nullable
    public ProjectData getParentProject() {
        return this.myParent;
    }

    @TestOnly
    public void setParentProject(@Nullable ProjectData parent) {
        this.myParent = parent;
    }

    public boolean isVisible() {
        return this.myIsVisible;
    }

    public void updateComponents() {
        if (this.myIsVisible) {
            this.myParentPathField.setText(this.myParent == null ? EMPTY_PARENT : this.myParent.getLinkedExternalProjectPath());
            GradleParentProjectForm.collapseIfPossible(this.myParentPathField, GradleConstants.SYSTEM_ID, this.getProject());
        }
    }

    public void dispose() {
        this.myParentPathField.removeNotify();
    }

    private ProjectData doSelectProject(ProjectData current) {
        assert (this.myProjectOrNull != null) : "must not be called when creating a new project";
        SelectExternalProjectDialog d = new SelectExternalProjectDialog(GradleConstants.SYSTEM_ID, this.myProjectOrNull, current);
        if (!d.showAndGet()) {
            return current;
        }
        return d.getResult();
    }

    @NotNull
    private Project getProject() {
        Project project = this.myProjectOrNull != null ? this.myProjectOrNull : (Project)ArrayUtil.getFirstElement((Object[])ProjectManager.getInstance().getOpenProjects());
        Project project2 = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        if (project2 == null) {
            GradleParentProjectForm.$$$reportNull$$$0(1);
        }
        return project2;
    }

    @Nullable
    private ProjectData findPotentialParentProject(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        String contextProjectFileDirectory = this.myContext.getProjectFileDirectory();
        ExternalProjectSettings linkedProjectSettings = null;
        for (Object settings : ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).getLinkedProjectsSettings()) {
            String projectPath;
            if (!(settings instanceof ExternalProjectSettings) || !FileUtil.isAncestor((String)(projectPath = ((ExternalProjectSettings)settings).getExternalProjectPath()), (String)contextProjectFileDirectory, (boolean)false)) continue;
            linkedProjectSettings = (ExternalProjectSettings)settings;
            break;
        }
        if (linkedProjectSettings == null) {
            return null;
        }
        ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, linkedProjectSettings.getExternalProjectPath());
        return projectInfo != null && projectInfo.getExternalProjectStructure() != null ? (ProjectData)projectInfo.getExternalProjectStructure().getData() : null;
    }

    private static void collapseIfPossible(@NotNull EditorTextField editorTextField, @NotNull ProjectSystemId systemId, @NotNull Project project) {
        Editor editor;
        if (editorTextField == null) {
            GradleParentProjectForm.$$$reportNull$$$0(2);
        }
        if (systemId == null) {
            GradleParentProjectForm.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleParentProjectForm.$$$reportNull$$$0(4);
        }
        if ((editor = editorTextField.getEditor()) != null) {
            String rawText = editor.getDocument().getText();
            if (StringUtil.isEmpty((String)rawText)) {
                return;
            }
            if (EMPTY_PARENT.equals(rawText)) {
                editorTextField.setEnabled(false);
                return;
            }
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, systemId);
            for (ExternalProjectInfo projectInfo : projectsData) {
                if (projectInfo.getExternalProjectStructure() == null || !projectInfo.getExternalProjectPath().equals(rawText)) continue;
                editorTextField.setEnabled(true);
                ExternalProjectPathField.collapse((Editor)editorTextField.getEditor(), (String)((ProjectData)projectInfo.getExternalProjectStructure().getData()).getExternalName());
                return;
            }
        }
    }

    public static boolean gradleModuleExists(WizardContext myContext) {
        for (Module module : myContext.getModulesProvider().getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, true));
        jPanel.putClientProperty("BorderFactoryClass", "");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GradleBundle", GradleParentProjectForm.class).getString("gradle.settings.wizard.add.as.module.to"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myParentPathField;
        editorTextField.setEnabled(true);
        editorTextField.setText("");
        jPanel.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySelectParent = jButton = new JButton();
        jButton.setHorizontalAlignment(2);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setText("");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)editorTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorTextField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collapseIfPossible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class TextViewer
    extends EditorTextField {
        private final boolean myEmbeddedIntoDialogWrapper;
        private final boolean myUseSoftWraps;

        TextViewer(@NotNull String initialText, @NotNull Project project) {
            if (initialText == null) {
                TextViewer.$$$reportNull$$$0(0);
            }
            if (project == null) {
                TextViewer.$$$reportNull$$$0(1);
            }
            this(TextViewer.createDocument(initialText), project, true, true);
        }

        TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, boolean useSoftWraps) {
            if (document == null) {
                TextViewer.$$$reportNull$$$0(2);
            }
            if (project == null) {
                TextViewer.$$$reportNull$$$0(3);
            }
            super(document, project, (FileType)FileTypes.PLAIN_TEXT, true, false);
            this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
            this.myUseSoftWraps = useSoftWraps;
            this.setFontInheritedFromLAF(false);
        }

        private static Document createDocument(@NotNull String initialText) {
            if (initialText == null) {
                TextViewer.$$$reportNull$$$0(4);
            }
            return EditorFactory.getInstance().createDocument((CharSequence)initialText);
        }

        public void setText(@Nullable String text) {
            super.setText(text != null ? StringUtil.convertLineSeparators((String)text) : null);
        }

        @NotNull
        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setHorizontalScrollbarVisible(true);
            editor.setCaretEnabled(this.isEnabled());
            editor.getScrollPane().setVerticalScrollBarPolicy(20);
            editor.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
            editor.setBorder(UIUtil.getTextFieldBorder());
            editor.setOneLineMode(true);
            editor.getComponent().setPreferredSize(null);
            editor.getSettings().setUseSoftWraps(this.myUseSoftWraps);
            EditorEx editorEx = editor;
            if (editorEx == null) {
                TextViewer.$$$reportNull$$$0(5);
            }
            return editorEx;
        }

        protected void setViewerEnabled(boolean enabled) {
        }

        public void removeNotify() {
            Editor editor = this.getEditor();
            if (editor != null && !editor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor(editor);
            }
            super.removeNotify();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialText";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm$TextViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm$TextViewer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDocument";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

