/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.containers.UtilKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J(\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\"H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleDependencySourceDownloaderErrorHandler;", "", "<init>", "()V", "BUILD_GRADLE", "", "BUILD_GRADLE_KTS", "DEFAULT_FAILURE_NOTIFICATION_ID", "ARTIFACT_NOT_FOUND_IN_REPOSITORY_NOTIFICATION_ID", "artifactRepositoryRegexPattern", "artifactRepositoryRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "handle", "", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "artifact", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "showDefaultNotification", "showNotificationForRepository", "repository", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "getAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getFilePathIfFileExist", "Ljava/nio/file/Path;", "root", "fileName", "getUsedRepository", "", "findProjectRepository", "usedRepository", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleDependencySourceDownloaderErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDependencySourceDownloaderErrorHandler.kt\norg/jetbrains/plugins/gradle/util/GradleDependencySourceDownloaderErrorHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class GradleDependencySourceDownloaderErrorHandler {
    @NotNull
    public static final GradleDependencySourceDownloaderErrorHandler INSTANCE = new GradleDependencySourceDownloaderErrorHandler();
    @NotNull
    private static final String BUILD_GRADLE = "build.gradle";
    @NotNull
    private static final String BUILD_GRADLE_KTS = "build.gradle.kts";
    @NotNull
    private static final String DEFAULT_FAILURE_NOTIFICATION_ID = "gradle.notifications.sources.download.failed";
    @NotNull
    private static final String ARTIFACT_NOT_FOUND_IN_REPOSITORY_NOTIFICATION_ID = "gradle.notifications.sources.download.from.repository.failed";
    @NotNull
    private static final String artifactRepositoryRegexPattern = "Searched in the following locations:\n\\s.(.+)";
    private static final Pattern artifactRepositoryRegex = Pattern.compile(artifactRepositoryRegexPattern);

    private GradleDependencySourceDownloaderErrorHandler() {
    }

    public final void handle(@NotNull Project project, @NotNull String externalProjectPath, @NotNull String artifact, @NotNull Exception exception) {
        RemoteRepositoryDescription projectRepository;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String repository = this.getUsedRepository(exception);
        if (repository != null && (projectRepository = this.findProjectRepository(project, repository)) != null) {
            this.showNotificationForRepository(project, externalProjectPath, artifact, projectRepository);
            return;
        }
        this.showDefaultNotification(project, artifact);
    }

    private final void showDefaultNotification(Project project, String artifact) {
        NotificationGroup notificationGroup = GradleNotification.getGradleNotificationGroup();
        String string = GradleBundle.message((String)"gradle.notifications.sources.download.failed.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{artifact};
        String string2 = GradleBundle.message((String)"gradle.notifications.sources.download.failed.content", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.WARNING).setDisplayId(DEFAULT_FAILURE_NOTIFICATION_ID).notify(project);
    }

    private final void showNotificationForRepository(Project project, String externalProjectPath, String artifact, RemoteRepositoryDescription repository) {
        List actions = new ArrayList();
        UtilKt.addIfNotNull((List)actions, (Object)this.getAction(project, externalProjectPath));
        NotificationGroup notificationGroup = GradleNotification.getGradleNotificationGroup();
        String string = GradleBundle.message((String)"gradle.notifications.sources.download.failed.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{artifact, repository.getName()};
        String string2 = GradleBundle.message((String)"gradle.notifications.sources.download.from.repository.failed.content", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.WARNING).addActions((Collection)actions).setDisplayId(ARTIFACT_NOT_FOUND_IN_REPOSITORY_NOTIFICATION_ID).notify(project);
    }

    private final AnAction getAction(Project project, String externalProjectPath) {
        Path path = NioPathUtil.toNioPathOrNull((String)externalProjectPath);
        if (path == null) {
            return null;
        }
        Path projectRoot = path;
        Path path2 = this.getFilePathIfFileExist(projectRoot, BUILD_GRADLE);
        if (path2 == null && (path2 = this.getFilePathIfFileExist(projectRoot, BUILD_GRADLE_KTS)) == null) {
            return null;
        }
        Path buildScriptPath = path2;
        VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFileOrDirectory((Path)buildScriptPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile buildScriptVirtualFile = virtualFile;
        Object[] objectArray = new Object[]{buildScriptVirtualFile.getName()};
        return (AnAction)NotificationAction.createSimple((String)GradleBundle.message((String)"gradle.notifications.sources.download.action.title", (Object[])objectArray), () -> GradleDependencySourceDownloaderErrorHandler.getAction$lambda$0(buildScriptVirtualFile, project));
    }

    private final Path getFilePathIfFileExist(Path root, String fileName) {
        Path path = root.resolve(fileName);
        Intrinsics.checkNotNull((Object)path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return path;
        }
        return null;
    }

    private final String getUsedRepository(Throwable exception) {
        String string = exception.getMessage();
        Intrinsics.checkNotNull((Object)string);
        Matcher matcher = artifactRepositoryRegex.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        String string2 = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final RemoteRepositoryDescription findProjectRepository(Project project, String usedRepository) {
        Object v3;
        block1: {
            RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = RemoteRepositoriesConfiguration.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoriesConfiguration, (String)"getInstance(...)");
            RemoteRepositoriesConfiguration projectRepositories = remoteRepositoriesConfiguration;
            List list = projectRepositories.getRepositories();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                RemoteRepositoryDescription it = (RemoteRepositoryDescription)t;
                boolean bl = false;
                String string = it.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                if (!StringsKt.startsWith$default((String)usedRepository, (String)string, (boolean)false, (int)2, null)) continue;
                v3 = t;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    private static final void getAction$lambda$0(VirtualFile $buildScriptVirtualFile, Project $project) {
        if ($buildScriptVirtualFile.isValid()) {
            FileEditorManager.getInstance((Project)$project).openFile($buildScriptVirtualFile);
        }
    }
}

