/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.RadiotapPresentBitNumber;
import org.pcap4j.util.ByteArrays;

public final class RadiotapPresentBitmask
implements Serializable {
    private static final long serialVersionUID = -4525947413002802922L;
    private final String namespace;
    private final List<RadiotapPresentBitNumber> bitNumbers;
    private final boolean radiotapNamespaceNext;
    private final boolean vendorNamespaceNext;
    private final boolean anotherBitmapFollows;

    public static RadiotapPresentBitmask newInstance(byte[] rawData, int offset, int length, int bitNumOffset) throws IllegalRawDataException {
        return RadiotapPresentBitmask.newInstance(rawData, offset, length, bitNumOffset, "");
    }

    public static RadiotapPresentBitmask newInstance(byte[] rawData, int offset, int length, int bitNumOffset, String namespace) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapPresentBitmask(rawData, offset, length, bitNumOffset, namespace);
    }

    private RadiotapPresentBitmask(byte[] rawData, int offset, int length, int bitNumOffset, String namespace) throws IllegalRawDataException {
        if (4 > length) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapPresentBitmask (").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.namespace = namespace;
        this.bitNumbers = new ArrayList<RadiotapPresentBitNumber>();
        int bitNum = bitNumOffset;
        boolean isRadiotapNsBitSet = false;
        boolean isVendorNsBitSet = false;
        boolean isAnotherBitmapFollowsBitSet = false;
        for (int i = 0; i < 4; ++i) {
            byte mask = rawData[offset + i];
            for (int j = 0; j < 8; ++j) {
                if ((mask & 1) != 0) {
                    switch (bitNum % 32) {
                        case 29: {
                            isRadiotapNsBitSet = true;
                            break;
                        }
                        case 30: {
                            isVendorNsBitSet = true;
                            break;
                        }
                        case 31: {
                            isAnotherBitmapFollowsBitSet = true;
                            break;
                        }
                        default: {
                            this.bitNumbers.add(RadiotapPresentBitNumber.getInstance(bitNum, namespace));
                        }
                    }
                }
                ++bitNum;
                mask = (byte)(mask >>> 1);
            }
        }
        this.radiotapNamespaceNext = isRadiotapNsBitSet;
        this.vendorNamespaceNext = isVendorNsBitSet;
        this.anotherBitmapFollows = isAnotherBitmapFollowsBitSet;
    }

    private RadiotapPresentBitmask(Builder builder2) {
        if (builder2 == null || builder2.namespace == null || builder2.bitNumbers == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.namespace: ").append(builder2.namespace).append(" builder.bitNumbers: ").append(builder2.bitNumbers);
            throw new NullPointerException(sb.toString());
        }
        if (builder2.bitNumbers.size() > 29) {
            throw new IllegalArgumentException("bitNumbers.size() must be less than 30 but is: " + builder2.bitNumbers.size());
        }
        this.namespace = builder2.namespace;
        this.bitNumbers = new ArrayList<RadiotapPresentBitNumber>(builder2.bitNumbers);
        this.radiotapNamespaceNext = builder2.radiotapNamespaceNext;
        this.vendorNamespaceNext = builder2.vendorNamespaceNext;
        this.anotherBitmapFollows = builder2.anotherBitmapFollows;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ArrayList<RadiotapPresentBitNumber> getBitNumbers() {
        return new ArrayList<RadiotapPresentBitNumber>(this.bitNumbers);
    }

    public boolean isRadiotapNamespaceNext() {
        return this.radiotapNamespaceNext;
    }

    public boolean isVendorNamespaceNext() {
        return this.vendorNamespaceNext;
    }

    public boolean isAnotherBitmapFollows() {
        return this.anotherBitmapFollows;
    }

    public byte[] getBitmask() {
        return this.getRawData();
    }

    public int length() {
        return 4;
    }

    public byte[] getRawData() {
        byte[] data = new byte[this.length()];
        for (RadiotapPresentBitNumber num : this.bitNumbers) {
            int bit = (Integer)num.value() % 32;
            int n = bit / 8;
            data[n] = (byte)(data[n] | 1 << bit % 8);
        }
        if (this.radiotapNamespaceNext) {
            data[3] = (byte)(data[3] | 0x20);
        }
        if (this.vendorNamespaceNext) {
            data[3] = (byte)(data[3] | 0x40);
        }
        if (this.radiotapNamespaceNext) {
            data[3] = (byte)(data[3] | 0x80);
        }
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Present Bitmask (").append(ByteArrays.toHexString(this.getRawData(), " ")).append("):").append(ls).append(indent).append("  Present Fields: ").append(ls);
        for (RadiotapPresentBitNumber num : this.bitNumbers) {
            sb.append(indent).append("    ").append(num).append(ls);
        }
        sb.append(indent).append("  Radiotap NS Next: ").append(this.radiotapNamespaceNext).append(ls).append(indent).append("  Vendor NS Next: ").append(this.vendorNamespaceNext).append(ls).append(indent).append("  Another Bitmap Follows: ").append(this.anotherBitmapFollows).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anotherBitmapFollows ? 1231 : 1237);
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + this.bitNumbers.hashCode();
        result = 31 * result + (this.radiotapNamespaceNext ? 1231 : 1237);
        result = 31 * result + (this.vendorNamespaceNext ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapPresentBitmask other = (RadiotapPresentBitmask)obj;
        return this.bitNumbers.equals(other.bitNumbers) && this.namespace.equals(other.namespace) && this.radiotapNamespaceNext == other.radiotapNamespaceNext && this.vendorNamespaceNext == other.vendorNamespaceNext && this.anotherBitmapFollows == other.anotherBitmapFollows;
    }

    public static final class Builder {
        private String namespace;
        private List<RadiotapPresentBitNumber> bitNumbers;
        private boolean radiotapNamespaceNext;
        private boolean vendorNamespaceNext;
        private boolean anotherBitmapFollows;

        public Builder() {
        }

        private Builder(RadiotapPresentBitmask rp) {
            this.namespace = rp.namespace;
            this.bitNumbers = rp.bitNumbers;
            this.radiotapNamespaceNext = rp.radiotapNamespaceNext;
            this.vendorNamespaceNext = rp.vendorNamespaceNext;
            this.anotherBitmapFollows = rp.anotherBitmapFollows;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder bitNumbers(List<RadiotapPresentBitNumber> bitNumbers) {
            this.bitNumbers = bitNumbers;
            return this;
        }

        public Builder radiotapNamespaceNext(boolean radiotapNamespaceNext) {
            this.radiotapNamespaceNext = radiotapNamespaceNext;
            return this;
        }

        public Builder vendorNamespaceNext(boolean vendorNamespaceNext) {
            this.vendorNamespaceNext = vendorNamespaceNext;
            return this;
        }

        public Builder anotherBitmapFollows(boolean anotherBitmapFollows) {
            this.anotherBitmapFollows = anotherBitmapFollows;
            return this;
        }

        public RadiotapPresentBitmask build() {
            return new RadiotapPresentBitmask(this);
        }
    }
}

