/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBAction;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class CBDialog
extends JDialog {
    boolean cancelled = false;
    public CBButton OK;
    public CBButton Cancel;
    public CBButton Help;
    public CBPanel display;
    protected Frame owner;
    protected JPanel buttonPanel;

    public CBDialog(Frame owner, String title, String helpLink) {
        super(owner);
        this.owner = owner;
        this.setModal(true);
        this.setTitle(title);
        this.display = new CBPanel();
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.OK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click here to make the changes."));
        this.buttonPanel.add(this.OK);
        this.Cancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to exit."));
        this.buttonPanel.add(this.Cancel);
        this.setHelpLink(helpLink);
        pane.add(this.display);
        pane.add((Component)this.buttonPanel, "South");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", new MyAction(10));
        this.display.getActionMap().put("escape", new MyAction(27));
        this.Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CBDialog.this.doCancel();
            }
        });
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CBDialog.this.doOK();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CBDialog.this.doCancel();
            }
        });
    }

    public void setHelpLink(String helpLink) {
        if (helpLink != null) {
            this.Help = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help."));
            this.buttonPanel.add(this.Help);
            CBHelpSystem.useDefaultHelp(this.Help, helpLink);
        }
    }

    public CBPanel getDisplayPanel() {
        return this.display;
    }

    public Component add(Component comp) {
        this.display.add(comp);
        return comp;
    }

    public void addln(Component comp) {
        this.display.addln(comp);
    }

    public void makeHeavy() {
        this.display.makeHeavy();
    }

    public void makeLight() {
        this.display.makeLight();
    }

    public void makeWide() {
        this.display.makeWide();
    }

    public void doCancel() {
        this.cancelled = true;
        this.quit();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public void doOK() {
        this.quit();
    }

    public void quit() {
        this.setVisible(false);
        this.dispose();
    }

    private class MyAction
    extends CBAction {
        public MyAction(int key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.getKey() == 27) {
                CBDialog.this.doCancel();
            } else if (this.getKey() == 10) {
                CBDialog.this.OK.doClick();
            }
        }
    }
}

